/*********************************************************************
 * Copyright (c) 2004, 2007 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column;

import org.eclipse.nebula.widgets.xviewer.XViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

/**
 * @author Donald G. Dunne
 */
public class LastModifiedByColumn extends XViewerValueColumn {

   public static final String FRAMEWORK_LAST_MOD_BY = "framework.lastModBy";
   public static LastModifiedByColumn instance = new LastModifiedByColumn();

   public static LastModifiedByColumn getInstance() {
      return instance;
   }

   public LastModifiedByColumn() {
      this(false);
   }

   public LastModifiedByColumn(boolean show) {
      super(FRAMEWORK_LAST_MOD_BY, "Last Modified By", 50, XViewerAlign.Left, show, SortDataType.String, false,
         "Retrieves user of last attribute update of this artifact.");
   }

   /**
    * XViewer uses copies of column definitions so originals that are registered are not corrupted. Classes extending
    * XViewerValueColumn MUST extend this constructor so the correct sub-class is created
    */
   @Override
   public LastModifiedByColumn copy() {
      LastModifiedByColumn newXCol = new LastModifiedByColumn(isShow());
      super.copy(this, newXCol);
      return newXCol;
   }

   @Override
   public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
      try {
         if (element instanceof Artifact) {
            return ((Artifact) element).getLastModifiedBy().getName();
         } else if (element instanceof Change) {
            UserToken user = ((Change) element).getChangeArtifact().getLastModifiedBy();
            return user.getName();
         }
      } catch (OseeCoreException ex) {
         return LogUtil.getCellExceptionString(ex);
      }
      return "";
   }
}