/*********************************************************************
 * Copyright (c) 2004, 2007 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column;

import org.eclipse.nebula.widgets.xviewer.XViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

/**
 * @author Donald G. Dunne
 */
public class LastModifiedTransactionColumn extends XViewerValueColumn {

   public static final String FRAMEWORK_LAST_MOD_TRANS = "framework.lastModTransaction";
   public static LastModifiedTransactionColumn instance = new LastModifiedTransactionColumn();

   public static LastModifiedTransactionColumn getInstance() {
      return instance;
   }

   public LastModifiedTransactionColumn() {
      this(false);
   }

   public LastModifiedTransactionColumn(boolean show) {
      super(FRAMEWORK_LAST_MOD_TRANS, "Last Modified Transaction", 50, XViewerAlign.Left, show, SortDataType.Integer,
         false, "Retrieves user of last transaction that modified this artifact.");
   }

   /**
    * XViewer uses copies of column definitions so originals that are registered are not corrupted. Classes extending
    * XViewerValueColumn MUST extend this constructor so the correct sub-class is created
    */
   @Override
   public LastModifiedTransactionColumn copy() {
      LastModifiedTransactionColumn newXCol = new LastModifiedTransactionColumn(isShow());
      super.copy(this, newXCol);
      return newXCol;
   }

   @Override
   public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
      try {
         if (element instanceof Artifact) {
            return String.valueOf(((Artifact) element).getTransaction().getId());
         } else if (element instanceof Change) {
            return String.valueOf(((Change) element).getChangeArtifact().getId());
         }
      } catch (OseeCoreException ex) {
         return LogUtil.getCellExceptionString(ex);
      }
      return "";
   }

}
