/*********************************************************************
 * Copyright (c) 2015 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.ats.api.task;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.TasksFromAction;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;

/**
 * @author Donald G. Dunne
 */
@Path("task")
@Swagger
public interface AtsTaskEndpointApi {

   @PUT
   @Consumes(MediaType.APPLICATION_JSON)
   @Produces(MediaType.APPLICATION_JSON)
   public NewTaskSet create(NewTaskSet newTaskSet);

   @GET
   @Path("{taskId}")
   @Produces(MediaType.APPLICATION_JSON)
   public JaxAtsTask get(@PathParam("taskId") long taskId);

   @DELETE
   @Path("{taskId}")
   public void delete(@PathParam("taskId") long taskId);

   @PUT
   @Path("chgRpt")
   @Consumes(MediaType.APPLICATION_JSON)
   @Produces(MediaType.APPLICATION_JSON)
   public ChangeReportTaskData create(ChangeReportTaskData data);

   @PUT
   @Path("createTasksFromActions")
   @Consumes(MediaType.APPLICATION_JSON)
   @Produces(MediaType.APPLICATION_JSON)
   public TasksFromAction create(TasksFromAction tfa);

   @PUT
   @Path("restoreActionsFromTasks")
   @Consumes(MediaType.APPLICATION_JSON)
   @Produces(MediaType.APPLICATION_JSON)
   public TasksFromAction restore(TasksFromAction tfa);

}
