/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.GetRemoteFolderChildrenOperation;
import org.eclipse.team.svn.core.operation.remote.PreparedBranchTagOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.dialog.OperationErrorDialog;
import org.eclipse.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.eclipse.team.svn.ui.panel.common.AbstractBranchTagPanel;
import org.eclipse.team.svn.ui.panel.common.BranchPanel;
import org.eclipse.team.svn.ui.panel.common.TagPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchTagAction
extends AbstractRepositoryTeamAction {
    public static final int BRANCH_ACTION = 0;
    public static final int TAG_ACTION = 1;
    protected int nodeType;

    public BranchTagAction(int nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation(resources, this.getShell(), this.nodeType);
        if (op != null) {
            CompositeOperation composite = new CompositeOperation(op.getId(), op.getMessagesClass());
            composite.add((IActionOperation)op);
            composite.add((IActionOperation)new RefreshRemoteResourcesOperation(new IRepositoryResource[]{op.getDestination().getParent()}), new IActionOperation[]{op});
            this.runScheduled((IActionOperation)composite);
        }
    }

    public static PreparedBranchTagOperation getBranchTagOperation(IRepositoryResource[] resources, Shell shell, int nodeType) {
        AbstractBranchTagPanel panel;
        DefaultDialog dialog;
        if (!OperationErrorDialog.isAcceptableAtOnce(resources, nodeType == 0 ? SVNUIMessages.BranchTagAction_Error_Branch : SVNUIMessages.BranchTagAction_Error_Tag, shell)) {
            return null;
        }
        boolean isStructureEnabled = (resources = SVNUtility.shrinkChildNodes((IRepositoryResource[])resources))[0].getRepositoryLocation().isStructureEnabled() && SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure");
        Set<Object> nodeNames = Collections.emptySet();
        boolean forceCreate = false;
        if (isStructureEnabled) {
            int kind = ((IRepositoryRoot)resources[0].getRoot()).getKind();
            if (kind == 0 || kind == 4) {
                try {
                    IRepositoryContainer supposedTrunk = resources[0].asRepositoryContainer(resources[0].getRepositoryLocation().getTrunkLocation(), false);
                    if (supposedTrunk.exists()) {
                        resources[0] = supposedTrunk;
                    }
                }
                catch (SVNConnectorException supposedTrunk) {
                    // empty catch block
                }
            }
            if ((nodeNames = BranchTagAction.getExistingNodeNames((IRepositoryContainer)(nodeType == 0 ? SVNUtility.getBranchesLocation((IRepositoryResource)resources[0]) : SVNUtility.getTagsLocation((IRepositoryResource)resources[0])))) == null) {
                return null;
            }
            forceCreate = resources.length == 1 && (!(resources[0] instanceof IRepositoryRoot) || ((IRepositoryRoot)resources[0]).getKind() != 1) && !BranchTagAction.isSingleProjectLayout(resources[0]) && BranchTagAction.isProjectFileExists(resources[0]);
        }
        if ((dialog = new DefaultDialog(shell, panel = nodeType == 0 ? new BranchPanel(SVNUtility.getBranchesLocation((IRepositoryResource)resources[0]), false, nodeNames, resources) : new TagPanel(SVNUtility.getTagsLocation((IRepositoryResource)resources[0]), false, nodeNames, resources))).open() == 0) {
            IRepositoryResource[] resourcesWithSpecifiedRevision = new IRepositoryResource[resources.length];
            int i = 0;
            while (i < resources.length) {
                resourcesWithSpecifiedRevision[i] = SVNUtility.copyOf((IRepositoryResource)resources[i]);
                resourcesWithSpecifiedRevision[i].setSelectedRevision(panel.getRevisionForRemoteResources());
                resourcesWithSpecifiedRevision[i].setPegRevision(resources[i].getPegRevision());
                ++i;
            }
            return new PreparedBranchTagOperation(nodeType == 0 ? "Branch" : "Tag", resourcesWithSpecifiedRevision, panel.getDestination(), panel.getMessage(), forceCreate);
        }
        return null;
    }

    public static Set<String> getExistingNodeNames(IRepositoryContainer parent) {
        HashSet<String> nodeNames = null;
        IRepositoryResource[] existentNodes = BranchTagAction.getRemoteChildren(parent);
        if (existentNodes != null) {
            nodeNames = new HashSet<String>();
            int i = 0;
            while (i < existentNodes.length) {
                nodeNames.add(existentNodes[i].getName());
                ++i;
            }
        }
        return nodeNames;
    }

    @Override
    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        if (resources.length == 0) {
            return false;
        }
        IRepositoryLocation first = resources[0].getRepositoryLocation();
        int i = 1;
        while (i < resources.length) {
            if (first != resources[i].getRepositoryLocation()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static IRepositoryResource[] getRemoteChildren(IRepositoryContainer parent) {
        GetRemoteFolderChildrenOperation op = new GetRemoteFolderChildrenOperation(parent, false);
        return UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true).isCancelled() ? null : op.getChildren();
    }

    public static boolean isSingleProjectLayout(IRepositoryResource resource) {
        return BranchTagAction.isProjectFileExists((IRepositoryResource)SVNUtility.getTrunkLocation((IRepositoryResource)resource));
    }

    protected static boolean isProjectFileExists(IRepositoryResource resource) {
        try {
            return resource.asRepositoryFile(".project", false).exists();
        }
        catch (SVNConnectorException ex) {
            return false;
        }
    }
}

