/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.property.RemovePropertiesOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.local.SetPropertyAction;
import org.eclipse.team.svn.ui.compare.PropertyCompareInput;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.properties.ResourcePropertyEditPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class ThreeWayPropertyCompareInput
extends PropertyCompareInput {
    protected long baseRevisionNumber;
    protected IResource leftResource;

    public ThreeWayPropertyCompareInput(CompareConfiguration configuration, IResource left, SVNEntryRevisionReference right, SVNEntryRevisionReference ancestor, IRepositoryLocation location, long baseRevisionNumber) {
        super(configuration, new SVNEntryRevisionReference(FileUtility.getWorkingCopyPath((IResource)left), null, SVNRevision.WORKING), (SVNEntryRevisionReference)(SVNRemoteStorage.instance().asLocalResource(left).getPropStatus() != "Conflicting" ? right : null), ancestor, location);
        this.baseRevisionNumber = baseRevisionNumber;
        this.leftResource = left;
    }

    protected void fillMenu(IMenuManager manager, TreeSelection selection) {
        final PropertyCompareInput.PropertyCompareNode selectedNode = (PropertyCompareInput.PropertyCompareNode)((Object)selection.getFirstElement());
        Action tAction = null;
        tAction = new Action(SVNUIMessages.SetPropertyAction_label){

            public void run() {
                IResource[] resources = new IResource[]{ThreeWayPropertyCompareInput.this.leftResource};
                ResourcePropertyEditPanel panel = new ResourcePropertyEditPanel(null, resources, false);
                DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                if (dialog.open() == 0) {
                    SetPropertyAction.doSetProperty(resources, panel, null);
                    boolean notContained = true;
                    PropertyCompareInput.RootCompareNode root = (PropertyCompareInput.RootCompareNode)((Object)ThreeWayPropertyCompareInput.this.getCompareResult());
                    IDiffElement[] nodes = root.getChildren();
                    int i = 0;
                    while (i < nodes.length) {
                        PropertyCompareInput.PropertyCompareNode current = (PropertyCompareInput.PropertyCompareNode)nodes[i];
                        if (current.getName().equals(panel.getPropertyName())) {
                            notContained = false;
                            ((PropertyCompareInput.PropertyElement)current.getLeft()).setValue(panel.getPropertyValue());
                            current.setKind(ThreeWayPropertyCompareInput.this.calculateDifference(panel.getPropertyValue(), ((PropertyCompareInput.PropertyElement)current.getRight()).getValue(), ((PropertyCompareInput.PropertyElement)current.getAncestor()).getValue()));
                            current.fireChange();
                        }
                        ++i;
                    }
                    if (notContained) {
                        new PropertyCompareInput.PropertyCompareNode(ThreeWayPropertyCompareInput.this, (IDiffContainer)root, ThreeWayPropertyCompareInput.this.calculateDifference(panel.getPropertyValue(), null, null), new PropertyCompareInput.PropertyElement(ThreeWayPropertyCompareInput.this, panel.getPropertyName(), null, false), new PropertyCompareInput.PropertyElement(ThreeWayPropertyCompareInput.this, panel.getPropertyName(), panel.getPropertyValue(), true), new PropertyCompareInput.PropertyElement(ThreeWayPropertyCompareInput.this, panel.getPropertyName(), null, false));
                    }
                    ThreeWayPropertyCompareInput.this.viewer.refresh();
                }
            }
        };
        manager.add((IAction)tAction);
        tAction.setEnabled(true);
        tAction = new Action(SVNUIMessages.RemovePropertyAction_label){

            public void run() {
                ThreeWayPropertyCompareInput.this.removeProperty(selectedNode);
            }
        };
        manager.add((IAction)tAction);
        tAction.setEnabled(((PropertyCompareInput.PropertyElement)selectedNode.getLeft()).getValue() != null);
    }

    protected void removeProperty(PropertyCompareInput.PropertyCompareNode currentNode) {
        String propName = currentNode.getName();
        RemovePropertiesOperation op = new RemovePropertiesOperation(new IResource[]{this.leftResource}, new SVNProperty[]{new SVNProperty(propName, "")}, false);
        CompositeOperation cmpOp = new CompositeOperation(op.getId(), op.getMessagesClass());
        cmpOp.add((IActionOperation)op);
        cmpOp.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{this.leftResource}, 0, RefreshResourcesOperation.REFRESH_CHANGES));
        UIMonitorUtility.doTaskNowDefault((IActionOperation)cmpOp, false);
        if (op.getExecutionState() != 0) {
            return;
        }
        if ((currentNode.getKind() & 3) == 1 && (currentNode.getKind() & 0xC) == 4) {
            ((PropertyCompareInput.RootCompareNode)((Object)this.getCompareResult())).remove((IDiffElement)currentNode);
        } else {
            ((PropertyCompareInput.PropertyElement)currentNode.getLeft()).setValue(null);
            currentNode.setKind(this.calculateDifference(null, ((PropertyCompareInput.PropertyElement)currentNode.getRight()).getValue(), ((PropertyCompareInput.PropertyElement)currentNode.getAncestor()).getValue()));
        }
        currentNode.fireChange();
        this.viewer.refresh();
    }

    public String getTitle() {
        return SVNUIMessages.format((String)SVNUIMessages.PropertyCompareInput_Title3, (Object[])new String[]{String.valueOf(this.left.path.substring(this.left.path.lastIndexOf("/") + 1)) + " [" + this.getRevisionPart(this.left), this.getRevisionPart(this.ancestor), String.valueOf(this.getRevisionPart(this.right)) + "] "});
    }

    protected String getRevisionPart(SVNEntryRevisionReference reference) {
        if (reference == null) {
            return SVNUIMessages.ResourceCompareInput_PrejFile;
        }
        if (reference.revision == SVNRevision.WORKING) {
            return SVNUIMessages.ResourceCompareInput_LocalSign;
        }
        if (reference.revision == SVNRevision.BASE) {
            if (this.ancestor == null) {
                return SVNUIMessages.ResourceCompareInput_ResourceIsNotAvailable;
            }
            return SVNUIMessages.format((String)SVNUIMessages.ResourceCompareInput_BaseSign, (Object[])new String[]{String.valueOf(this.baseRevisionNumber)});
        }
        return SVNUIMessages.format((String)SVNUIMessages.ResourceCompareInput_RevisionSign, (Object[])new String[]{String.valueOf(reference.revision)});
    }
}

