/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.generator.framework.GenerationComplexRule;
import org.eclipse.swtbot.generator.framework.GenerationRule;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.Generator;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class BotGeneratorEventDispatcher
implements Listener {
    public static final Event FLUSH_GENERATION_RULES = new Event();
    private Generator generator;
    private List<CodeGenerationListener> listeners = new ArrayList<CodeGenerationListener>();
    private Shell ignoredShell;
    private boolean recording;
    private List<GenerationSimpleRule> simpleRules = new ArrayList<GenerationSimpleRule>();
    private GenerationComplexRule longestMatchedComplex;
    private List<GenerationComplexRule> activeComplexRules = new ArrayList<GenerationComplexRule>();

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public void addListener(CodeGenerationListener listener) {
        this.listeners.add(listener);
    }

    public void ignoreShell(Shell shell) {
        this.ignoredShell = shell;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void switchRecording() {
        this.recording = !this.recording;
    }

    public Generator getCurrentGenerator() {
        return this.generator;
    }

    public void handleEvent(Event event) {
        Shell shell;
        if (!this.recording) {
            return;
        }
        if (event.widget instanceof Control && (shell = WidgetUtils.getShell((Control)event.widget)).getParent() instanceof Shell && this.ignoredShell != null && this.ignoredShell.equals(shell.getParent())) {
            return;
        }
        if (!(event.widget instanceof Shell || !(event.widget instanceof Control) || ((Control)event.widget).isFocusControl() && ((Control)event.widget).isVisible() && ((Control)event.widget).isEnabled())) {
            return;
        }
        this.processRules(event, false);
    }

    public void flushGenerationRules() {
        this.processRules(null, true);
    }

    private void processRules(Event event, boolean forceGeneration) {
        if (event != null) {
            for (GenerationSimpleRule rule : this.generator.createSimpleRules()) {
                if (!rule.appliesTo(event)) continue;
                rule.initializeForEvent(event);
                this.simpleRules.add(rule);
            }
        }
        if (!this.simpleRules.isEmpty()) {
            if (this.activeComplexRules.isEmpty()) {
                this.activeComplexRules.addAll(this.generator.createComplexRules());
            }
            this.filterComplexRulesAndUpdateLongest();
            if (this.activeComplexRules.isEmpty() || forceGeneration) {
                if (this.longestMatchedComplex != null) {
                    this.dispatchCodeGenerated(this.longestMatchedComplex);
                    this.simpleRules.removeAll(this.longestMatchedComplex.getInitializationRules());
                    this.longestMatchedComplex = null;
                    this.processRules(null, forceGeneration);
                } else {
                    this.dispatchCodeGenerated(this.simpleRules.get(0));
                    this.simpleRules.remove(0);
                    this.processRules(null, forceGeneration);
                }
            }
        }
    }

    private void filterComplexRulesAndUpdateLongest() {
        int i = 0;
        while (i < this.simpleRules.size()) {
            HashSet<GenerationComplexRule> notMatchingRules = new HashSet<GenerationComplexRule>();
            for (GenerationComplexRule complexRule : this.activeComplexRules) {
                if (!complexRule.appliesToPartially(this.simpleRules.get(i), i)) {
                    notMatchingRules.add(complexRule);
                    continue;
                }
                ArrayList<GenerationSimpleRule> modifSimpleRules = new ArrayList<GenerationSimpleRule>();
                modifSimpleRules.addAll(this.simpleRules);
                GenerationComplexRule matchedComplex = null;
                while (matchedComplex == null && !modifSimpleRules.isEmpty()) {
                    if (complexRule.appliesTo(modifSimpleRules)) {
                        matchedComplex = complexRule;
                        matchedComplex.initializeForRules(modifSimpleRules);
                        continue;
                    }
                    modifSimpleRules.remove(modifSimpleRules.size() - 1);
                }
                if (matchedComplex == null || this.longestMatchedComplex != null && matchedComplex.getInitializationRules().size() <= this.longestMatchedComplex.getInitializationRules().size()) continue;
                this.longestMatchedComplex = matchedComplex;
            }
            this.activeComplexRules.removeAll(notMatchingRules);
            ++i;
        }
    }

    private void dispatchCodeGenerated(GenerationRule code) {
        if (code != null) {
            for (CodeGenerationListener listener : this.listeners) {
                listener.handleCodeGenerated(code);
            }
        }
    }

    public static interface CodeGenerationListener {
        public void handleCodeGenerated(GenerationRule var1);
    }
}

