/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.IVirtualMachineManager;
import com.microsoft.java.debug.plugin.internal.AdvancedLaunchingConnector;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.LaunchingConnector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdi.internal.VirtualMachineManagerImpl;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;

public class AdvancedVirtualMachineManager
extends VirtualMachineManagerImpl
implements VirtualMachineManager,
DebugSettings.IDebugSettingChangeListener,
IVirtualMachineManager {
    List<VirtualMachine> connectedVMs = Collections.synchronizedList(new ArrayList());

    public AdvancedVirtualMachineManager() {
        this.update(DebugSettings.getCurrent(), DebugSettings.getCurrent());
        DebugSettings.addDebugSettingChangeListener((DebugSettings.IDebugSettingChangeListener)this);
    }

    @Override
    public List<LaunchingConnector> launchingConnectors() {
        ArrayList<LaunchingConnector> connectors = new ArrayList<LaunchingConnector>();
        connectors.add(new AdvancedLaunchingConnector(this));
        connectors.addAll(super.launchingConnectors());
        return connectors;
    }

    public void update(DebugSettings oldSettings, DebugSettings newSettings) {
        int newTimeout = newSettings.jdwpRequestTimeout;
        int currentTimeout = this.getGlobalRequestTimeout();
        if (newTimeout != currentTimeout) {
            this.setRequestTimeout(newTimeout);
        }
    }

    private void setRequestTimeout(int timeout) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        if (prefs != null) {
            prefs.putInt(JDIDebugModel.PREF_REQUEST_TIMEOUT, timeout);
        }
        if (!this.connectedVMs.isEmpty()) {
            this.connectedVMs.forEach(vm -> {
                if (vm instanceof org.eclipse.jdi.VirtualMachine) {
                    try {
                        ((org.eclipse.jdi.VirtualMachine)vm).setRequestTimeout(timeout);
                    }
                    catch (Exception exception) {}
                }
            });
        }
    }

    public boolean connectVirtualMachine(VirtualMachine vm) {
        return this.connectedVMs.add(vm);
    }

    public boolean disconnectVirtualMachine(VirtualMachine vm) {
        return this.connectedVMs.remove(vm);
    }
}

