/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferenceLocator;

public class DOMSuperTypeReferenceLocator
extends DOMPatternLocator {
    private SuperTypeReferenceLocator locator;

    public DOMSuperTypeReferenceLocator(SuperTypeReferenceLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    @Override
    public int match(LambdaExpression node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (this.locator.pattern.superRefKind != 1) {
            return 0;
        }
        nodeSet.getWrapped().mustResolve = true;
        return nodeSet.addMatch((ASTNode)node, 2);
    }

    @Override
    public int match(Type node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (this.locator.flavors != 4096) {
            return 0;
        }
        if (this.locator.pattern.superSimpleName == null) {
            return nodeSet.addMatch((ASTNode)node, this.locator.pattern.mustResolve ? 2 : 3);
        }
        char[] typeRefSimpleName = null;
        if (node instanceof SimpleType) {
            SimpleName name;
            SimpleType simple = (SimpleType)node;
            Name name2 = simple.getName();
            if (name2 instanceof SimpleName) {
                name = (SimpleName)name2;
                typeRefSimpleName = name.getIdentifier().toCharArray();
            }
            if ((name2 = simple.getName()) instanceof QualifiedName) {
                name = (QualifiedName)name2;
                typeRefSimpleName = name.getName().getIdentifier().toCharArray();
            }
        } else if (node instanceof QualifiedType) {
            QualifiedType qualified = (QualifiedType)node;
            typeRefSimpleName = qualified.getName().getIdentifier().toCharArray();
        }
        if (this.locator.matchesName(this.locator.pattern.superSimpleName, typeRefSimpleName)) {
            return nodeSet.addMatch((ASTNode)node, this.locator.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    @Override
    public int resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof ITypeBinding)) {
            return 0;
        }
        ITypeBinding type = (ITypeBinding)binding;
        int level = 0;
        if (this.locator.pattern.superRefKind != 1 && (level = this.resolveLevelForType(this.locator.pattern.superSimpleName, this.locator.pattern.superQualification, type.getSuperclass())) == 3) {
            return 3;
        }
        if (this.locator.pattern.superRefKind != 2) {
            for (ITypeBinding superInterface : type.getInterfaces()) {
                int newLevel = this.resolveLevelForType(this.locator.pattern.superSimpleName, this.locator.pattern.superQualification, superInterface);
                if (newLevel <= level) continue;
                if (newLevel == 3) {
                    return 3;
                }
                level = newLevel;
            }
        }
        return level;
    }
}

