/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObjectToInt;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.IPathRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBinaryType;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.SubTypeSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.QualifierQuery;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.HandleFactory;
import org.eclipse.jdt.internal.core.util.Util;

public class IndexBasedHierarchyBuilder
extends HierarchyBuilder
implements SuffixConstants {
    public static final int MAXTICKS = 800;
    protected IJavaSearchScope scope;
    protected Map binariesFromIndexMatches = new HashMap(10);

    public IndexBasedHierarchyBuilder(TypeHierarchy hierarchy, IJavaSearchScope scope) throws JavaModelException {
        super(hierarchy);
        this.scope = scope;
    }

    @Override
    public void build(boolean computeSubtypes) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles(this);
            if (computeSubtypes) {
                IType focusType = this.getType();
                boolean focusIsObject = focusType.getElementName().equals(new String(IIndexConstants.OBJECT));
                int amountOfWorkForSubtypes = focusIsObject ? 5 : 80;
                SubMonitor possibleSubtypesMonitor = this.hierarchy.progressMonitor.split(amountOfWorkForSubtypes);
                HashSet localTypes = new HashSet(10);
                String[] allPossibleSubtypes = ((Member)((Object)focusType)).getOuterMostLocalContext() == null ? this.determinePossibleSubTypes(localTypes, possibleSubtypesMonitor) : CharOperation.NO_STRINGS;
                if (allPossibleSubtypes != null) {
                    SubMonitor buildMonitor = this.hierarchy.progressMonitor.split(100 - amountOfWorkForSubtypes);
                    this.hierarchy.initialize(allPossibleSubtypes.length);
                    this.buildFromPotentialSubtypes(allPossibleSubtypes, localTypes, buildMonitor);
                }
            } else {
                this.hierarchy.initialize(1);
                this.buildSupertypes();
            }
        }
        finally {
            manager.flushZipFiles(this);
        }
    }

    private void buildForProject(JavaProject project, ArrayList potentialSubtypes, ICompilationUnit[] workingCopies, HashSet localTypes, IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert(monitor, 10);
        int openablesLength = potentialSubtypes.size();
        if (openablesLength > 0) {
            Openable[] openables = new Openable[openablesLength];
            potentialSubtypes.toArray(openables);
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int rootsLength = roots.length;
            final HashtableOfObjectToInt indexes = new HashtableOfObjectToInt(openablesLength);
            int i = 0;
            while (i < openablesLength) {
                IJavaElement root = openables[i].getAncestor(3);
                int index = 0;
                while (index < rootsLength) {
                    if (roots[index].equals(root)) break;
                    ++index;
                }
                indexes.put(openables[i], index);
                ++i;
            }
            subMonitor.split(1);
            Arrays.sort(openables, new Comparator(){

                public int compare(Object a, Object b) {
                    int bIndex;
                    int aIndex = indexes.get(a);
                    if (aIndex != (bIndex = indexes.get(b))) {
                        return aIndex - bIndex;
                    }
                    return ((Openable)b).getElementName().compareTo(((Openable)a).getElementName());
                }
            });
            IType focusType = this.getType();
            boolean inProjectOfFocusType = focusType != null && focusType.getJavaProject().equals(project);
            ICompilationUnit[] unitsToLookInside = null;
            if (inProjectOfFocusType) {
                ICompilationUnit unitToLookInside = focusType.getCompilationUnit();
                if (unitToLookInside != null) {
                    int wcLength;
                    int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
                    if (wcLength == 0) {
                        unitsToLookInside = new ICompilationUnit[]{unitToLookInside};
                    } else {
                        unitsToLookInside = new ICompilationUnit[wcLength + 1];
                        unitsToLookInside[0] = unitToLookInside;
                        System.arraycopy(workingCopies, 0, unitsToLookInside, 1, wcLength);
                    }
                } else {
                    unitsToLookInside = workingCopies;
                }
            }
            SearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(unitsToLookInside);
            this.nameLookup = searchableEnvironment.nameLookup;
            Map<String, String> options = project.getOptions(true);
            options.put("org.eclipse.jdt.core.compiler.taskTags", "");
            this.hierarchyResolver = new HierarchyResolver(searchableEnvironment, options, this, new DefaultProblemFactory());
            if (focusType != null) {
                Member declaringMember = ((Member)((Object)focusType)).getOuterMostLocalContext();
                if (declaringMember == null) {
                    if (!inProjectOfFocusType) {
                        char[] typeQualifiedName = focusType.getTypeQualifiedName('.').toCharArray();
                        PackageFragment fragment = (PackageFragment)focusType.getPackageFragment();
                        String[] packageName = fragment.names;
                        if (searchableEnvironment.findType(typeQualifiedName, Util.toCharArrays(packageName)) == null) {
                            return;
                        }
                    }
                } else {
                    Openable openable = declaringMember.isBinary() ? (Openable)((Object)declaringMember.getClassFile()) : (Openable)((Object)declaringMember.getCompilationUnit());
                    localTypes = new HashSet<String>();
                    localTypes.add(openable.getPath().toString());
                    this.hierarchyResolver.resolve(new Openable[]{openable}, localTypes, subMonitor.split(9));
                    return;
                }
            }
            this.hierarchyResolver.resolve(openables, localTypes, subMonitor.split(9));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildFromPotentialSubtypes(String[] allPotentialSubTypes, HashSet localTypes, IProgressMonitor monitor) {
        int wcLength;
        SubMonitor subMonitor = SubMonitor.convert(monitor, 100);
        IType focusType = this.getType();
        HashMap<String, ICompilationUnit> wcPaths = new HashMap<String, ICompilationUnit>();
        ICompilationUnit[] workingCopies = this.hierarchy.workingCopies;
        if (workingCopies != null && (wcLength = workingCopies.length) > 0) {
            String[] newPaths = new String[wcLength];
            int i = 0;
            while (i < wcLength) {
                ICompilationUnit workingCopy = workingCopies[i];
                String path = workingCopy.getPath().toString();
                wcPaths.put(path, workingCopy);
                newPaths[i] = path;
                ++i;
            }
            int potentialSubtypesLength = allPotentialSubTypes.length;
            String[] stringArray = allPotentialSubTypes;
            allPotentialSubTypes = new String[potentialSubtypesLength + wcLength];
            System.arraycopy(stringArray, 0, allPotentialSubTypes, 0, potentialSubtypesLength);
            System.arraycopy(newPaths, 0, allPotentialSubTypes, potentialSubtypesLength, wcLength);
        }
        int length = allPotentialSubTypes.length;
        Openable focusCU = (Openable)((Object)focusType.getCompilationUnit());
        String focusPath = null;
        if (focusCU != null) {
            focusPath = focusCU.getPath().toString();
            if (length > 0) {
                String[] stringArray = allPotentialSubTypes;
                allPotentialSubTypes = new String[length + 1];
                System.arraycopy(stringArray, 0, allPotentialSubTypes, 0, length);
                allPotentialSubTypes[length] = focusPath;
            } else {
                allPotentialSubTypes = new String[]{focusPath};
            }
            ++length;
        }
        subMonitor.split(5);
        Arrays.sort(allPotentialSubTypes);
        ArrayList<IJavaElement> potentialSubtypes = new ArrayList<IJavaElement>();
        try {
            SubMonitor loopMonitor = subMonitor.split(95);
            HandleFactory factory = new HandleFactory();
            IJavaProject currentProject = null;
            int i = 0;
            while (i < length) {
                block34: {
                    loopMonitor.setWorkRemaining(length - i + 1);
                    JavaProject nextProject = null;
                    try {
                        try {
                            Openable handle;
                            String resourcePath = allPotentialSubTypes[i];
                            if (i > 0 && resourcePath.equals(allPotentialSubTypes[i - 1])) {
                                if (nextProject != null) {
                                    currentProject = nextProject;
                                }
                                break block34;
                            }
                            ICompilationUnit workingCopy = (ICompilationUnit)wcPaths.get(resourcePath);
                            if (workingCopy != null) {
                                handle = (Openable)((Object)workingCopy);
                            } else {
                                Openable openable = handle = resourcePath.equals(focusPath) ? focusCU : factory.createOpenable(resourcePath, this.scope);
                                if (handle == null) {
                                    if (nextProject != null) {
                                        currentProject = nextProject;
                                    }
                                    break block34;
                                }
                            }
                            JavaProject project = handle.getJavaProject();
                            if (currentProject == null) {
                                currentProject = project;
                                potentialSubtypes = new ArrayList(5);
                            } else if (!currentProject.equals(project)) {
                                nextProject = project;
                                this.buildForProject((JavaProject)currentProject, potentialSubtypes, workingCopies, localTypes, loopMonitor.split(1));
                                potentialSubtypes = new ArrayList(5);
                            }
                            potentialSubtypes.add(handle);
                        }
                        catch (JavaModelException e) {
                            if (nextProject != null) {
                                currentProject = nextProject;
                            }
                            break block34;
                        }
                    }
                    catch (Throwable throwable) {
                        if (nextProject == null) throw throwable;
                        currentProject = nextProject;
                        throw throwable;
                    }
                    if (nextProject != null) {
                        currentProject = nextProject;
                    }
                }
                ++i;
            }
            loopMonitor.setWorkRemaining(2);
            try {
                if (currentProject == null) {
                    currentProject = focusType.getJavaProject();
                    if (focusType.isBinary()) {
                        potentialSubtypes.add(focusType.getClassFile());
                    } else {
                        potentialSubtypes.add(focusType.getCompilationUnit());
                    }
                }
                this.buildForProject((JavaProject)currentProject, potentialSubtypes, workingCopies, localTypes, loopMonitor.split(1));
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            loopMonitor.setWorkRemaining(1);
            if (!this.hierarchy.contains(focusType)) {
                try {
                    currentProject = focusType.getJavaProject();
                    potentialSubtypes = new ArrayList();
                    if (focusType.isBinary()) {
                        potentialSubtypes.add(focusType.getClassFile());
                    } else {
                        potentialSubtypes.add(focusType.getCompilationUnit());
                    }
                    this.buildForProject((JavaProject)currentProject, potentialSubtypes, workingCopies, localTypes, loopMonitor.split(1));
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            if (this.hierarchy.contains(focusType)) return;
            this.hierarchy.addRootClass(focusType);
            return;
        }
        finally {
            SubMonitor.done(monitor);
        }
    }

    @Override
    protected IBinaryType createInfoFromClassFile(Openable classFile, IResource file) {
        String documentPath = classFile.getPath().toString();
        IBinaryType binaryType = (IBinaryType)this.binariesFromIndexMatches.get(documentPath);
        if (binaryType != null) {
            this.infoToHandle.put(binaryType, classFile);
            return binaryType;
        }
        return super.createInfoFromClassFile(classFile, file);
    }

    @Override
    protected IBinaryType createInfoFromClassFileInJar(Openable classFile) {
        String documentPath;
        String filePath = String.valueOf(((ClassFile)classFile).getType().getFullyQualifiedName('$').replace('.', '/')) + ".class";
        PackageFragmentRoot root = classFile.getPackageFragmentRoot();
        IPath path = root.getPath();
        String rootPath = path.getDevice() == null ? path.toString() : path.toOSString();
        IModuleDescription md = root.getModuleDescription();
        if (md != null) {
            String module = md.getElementName();
            documentPath = String.valueOf(rootPath) + "|" + module + "|" + filePath;
        } else {
            documentPath = String.valueOf(rootPath) + "|" + filePath;
        }
        IBinaryType binaryType = (IBinaryType)this.binariesFromIndexMatches.get(documentPath);
        if (binaryType != null) {
            this.infoToHandle.put(binaryType, classFile);
            return binaryType;
        }
        return super.createInfoFromClassFileInJar(classFile);
    }

    private String[] determinePossibleSubTypes(HashSet localTypes, IProgressMonitor monitor) {
        class PathCollector
        implements IPathRequestor {
            HashSet paths = new HashSet(10);
            private final /* synthetic */ HashSet val$localTypes;

            PathCollector(HashSet hashSet) {
                this.val$localTypes = hashSet;
            }

            @Override
            public void acceptPath(String path, boolean containsLocalTypes) {
                this.paths.add(path);
                if (containsLocalTypes) {
                    this.val$localTypes.add(path);
                }
            }
        }
        PathCollector collector = new PathCollector(localTypes);
        IndexBasedHierarchyBuilder.searchAllPossibleSubTypes(this.getType(), this.scope, this.binariesFromIndexMatches, collector, 3, monitor);
        HashSet paths = collector.paths;
        int length = paths.size();
        String[] result = new String[length];
        int count = 0;
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            result[count++] = (String)iter.next();
        }
        return result;
    }

    public static void searchAllPossibleSubTypes(IType type, IJavaSearchScope scope, Map binariesFromIndexMatches, IPathRequestor pathRequestor, int waitingPolicy, IProgressMonitor monitor) {
        IndexBasedHierarchyBuilder.legacySearchAllPossibleSubTypes(type, scope, binariesFromIndexMatches, pathRequestor, waitingPolicy, monitor);
    }

    private static void legacySearchAllPossibleSubTypes(IType type, IJavaSearchScope scope, final Map binariesFromIndexMatches, final IPathRequestor pathRequestor, int waitingPolicy, IProgressMonitor progressMonitor) {
        int superRefKind;
        SubMonitor subMonitor = SubMonitor.convert(progressMonitor, 100);
        final Queue queue = new Queue();
        final HashtableOfObject foundSuperNames = new HashtableOfObject(5);
        IndexManager indexManager = JavaModelManager.getIndexManager();
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                SuperTypeReferencePattern record = (SuperTypeReferencePattern)indexRecord;
                boolean isLocalOrAnonymous = record.enclosingTypeName == IIndexConstants.ONE_ZERO;
                pathRequestor.acceptPath(documentPath, isLocalOrAnonymous);
                char[] typeName = record.simpleName;
                char[] enclosingTypeName = null;
                if (documentPath.toLowerCase().endsWith(".class")) {
                    int suffix = documentPath.length() - ".class".length();
                    HierarchyBinaryType binaryType = (HierarchyBinaryType)binariesFromIndexMatches.get(documentPath);
                    if (binaryType == null) {
                        enclosingTypeName = record.enclosingTypeName;
                        if (isLocalOrAnonymous) {
                            int lastSlash = documentPath.lastIndexOf(47);
                            int lastDollar = documentPath.lastIndexOf(36);
                            if (lastDollar == -1) {
                                enclosingTypeName = null;
                                typeName = documentPath.substring(lastSlash + 1, suffix).toCharArray();
                            } else {
                                enclosingTypeName = documentPath.substring(lastSlash + 1, lastDollar).toCharArray();
                                typeName = documentPath.substring(lastDollar + 1, suffix).toCharArray();
                            }
                        }
                        binaryType = new HierarchyBinaryType(record.modifiers, record.pkgName, typeName, enclosingTypeName, record.typeParameterSignatures, record.classOrInterface);
                        binariesFromIndexMatches.put(documentPath, binaryType);
                    }
                    binaryType.recordSuperType(record.superSimpleName, record.superQualification, record.superClassOrInterface);
                }
                char[] fqnSuperName = CharOperation.concatNonEmpty(record.pkgName, '.', enclosingTypeName, '$', typeName);
                if (!isLocalOrAnonymous && !foundSuperNames.containsKey(fqnSuperName)) {
                    foundSuperNames.put(fqnSuperName, fqnSuperName);
                    queue.add(new SubtypeQuery(fqnSuperName, typeName));
                }
                return true;
            }
        };
        try {
            superRefKind = type.isClass() ? 2 : 0;
        }
        catch (JavaModelException e) {
            superRefKind = 0;
        }
        SuperTypeReferencePattern pattern = new SuperTypeReferencePattern(null, null, superRefKind, 8);
        MatchLocator.setFocus(pattern, type);
        SubTypeSearchJob job = new SubTypeSearchJob(pattern, new JavaSearchParticipant(), scope, searchRequestor);
        queue.add(new SubtypeQuery(type.getFullyQualifiedName().toCharArray(), type.getElementName().toCharArray()));
        long startTime = System.currentTimeMillis();
        try {
            while (queue.start <= queue.end) {
                char[] qualifiedTypeName;
                subMonitor.setWorkRemaining(Math.max(queue.end - queue.start + 1, 100));
                SubtypeQuery query = queue.retrieve();
                char[] currentTypeName = query.simpleName;
                char[] cArray = qualifiedTypeName = query.qualifiedName != null ? query.qualifiedName : QualifierQuery.NO_CHARS;
                if (CharOperation.equals(currentTypeName, IIndexConstants.OBJECT)) {
                    currentTypeName = null;
                } else {
                    MatchLocator.setIndexQualifierQuery(pattern, QualifierQuery.encodeQuery(new QualifierQuery.QueryCategory[]{QualifierQuery.QueryCategory.SUPER}, currentTypeName, qualifiedTypeName));
                }
                pattern.superSimpleName = currentTypeName;
                indexManager.performConcurrentJob(job, waitingPolicy, subMonitor.split(1));
                if (currentTypeName != null) continue;
                break;
            }
        }
        finally {
            job.finished();
            if (JobManager.VERBOSE) {
                long wallClockTime = System.currentTimeMillis() - startTime;
                Util.verbose("-> execution time: " + wallClockTime + "ms - " + IndexBasedHierarchyBuilder.class.getSimpleName());
            }
        }
    }

    static class Queue {
        public SubtypeQuery[] entries = new SubtypeQuery[10];
        public int start = 0;
        public int end = -1;

        Queue() {
        }

        public void add(SubtypeQuery entry) {
            if (++this.end == this.entries.length) {
                this.end -= this.start;
                this.entries = new SubtypeQuery[this.end * 2];
                System.arraycopy(this.entries, this.start, this.entries, 0, this.end);
                this.start = 0;
            }
            this.entries[this.end] = entry;
        }

        public SubtypeQuery retrieve() {
            if (this.start > this.end) {
                return null;
            }
            SubtypeQuery entry = this.entries[this.start++];
            if (this.start > this.end) {
                this.start = 0;
                this.end = -1;
            }
            return entry;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("Queue:\n");
            int i = this.start;
            while (i <= this.end) {
                buffer.append(this.entries[i]).append('\n');
                ++i;
            }
            return buffer.toString();
        }
    }

    private static class SubtypeQuery {
        final char[] simpleName;
        final char[] qualifiedName;

        SubtypeQuery(char[] qualifiedName, char[] simpleName) {
            this.simpleName = simpleName;
            this.qualifiedName = qualifiedName;
        }
    }
}

