/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.SearchMatchingUtility;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;

public class DOMPatternLocator
extends PatternLocator {
    protected ASTNode currentNode;

    public DOMPatternLocator(SearchPattern pattern) {
        super(pattern);
    }

    protected LocatorResponse toResponse(int val) {
        return this.toResponse(val, false);
    }

    protected LocatorResponse toResponse(int val, boolean alreadyAdded) {
        return new LocatorResponse(val, false, null, alreadyAdded, true);
    }

    public LocatorResponse match(Annotation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(ASTNode node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(Expression node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(FieldDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(LambdaExpression node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(MethodReference node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(MethodRef node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(VariableDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(MethodDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(MemberValuePair node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(AnnotationTypeMemberDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(MethodInvocation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    protected LocatorResponse match(ModuleDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(Name node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(FieldAccess node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(AbstractTypeDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(TypeParameter node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse match(Type node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse resolveLevel(ASTNode node, MatchLocator locator) {
        return this.toResponse(0);
    }

    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        return this.toResponse(0);
    }

    protected String getQualifiedSourceName(ITypeBinding binding) {
        JavacTypeBinding jctb;
        String qualifiedName;
        if (binding == null) {
            return null;
        }
        ITypeBinding type = binding.isArray() ? binding.getComponentType() : binding;
        String simpleName = type instanceof JavacTypeBinding ? ((JavacTypeBinding)type).getName(false) : binding.getName();
        String qualifier = DOMPatternLocator.qualifiedSourceName(type.getDeclaringClass());
        if (qualifier == null && type instanceof JavacTypeBinding && (qualifiedName = (jctb = (JavacTypeBinding)type).getQualifiedName(false)) != null) {
            return qualifiedName;
        }
        if (type.isLocal()) {
            return qualifier + ".1." + simpleName;
        }
        if (type.isMember()) {
            return qualifier + "." + simpleName;
        }
        return binding.getName();
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern, ITypeBinding binding) {
        return binding == null && simpleNamePattern == null && qualificationPattern == null ? 3 : (binding != null && binding.isArray() && new String(simpleNamePattern).endsWith("[]") ? this.resolveLevelForType(Arrays.copyOf(simpleNamePattern, simpleNamePattern.length - 2), qualificationPattern, binding.getComponentType()) : this.resolveLevelForTypeFQN(simpleNamePattern, qualificationPattern, binding, null));
    }

    protected int resolveLevelForTypeFQN(char[] simpleNamePattern, char[] qualificationPattern, ITypeBinding binding, IImportDiscovery discovery) {
        int level = 0;
        if (simpleNamePattern == null) {
            return 3;
        }
        if (qualificationPattern == null && simpleNamePattern != null) {
            level = this.resolveLevelForTypeSourceName(simpleNamePattern, (binding.isArray() ? binding : binding.getErasure()).getName().toCharArray(), binding);
        }
        if (level == 3 || level == 4) {
            return level;
        }
        char[] qualifiedPattern = this.getQualifiedPattern(simpleNamePattern, qualificationPattern);
        level = this.resolveLevelForTypeFQN(qualifiedPattern, binding, discovery);
        if (level == 3 || binding == null) {
            return level;
        }
        ITypeBinding type = binding.isArray() ? binding.getComponentType() : binding;
        char[] sourceName = null;
        if (type.isMember() || type.isLocal()) {
            sourceName = qualificationPattern != null ? this.getQualifiedSourceName(binding).toCharArray() : binding.getQualifiedName().toCharArray();
        } else if (qualificationPattern == null) {
            sourceName = this.getQualifiedSourceName(binding).toCharArray();
        }
        if (type.isRecovered() && (qualificationPattern == null || !type.getQualifiedName().contains(".")) && (level = this.resolveLevelForTypeSourceName(simpleNamePattern, binding.getName().toCharArray(), type)) > 0) {
            return 1;
        }
        if (sourceName == null) {
            return 0;
        }
        return this.resolveLevelForTypeSourceName(qualifiedPattern, sourceName, type);
    }

    public static String qualifiedSourceName(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        if (binding.isLocal()) {
            return binding.isMember() ? DOMPatternLocator.qualifiedSourceName(binding.getDeclaringClass()) + "." + binding.getName() : DOMPatternLocator.qualifiedSourceName(binding.getDeclaringClass()) + ".1." + binding.getName();
        }
        return binding.getQualifiedName();
    }

    private Name getBaseTypeName(Type type) {
        if (type instanceof SimpleType) {
            SimpleType simp = (SimpleType)type;
            return simp.getName();
        }
        if (type instanceof QualifiedType) {
            QualifiedType qn = (QualifiedType)type;
            return qn.getName();
        }
        if (type instanceof ArrayType) {
            ArrayType arr = (ArrayType)type;
            return this.getBaseTypeName(arr.getElementType());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            return this.getBaseTypeName(parameterized.getType());
        }
        return null;
    }

    protected boolean matchesTypeReference(char[] pattern, Type type, boolean isVarargs) {
        int dimensions;
        Object simpleName;
        if (pattern == null) {
            return true;
        }
        if (type == null) {
            return true;
        }
        Name name = this.getBaseTypeName(type);
        if (name instanceof SimpleName) {
            SimpleName simple = (SimpleName)name;
            v0 = simple.getIdentifier();
        } else if (name instanceof QualifiedName) {
            QualifiedName qName = (QualifiedName)name;
            v0 = qName.getName().getIdentifier();
        } else if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            v0 = primitive.getPrimitiveTypeCode().toString();
        } else {
            v0 = simpleName = null;
        }
        if (simpleName == null) {
            return true;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            v1 = arrayType.dimensions().size();
        } else {
            v1 = dimensions = 0;
        }
        if (isVarargs) {
            ++dimensions;
        }
        for (int i = 0; i < dimensions; ++i) {
            simpleName = (String)simpleName + "[]";
        }
        return this.matchesName(pattern, ((String)simpleName).toCharArray());
    }

    protected boolean matchesTypeReference(char[] pattern, Type type) {
        return this.matchesTypeReference(pattern, type, false);
    }

    protected int resolveLevelForTypeSourceName(char[] qualifiedPattern, char[] sourceName, ITypeBinding type) {
        switch (this.matchMode) {
            case 1: {
                if (!CharOperation.prefixEquals((char[])qualifiedPattern, (char[])sourceName, (boolean)this.isCaseSensitive)) break;
                return 3;
            }
            case 128: {
                if (qualifiedPattern.length <= 0 || sourceName.length <= 0 || qualifiedPattern[0] != sourceName[0]) break;
                if (CharOperation.camelCaseMatch((char[])qualifiedPattern, (char[])sourceName, (boolean)false)) {
                    return 3;
                }
                if (this.isCaseSensitive || !CharOperation.prefixEquals((char[])qualifiedPattern, (char[])sourceName, (boolean)false)) break;
                return 3;
            }
            case 256: {
                if (qualifiedPattern.length <= 0 || sourceName.length <= 0 || qualifiedPattern[0] != sourceName[0] || !CharOperation.camelCaseMatch((char[])qualifiedPattern, (char[])sourceName, (boolean)true)) break;
                return 3;
            }
            default: {
                if (type != null && type.isLocal() && CharOperation.prefixEquals((char[])qualifiedPattern, (char[])sourceName, (boolean)this.isCaseSensitive)) {
                    return 3;
                }
                if (!CharOperation.match((char[])qualifiedPattern, (char[])sourceName, (boolean)this.isCaseSensitive)) break;
                return 3;
            }
        }
        return 0;
    }

    protected int resolveLevelForTypeFQN(char[] qualifiedPattern, ITypeBinding type) {
        return this.resolveLevelForTypeFQN(qualifiedPattern, type, null);
    }

    protected int resolveLevelForTypeFQN(char[] qualifiedPattern, ITypeBinding type, IImportDiscovery discovery) {
        String fqqnPattern;
        boolean match2;
        String firstSegment;
        String fqqnImport;
        boolean match1;
        char[] qualifiedNameFromBinding;
        if (qualifiedPattern == null) {
            return 3;
        }
        if (type == null) {
            return 1;
        }
        if (type.isTypeVariable()) {
            return 0;
        }
        if (type.isIntersectionType()) {
            int result = 0;
            int prev = 0;
            for (ITypeBinding ref : type.getTypeBounds()) {
                result = this.resolveLevelForTypeFQN(qualifiedPattern, ref);
                if (result == 3) {
                    return result;
                }
                if (result == 0 || prev != 0) continue;
                prev = result;
            }
            return prev;
        }
        String qnfb = this.getQualifiedSourceName(type);
        int qnfbLastDot = qnfb.lastIndexOf(46);
        int patternFirstDot = CharOperation.indexOf((char)'.', (char[])qualifiedPattern);
        if (qnfbLastDot != -1 && patternFirstDot == -1) {
            String qnfbLastSegment;
            String string = qnfbLastSegment = qnfbLastDot == qnfb.length() - 1 ? null : qnfb.substring(qnfbLastDot + 1);
            if (qnfbLastSegment != null) {
                boolean match12 = CharOperation.match((char[])qualifiedPattern, (char[])qnfbLastSegment.toCharArray(), (boolean)this.isCaseSensitive);
                return match12 ? 3 : 0;
            }
        }
        char[] cArray = qualifiedNameFromBinding = qnfb == null ? null : qnfb.toCharArray();
        if (qualifiedNameFromBinding == null || qualifiedNameFromBinding.length == 0) {
            qualifiedNameFromBinding = type.getName().toCharArray();
        }
        if (match1 = CharOperation.match((char[])qualifiedPattern, (char[])qualifiedNameFromBinding, (boolean)this.isCaseSensitive)) {
            return 3;
        }
        if (patternFirstDot != -1 && discovery != null && (fqqnImport = discovery.findImportForString(firstSegment = new String(qualifiedPattern, 0, patternFirstDot))) != null && (match2 = CharOperation.match((char[])(fqqnPattern = fqqnImport.substring(0, fqqnImport.length() - firstSegment.length()) + new String(qualifiedPattern)).toCharArray(), (char[])qualifiedNameFromBinding, (boolean)this.isCaseSensitive))) {
            return 3;
        }
        return 0;
    }

    private int boundKind(ITypeBinding type) {
        if (type.isUpperbound()) {
            return 1;
        }
        if (type.getBound() == null) {
            return 0;
        }
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void updateMatch(ITypeBinding[] argumentsBinding, char[][] patternArguments, boolean hasTypeParameters) {
        int patternTypeArgsLength = patternArguments == null ? 0 : patternArguments.length;
        int typeArgumentsLength = argumentsBinding == null ? 0 : argumentsBinding.length;
        int matchRule = this.match.getRule();
        if (this.match.isRaw() && patternTypeArgsLength != 0) {
            matchRule &= 0xFFFFFFBF;
        }
        if (hasTypeParameters) {
            matchRule = 16;
        }
        if (patternTypeArgsLength == typeArgumentsLength) {
            if (!this.match.isRaw() && hasTypeParameters) {
                this.match.setRule(16);
                return;
            }
        } else {
            if (patternTypeArgsLength == 0) {
                if (this.match.isRaw()) {
                    if (!hasTypeParameters) return;
                }
                this.match.setRule(matchRule & 0xFFFFFFBF);
                return;
            }
            if (typeArgumentsLength == 0) {
                this.match.setRule(matchRule & 0xFFFFFFBF);
                return;
            }
            this.match.setRule(0);
            return;
        }
        if (argumentsBinding == null || patternArguments == null) {
            this.match.setRule(matchRule);
            return;
        }
        if (!hasTypeParameters && !this.match.isRaw() && (this.match.isEquivalent() || this.match.isExact())) {
            block25: for (int i = 0; i < typeArgumentsLength; ++i) {
                ITypeBinding capturedWildcard;
                ITypeBinding argumentBinding = argumentsBinding[i];
                if (argumentBinding.isCapture() && (capturedWildcard = argumentBinding.getWildcard()) != null) {
                    argumentBinding = capturedWildcard;
                }
                char[] patternTypeArgument = patternArguments[i];
                char patternWildcard = patternTypeArgument[0];
                char[] patternTypeName = patternTypeArgument;
                int patternWildcardKind = -1;
                switch (patternWildcard) {
                    case '*': {
                        if (argumentBinding.isWildcardType() && this.boundKind(argumentBinding) == 0) continue block25;
                        matchRule &= 0xFFFFFFBF;
                        continue block25;
                    }
                    case '+': {
                        patternWildcardKind = 1;
                        patternTypeName = CharOperation.subarray((char[])patternTypeArgument, (int)1, (int)patternTypeArgument.length);
                        break;
                    }
                    case '-': {
                        patternWildcardKind = 2;
                        patternTypeName = CharOperation.subarray((char[])patternTypeArgument, (int)1, (int)patternTypeArgument.length);
                    }
                }
                patternTypeName = Signature.toCharArray((char[])patternTypeName);
                ITypeBinding patternBinding = this.findType(new String(patternTypeName));
                if (patternBinding == null) {
                    if (!argumentBinding.isWildcardType()) continue;
                    if (this.boundKind(argumentBinding) != 0) {
                        this.match.setRule(16);
                        return;
                    }
                    matchRule &= 0xFFFFFFBF;
                    continue;
                }
                block5 : switch (patternWildcard) {
                    case '*': {
                        matchRule &= 0xFFFFFFBF;
                        continue block25;
                    }
                    case '+': {
                        if (argumentBinding.isWildcardType()) {
                            if (this.boundKind(argumentBinding) == patternWildcardKind && argumentBinding.getBound().isEqualTo((IBinding)patternBinding)) continue block25;
                            switch (this.boundKind(argumentBinding)) {
                                case 1: {
                                    if (argumentBinding.getBound() != null && !argumentBinding.getBound().isAssignmentCompatible(patternBinding)) break;
                                    matchRule &= 0xFFFFFFBF;
                                    continue block25;
                                }
                                case 2: {
                                    break;
                                }
                                case 0: {
                                    matchRule &= 0xFFFFFFBF;
                                    continue block25;
                                }
                            }
                            break;
                        }
                        if (!argumentBinding.isAssignmentCompatible(patternBinding)) break;
                        matchRule &= 0xFFFFFFBF;
                        continue block25;
                    }
                    case '-': {
                        if (argumentBinding.isWildcardType()) {
                            if (this.boundKind(argumentBinding) == patternWildcardKind && argumentBinding.getBound().isEqualTo((IBinding)patternBinding)) continue block25;
                            switch (this.boundKind(argumentBinding)) {
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    if (argumentBinding.getBound() != null && !patternBinding.isAssignmentCompatible(argumentBinding.getBound())) break;
                                    matchRule &= 0xFFFFFFBF;
                                    continue block25;
                                }
                                case 0: {
                                    matchRule &= 0xFFFFFFBF;
                                    continue block25;
                                }
                            }
                            break;
                        }
                        if (!patternBinding.isAssignmentCompatible(argumentBinding)) break;
                        matchRule &= 0xFFFFFFBF;
                        continue block25;
                    }
                    default: {
                        if (argumentBinding.isWildcardType()) {
                            switch (this.boundKind(argumentBinding)) {
                                case 1: {
                                    if (argumentBinding.getBound() == null || patternBinding.isAssignmentCompatible(argumentBinding.getBound())) {
                                        matchRule &= 0xFFFFFFBF;
                                        continue block25;
                                    }
                                    break block5;
                                }
                                case 2: {
                                    if (argumentBinding.getBound() == null || argumentBinding.getBound().isAssignmentCompatible(patternBinding)) {
                                        matchRule &= 0xFFFFFFBF;
                                        continue block25;
                                    }
                                    break block5;
                                }
                                case 0: {
                                    matchRule &= 0xFFFFFFBF;
                                    continue block25;
                                }
                            }
                            break;
                        }
                        if (argumentBinding.isEqualTo((IBinding)patternBinding)) continue block25;
                    }
                }
                this.match.setRule(16);
                return;
            }
        }
        this.match.setRule(matchRule);
    }

    protected void updateMatch(ITypeBinding parameterizedBinding, char[][][] patternTypeArguments, boolean patternHasTypeParameters, int depth) {
        ITypeBinding enclosingType;
        boolean isRaw;
        boolean endPattern = patternTypeArguments == null ? true : depth >= patternTypeArguments.length;
        ITypeBinding[] argumentsBindings = parameterizedBinding.getTypeArguments();
        boolean bl = isRaw = parameterizedBinding.isRawType() || argumentsBindings == null && parameterizedBinding.getTypeDeclaration().isGenericType();
        if (isRaw && !this.match.isRaw()) {
            this.match.setRaw(isRaw);
        }
        if (!endPattern && patternTypeArguments != null) {
            if (!isRaw && patternHasTypeParameters && argumentsBindings != null) {
                boolean needUpdate = false;
                int length = argumentsBindings.length;
                ITypeBinding[] typeVariables = parameterizedBinding.getTypeDeclaration().getTypeParameters();
                if (length == typeVariables.length) {
                    for (int i = 0; i < length; ++i) {
                        if (argumentsBindings[i].isEqualTo((IBinding)typeVariables[i])) continue;
                        needUpdate = true;
                        break;
                    }
                }
                if (needUpdate) {
                    char[][] patternArguments = patternTypeArguments[depth];
                    this.updateMatch(argumentsBindings, patternArguments, patternHasTypeParameters);
                }
            } else {
                char[][] patternArguments = patternTypeArguments[depth];
                this.updateMatch(argumentsBindings, patternArguments, patternHasTypeParameters);
            }
        }
        if ((enclosingType = parameterizedBinding.getDeclaringClass()) != null && (enclosingType.isParameterizedType() || enclosingType.isRawType())) {
            this.updateMatch(enclosingType, patternTypeArguments, patternHasTypeParameters, depth + 1);
        }
    }

    public void reportSearchMatch(MatchLocator locator, ASTNode node, SearchMatch match) throws CoreException {
        this.match = match;
        SearchMatchingUtility.reportSearchMatch(locator, match);
    }

    public final void setCurrentMatch(SearchMatch match) {
        this.match = match;
    }

    public void setCurrentNode(ASTNode node) {
        this.currentNode = node;
    }

    private ITypeBinding findType(String name) {
        if (this.currentNode == null) {
            return null;
        }
        ITypeBinding res = this.currentNode.getAST().resolveWellKnownType(name);
        if (res != null) {
            return res;
        }
        for (ASTNode cursor = this.currentNode; cursor != null; cursor = cursor.getParent()) {
            if (!(cursor instanceof CompilationUnit)) continue;
            CompilationUnit unit = (CompilationUnit)cursor;
            ITypeBinding explicitlyImported = unit.imports().stream().filter(Predicate.not(ImportDeclaration::isStatic)).filter(Predicate.not(ImportDeclaration::isOnDemand)).filter(decl -> decl.getName().toString().endsWith("." + name)).map(ImportDeclaration::getName).map(ASTNode::toString).map(arg_0 -> ((AST)this.currentNode.getAST()).resolveWellKnownType(arg_0)).filter(Objects::nonNull).findFirst().orElse(null);
            if (explicitlyImported != null) {
                return explicitlyImported;
            }
            ITypeBinding importedOnDemand = unit.imports().stream().filter(Predicate.not(ImportDeclaration::isStatic)).filter(ImportDeclaration::isOnDemand).map(decl -> decl.getName().toString() + "." + name).map(arg_0 -> ((AST)this.currentNode.getAST()).resolveWellKnownType(arg_0)).filter(Objects::nonNull).findFirst().orElse(null);
            if (importedOnDemand == null) continue;
            return importedOnDemand;
        }
        return this.currentNode.getAST().resolveWellKnownType("java.lang." + name);
    }

    public static interface IImportDiscovery {
        public String findImportForString(String var1);
    }
}

