/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.WarningMessage;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyErrorCollectorForJDT
extends ErrorCollector {
    private static final long serialVersionUID = -5358192603029491124L;

    public GroovyErrorCollectorForJDT(CompilerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void addErrorAndContinue(Message message) {
        try {
            if (GroovyLogManager.manager.hasLoggers()) {
                String error;
                if (message instanceof SimpleMessage) {
                    error = ((SimpleMessage)message).getMessage();
                } else {
                    StringWriter writer = new StringWriter();
                    message.write(new PrintWriter(writer));
                    error = writer.toString().trim();
                }
                GroovyLogManager.manager.log(TraceCategory.COMPILER, error);
            }
        }
        catch (Throwable t) {
            Util.log(t);
        }
        super.addErrorAndContinue(message);
    }

    @Override
    public void addWarning(WarningMessage message) {
        try {
            if (GroovyLogManager.manager.hasLoggers()) {
                StringWriter writer = new StringWriter();
                message.write(new PrintWriter(writer));
                String[] lines = writer.toString().substring(9).split(System.lineSeparator());
                if (lines.length < 3) {
                    lines = new String[]{"", "", ": "};
                }
                String warning = String.format("Warning: %s%n%s%n%s%n%s", message.getMessage(), lines[0], lines[1], lines[2].substring(0, lines[2].indexOf(": ")));
                GroovyLogManager.manager.log(TraceCategory.COMPILER, warning.trim());
            }
        }
        catch (Throwable t) {
            Util.log(t);
        }
        super.addWarning(message);
    }

    @Override
    protected void failIfErrors() {
        if (this.transformActive) {
            super.failIfErrors();
        }
    }
}

