/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.ISystemResourceSet;
import org.eclipse.rse.core.model.SystemRemoteResourceSet;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.internal.ui.GenericMessages;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.internal.model.SystemScratchpad;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CopyResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.progress.UIJob;

public class SystemDNDTransferRunnable
extends WorkspaceJob {
    public static final int SRC_TYPE_RSE_RESOURCE = 0;
    public static final int SRC_TYPE_ECLIPSE_RESOURCE = 1;
    public static final int SRC_TYPE_OS_RESOURCE = 2;
    public static final int SRC_TYPE_TEXT = 3;
    public static final int SRC_TYPE_UNKNOWN = 4;
    private List _srcObjects;
    private List _resultSrcObjects;
    private List _resultTgtObjects;
    private List _setList;
    private Object _currentTarget;
    private int _sourceType;
    private Viewer _originatingViewer;
    private boolean _ok;
    private Shell _shell;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SystemDNDTransferRunnable(Object target, ArrayList srcObjects, Viewer originatingViewer, int sourceType) {
        super(GenericMessages.TransferOperation_message);
        this._srcObjects = srcObjects;
        this._currentTarget = target;
        this._sourceType = sourceType;
        this._originatingViewer = originatingViewer;
        this._resultSrcObjects = new ArrayList(this._srcObjects.size());
        this._resultTgtObjects = new ArrayList();
        this._setList = new ArrayList();
        this.setUser(true);
        this._shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected SystemRemoteResourceSet getSetFor(ISubSystem subSystem, ISystemDragDropAdapter adapter) {
        int i = 0;
        while (i < this._setList.size()) {
            SystemRemoteResourceSet set = (SystemRemoteResourceSet)this._setList.get(i);
            if (set.getAdapter() == adapter && set.getSubSystem() == subSystem) {
                return set;
            }
            ++i;
        }
        SystemRemoteResourceSet newSet = new SystemRemoteResourceSet(subSystem, adapter);
        this._setList.add(newSet);
        return newSet;
    }

    protected boolean transferRSEResources(Object target, ISubSystem targetSubSystem, ISystemDragDropAdapter targetAdapter, IProgressMonitor monitor) {
        SystemRemoteResourceSet set;
        int i = 0;
        while (i < this._srcObjects.size() && this._ok) {
            Object srcObject = this._srcObjects.get(i);
            this._resultSrcObjects.add(srcObject);
            if (srcObject instanceof SystemMessage) {
                this.operationFailed(monitor);
                this.showErrorMessage((SystemMessage)srcObject);
                return this._ok;
            }
            if (srcObject != null) {
                ISystemDragDropAdapter srcAdapter;
                IAdaptable iAdaptable = (IAdaptable)srcObject;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((srcAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                    if (srcObject instanceof IHost) {
                        Object tempObject = srcAdapter.doDrag(srcObject, false, monitor);
                        if (targetAdapter.validateDrop(tempObject, target, false)) {
                            targetAdapter.doDrop(tempObject, target, false, false, this._sourceType, monitor);
                            this._resultTgtObjects.add(tempObject);
                        }
                    } else {
                        ISubSystem srcSubSystem = srcAdapter.getSubSystem(srcObject);
                        if (srcSubSystem.isConnected() || srcObject instanceof ISystemFilterReference || srcObject instanceof ISubSystem) {
                            set = this.getSetFor(srcSubSystem, srcAdapter);
                            set.addResource(srcObject);
                        }
                    }
                }
            }
            ++i;
        }
        String targetPath = targetAdapter.getAbsoluteName(target);
        boolean sameSubSystemType = true;
        String targetType = "";
        if (targetSubSystem != null) {
            targetType = targetSubSystem.getName();
        }
        int s = 0;
        while (s < this._setList.size()) {
            set = (SystemRemoteResourceSet)this._setList.get(s);
            ISubSystem srcSubSystem = set.getSubSystem();
            ISystemDragDropAdapter srcAdapter = set.getAdapter();
            String srcType = srcSubSystem.getName();
            sameSubSystemType = targetType.equals(srcType);
            if (!sameSubSystemType && targetSubSystem != null) {
                ISystemResourceSet tempObjects = srcAdapter.doDrag(set, monitor);
                if (tempObjects == null) {
                    this.operationFailed(monitor);
                    this.showInvalidTransferMessage((ISystemResourceSet)set, targetPath);
                } else if (tempObjects.hasMessage()) {
                    this.operationFailed(monitor);
                    this.showErrorMessage(tempObjects.getMessage());
                } else if (targetAdapter.validateDrop(tempObjects, target, targetSubSystem == srcSubSystem)) {
                    int d;
                    ISystemResourceSet droppedObjects;
                    ISubSystemConfiguration factory;
                    if (target instanceof ISystemFilterReference && (factory = targetSubSystem.getSubSystemConfiguration()).supportsDropInFilters()) {
                        target = targetSubSystem.getTargetForFilter((ISystemFilterReference)target);
                        IAdaptable iAdaptable = (IAdaptable)target;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        targetAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
                    }
                    if ((droppedObjects = targetAdapter.doDrop(tempObjects, target, sameSubSystemType, targetSubSystem == srcSubSystem, this._sourceType, monitor)) == null) {
                        this.operationFailed(monitor);
                    } else if (droppedObjects.hasMessage()) {
                        List results = droppedObjects.getResourceSet();
                        d = 0;
                        while (d < results.size()) {
                            this._resultTgtObjects.add(results.get(d));
                            ++d;
                        }
                        this.operationFailed(monitor);
                        this.showErrorMessage(droppedObjects.getMessage());
                    } else {
                        List results = droppedObjects.getResourceSet();
                        d = 0;
                        while (d < results.size()) {
                            this._resultTgtObjects.add(results.get(d));
                            ++d;
                        }
                    }
                } else {
                    this.operationFailed(monitor);
                    this.showInvalidTransferMessage((ISystemResourceSet)set, targetPath);
                }
            } else {
                ISubSystemConfiguration factory;
                if (target instanceof ISystemFilterReference && targetSubSystem != null && (factory = targetSubSystem.getSubSystemConfiguration()).supportsDropInFilters()) {
                    if ((target = targetSubSystem.getTargetForFilter((ISystemFilterReference)target)) == null) {
                        return false;
                    }
                    IAdaptable iAdaptable = (IAdaptable)target;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    targetAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
                }
                if (targetAdapter.validateDrop((ISystemResourceSet)set, target, targetSubSystem == srcSubSystem)) {
                    ISystemResourceSet droppedObjects = targetAdapter.doDrop((ISystemResourceSet)set, target, sameSubSystemType, targetSubSystem == srcSubSystem, this._sourceType, monitor);
                    if (droppedObjects == null) {
                        this.operationFailed(monitor);
                    } else if (droppedObjects.hasMessage()) {
                        this.operationFailed(monitor);
                        this.showErrorMessage(droppedObjects.getMessage());
                    } else {
                        List results = droppedObjects.getResourceSet();
                        int d = 0;
                        while (d < results.size()) {
                            this._resultTgtObjects.add(results.get(d));
                            ++d;
                        }
                    }
                } else {
                    this.operationFailed(monitor);
                    this.showInvalidTransferMessage((ISystemResourceSet)set, targetPath);
                }
            }
            ++s;
        }
        return this._ok;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean transferRSEResourcesToEclipseResource(IResource target, ISubSystem targetSubSystem, IProgressMonitor monitor) {
        boolean alwaysOverwrite = false;
        ArrayList<IResource> resourcesToCopy = new ArrayList<IResource>();
        IWorkspaceRoot root = target.getWorkspace().getRoot();
        int i = 0;
        while (i < this._srcObjects.size() && this._ok) {
            Object srcObject = this._srcObjects.get(i);
            this._resultSrcObjects.add(srcObject);
            if (srcObject instanceof SystemMessage) {
                this.operationFailed(monitor);
                this.showErrorMessage((SystemMessage)srcObject);
            } else if (srcObject != null) {
                ISystemDragDropAdapter srcAdapter;
                Object tempFile;
                IAdaptable iAdaptable = (IAdaptable)srcObject;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((tempFile = (srcAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)).doDrag(srcObject, true, monitor)) instanceof IResource) {
                    boolean canCopy = true;
                    IResource res = (IResource)tempFile;
                    try {
                        int result;
                        IPath destPath = target.getFullPath();
                        destPath = destPath.append(res.getName());
                        IResource newResource = root.findMember(destPath);
                        if (!alwaysOverwrite && newResource != null && newResource.exists() && (result = this.checkOverwrite(res, newResource)) != 0) {
                            canCopy = false;
                            if (result == 1) {
                                monitor.setCanceled(true);
                                return false;
                            }
                            this._resultSrcObjects.remove(srcObject);
                        }
                        if (canCopy) {
                            resourcesToCopy.add(res);
                        }
                    }
                    catch (Exception e) {
                        this.operationFailed(monitor);
                        SystemBasePlugin.logError(e.getMessage(), e);
                    }
                }
            }
            ++i;
        }
        if (resourcesToCopy.isEmpty()) return true;
        IResource[] resources = resourcesToCopy.toArray(new IResource[resourcesToCopy.size()]);
        IPath destinationPath = target.getFullPath();
        CopyResourcesOperation op = new CopyResourcesOperation(resources, destinationPath, SystemResources.RESID_COPY_TITLE);
        IAdaptable adaptable = WorkspaceUndoUtil.getUIInfoAdapter((Shell)this._shell);
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, adaptable);
            return true;
        }
        catch (ExecutionException e) {
            SystemMessage errorMessage = RSEUIPlugin.getPluginMessage("RSEG1003");
            if (e.getCause() instanceof CoreException) {
                SystemBasePlugin.logError(e.getMessage(), e);
                errorMessage.makeSubstitution((Object)e.getCause().getMessage());
            } else {
                SystemBasePlugin.logError(e.getMessage(), e);
                errorMessage.makeSubstitution((Object)e.getMessage());
            }
            this.showErrorMessage(errorMessage);
            this.operationFailed(monitor);
            return false;
        }
    }

    private int checkOverwrite(IResource source, final IResource destination) {
        final int[] result = new int[1];
        Runnable query = new Runnable(){

            public void run() {
                int[] nArray = new int[2];
                nArray[1] = 1;
                int[] resultId = nArray;
                String[] labels = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
                String title = SystemResources.RESID_COLLISION_RENAME_TITLE;
                String correctedVerbiage = SystemResources.RESID_COLLISION_RENAME_VERBIAGE.replaceAll("&1", "{0}");
                String msg = NLS.bind((String)correctedVerbiage, (Object)destination.getFullPath().makeRelative());
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), title, null, msg, 3, labels, 0);
                dialog.open();
                result[0] = dialog.getReturnCode() == -1 ? 1 : resultId[dialog.getReturnCode()];
            }
        };
        PlatformUI.getWorkbench().getDisplay().syncExec(query);
        return result[0];
    }

    protected boolean transferNonRSEResources(Object target, ISubSystem targetSubSystem, ISystemDragDropAdapter targetAdapter, IProgressMonitor monitor) {
        int i = 0;
        while (i < this._srcObjects.size() && this._ok) {
            Object srcObject = this._srcObjects.get(i);
            this._resultSrcObjects.add(srcObject);
            if (srcObject instanceof SystemMessage) {
                this.operationFailed(monitor);
                this.showErrorMessage((SystemMessage)srcObject);
            } else if (srcObject != null) {
                Object droppedObject;
                ISubSystemConfiguration factory;
                if (target instanceof ISystemFilterReference && targetSubSystem != null && (factory = targetSubSystem.getSubSystemConfiguration()).supportsDropInFilters() && factory.providesCustomDropInFilters()) {
                    ((ISystemFilterReference)target).markStale(true);
                    target = targetSubSystem.getTargetForFilter((ISystemFilterReference)target);
                    IAdaptable iAdaptable = (IAdaptable)target;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    targetAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
                }
                if (this._sourceType == 1) {
                    IResource resource = null;
                    if (srcObject instanceof IResource) {
                        resource = (IResource)srcObject;
                    } else if (srcObject instanceof IAdaptable) {
                        IAdaptable iAdaptable = (IAdaptable)srcObject;
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        resource = (IResource)iAdaptable.getAdapter((Class)clazz);
                    } else {
                        IAdapterManager iAdapterManager = Platform.getAdapterManager();
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        resource = (IResource)iAdapterManager.getAdapter(srcObject, (Class)clazz);
                    }
                    if (resource != null) {
                        droppedObject = targetAdapter.doDrop((Object)resource, target, false, false, this._sourceType, monitor);
                        if (droppedObject == null) {
                            this.operationFailed(monitor);
                        } else {
                            this._resultTgtObjects.add(droppedObject);
                        }
                    }
                } else if (this._sourceType == 2) {
                    if (srcObject instanceof String) {
                        String file = (String)srcObject;
                        droppedObject = targetAdapter.doDrop((Object)file, target, false, false, this._sourceType, monitor);
                        if (droppedObject == null) {
                            this.operationFailed(monitor);
                        } else {
                            this._resultTgtObjects.add(droppedObject);
                        }
                    }
                } else if (this._sourceType == 3) {
                    if (srcObject instanceof String) {
                        String text = (String)srcObject;
                        droppedObject = targetAdapter.doDrop((Object)text, target, false, false, this._sourceType, monitor);
                        if (droppedObject == null) {
                            this.operationFailed(monitor);
                        } else {
                            this._resultTgtObjects.add(droppedObject);
                        }
                    }
                } else if (this._sourceType == 0) {
                    ISystemDragDropAdapter srcAdapter;
                    IAdaptable iAdaptable = (IAdaptable)srcObject;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((srcAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                        if (srcObject instanceof IHost) {
                            Object tempObject = srcAdapter.doDrag(srcObject, false, monitor);
                            if (targetAdapter.validateDrop(tempObject, target, false)) {
                                targetAdapter.doDrop(tempObject, target, false, false, this._sourceType, monitor);
                                this._resultTgtObjects.add(tempObject);
                            }
                        } else {
                            ISubSystem srcSubSystem = srcAdapter.getSubSystem(srcObject);
                            if (srcSubSystem.isConnected() || srcObject instanceof ISystemFilterReference || srcObject instanceof ISubSystem) {
                                String srcType = srcSubSystem.getName();
                                String srcPath = srcAdapter.getAbsoluteName(srcObject);
                                String targetPath = targetAdapter.getAbsoluteName(target);
                                boolean sameSubSystemType = true;
                                if (targetSubSystem != null) {
                                    String targetType = targetSubSystem.getName();
                                    sameSubSystemType = targetType.equals(srcType);
                                }
                                if (!sameSubSystemType) {
                                    Object tempObject = srcAdapter.doDrag(srcObject, sameSubSystemType, monitor);
                                    if (tempObject == null) {
                                        this.operationFailed(monitor);
                                        this.showInvalidTransferMessage(srcPath, targetPath);
                                    } else if (tempObject instanceof SystemMessage) {
                                        this.operationFailed(monitor);
                                        this.showErrorMessage((SystemMessage)tempObject);
                                    } else if (targetAdapter.validateDrop(tempObject, target, targetSubSystem == srcSubSystem)) {
                                        Object droppedObject2;
                                        ISubSystemConfiguration factory2;
                                        if (target instanceof ISystemFilterReference && targetSubSystem != null && (factory2 = targetSubSystem.getSubSystemConfiguration()).supportsDropInFilters() && factory2.providesCustomDropInFilters()) {
                                            target = targetSubSystem.getTargetForFilter((ISystemFilterReference)target);
                                            IAdaptable iAdaptable2 = (IAdaptable)target;
                                            Class<?> clazz2 = class$0;
                                            if (clazz2 == null) {
                                                try {
                                                    clazz2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            targetAdapter = (ISystemDragDropAdapter)iAdaptable2.getAdapter((Class)clazz2);
                                        }
                                        if ((droppedObject2 = targetAdapter.doDrop(tempObject, target, sameSubSystemType, targetSubSystem == srcSubSystem, this._sourceType, monitor)) == null) {
                                            this.operationFailed(monitor);
                                        } else if (droppedObject2 instanceof SystemMessage) {
                                            this.operationFailed(monitor);
                                            this.showErrorMessage((SystemMessage)droppedObject2);
                                        } else {
                                            this._resultTgtObjects.add(droppedObject2);
                                        }
                                    } else {
                                        this.operationFailed(monitor);
                                        this.showInvalidTransferMessage(srcPath, targetPath);
                                    }
                                } else if (srcObject != target && !srcPath.equals(targetPath)) {
                                    ISubSystemConfiguration factory3;
                                    if (target instanceof ISystemFilterReference && targetSubSystem != null && (factory3 = targetSubSystem.getSubSystemConfiguration()).supportsDropInFilters() && factory3.providesCustomDropInFilters()) {
                                        target = targetSubSystem.getTargetForFilter((ISystemFilterReference)target);
                                        IAdaptable iAdaptable3 = (IAdaptable)target;
                                        Class<?> clazz3 = class$0;
                                        if (clazz3 == null) {
                                            try {
                                                clazz3 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        targetAdapter = (ISystemDragDropAdapter)iAdaptable3.getAdapter((Class)clazz3);
                                    }
                                    if (targetAdapter.validateDrop(srcObject, target, targetSubSystem == srcSubSystem)) {
                                        Object droppedObject3 = targetAdapter.doDrop(srcObject, target, sameSubSystemType, targetSubSystem == srcSubSystem, this._sourceType, monitor);
                                        if (droppedObject3 == null) {
                                            this.operationFailed(monitor);
                                        } else if (droppedObject3 instanceof SystemMessage) {
                                            this.operationFailed(monitor);
                                            this.showErrorMessage((SystemMessage)droppedObject3);
                                        } else {
                                            this._resultTgtObjects.add(droppedObject3);
                                        }
                                    } else {
                                        this.operationFailed(monitor);
                                        this.showInvalidTransferMessage(srcPath, targetPath);
                                    }
                                } else {
                                    this.operationFailed(monitor);
                                    this.showInvalidTransferMessage(srcPath, targetPath);
                                }
                            }
                        }
                    }
                }
            }
            if (monitor != null && monitor.isCanceled()) {
                this._ok = false;
                return this._ok;
            }
            ++i;
        }
        return true;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        this._ok = true;
        Object target = this._currentTarget;
        ISubSystem targetSubSystem = null;
        if (target instanceof IAdaptable) {
            ISystemDragDropAdapter targetAdapter;
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((targetAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)) != null && !(target instanceof IResource)) {
                targetSubSystem = targetAdapter.getSubSystem(target);
                if (targetSubSystem != null && !targetSubSystem.isConnected()) {
                    try {
                        targetSubSystem.connect(monitor, false);
                    }
                    catch (Exception exception) {}
                }
                SystemMessage copyMessage = RSEUIPlugin.getPluginMessage("RSEG1115");
                if (monitor != null) {
                    monitor.beginTask(copyMessage.getLevelOneText(), -1);
                }
                if (this._sourceType == 0) {
                    this.transferRSEResources(target, targetSubSystem, targetAdapter, monitor);
                } else {
                    this.transferNonRSEResources(target, targetSubSystem, targetAdapter, monitor);
                }
            } else if (target instanceof IResource) {
                this.transferRSEResourcesToEclipseResource((IResource)target, targetSubSystem, monitor);
            }
        }
        if (this._ok && monitor != null) {
            monitor.done();
        }
        if (target != null && target instanceof ISystemContainer) {
            ((ISystemContainer)target).markStale(true);
        }
        RefreshJob refresh = new RefreshJob(target, targetSubSystem);
        refresh.schedule();
        return Status.OK_STATUS;
    }

    private void operationFailed(IProgressMonitor monitor) {
        this._ok = false;
        if (monitor != null) {
            monitor.done();
        }
    }

    private void showInvalidTransferMessage(String srcPath, String targetPath) {
        SystemMessage errorMessage = RSEUIPlugin.getPluginMessage("RSEG1270");
        errorMessage.makeSubstitution((Object)srcPath, (Object)targetPath);
        this.showErrorMessage(errorMessage);
    }

    private void showInvalidTransferMessage(ISystemResourceSet resourceSet, String targetPath) {
        SystemMessage errorMessage = RSEUIPlugin.getPluginMessage("RSEG1270");
        errorMessage.makeSubstitution((Object)resourceSet.toString(), (Object)targetPath);
        this.showErrorMessage(errorMessage);
    }

    private void showErrorMessage(SystemMessage errorMessage) {
        Display.getDefault().asyncExec((Runnable)new ShowErrorRunnable(errorMessage));
    }

    public boolean dropOkay() {
        return this._ok;
    }

    public class RefreshJob
    extends UIJob {
        private Object _target;
        private ISubSystem _targetSubSystem;

        public RefreshJob(Object target, ISubSystem targetSubSystem) {
            super("Refresh");
            this._target = target;
            this._targetSubSystem = targetSubSystem;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            String[] oldNames = new String[SystemDNDTransferRunnable.this._resultSrcObjects.size()];
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            if (SystemDNDTransferRunnable.this._resultTgtObjects.size() > 0) {
                boolean doRefresh = SystemDNDTransferRunnable.this._ok;
                int t = 0;
                while (t < SystemDNDTransferRunnable.this._resultTgtObjects.size() && t < SystemDNDTransferRunnable.this._resultSrcObjects.size()) {
                    Object src;
                    Object tgt = SystemDNDTransferRunnable.this._resultTgtObjects.get(t);
                    doRefresh = tgt != (src = SystemDNDTransferRunnable.this._resultSrcObjects.get(t)) && tgt != null;
                    ISystemDragDropAdapter adapter = null;
                    if (src instanceof IAdaptable) {
                        IAdaptable iAdaptable = (IAdaptable)src;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        adapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
                    } else {
                        IAdapterManager iAdapterManager = Platform.getAdapterManager();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        adapter = (ISystemDragDropAdapter)iAdapterManager.getAdapter(src, (Class)clazz);
                    }
                    oldNames[t] = adapter != null ? adapter.getAbsoluteName(src) : (src instanceof IResource ? ((IResource)src).getFullPath().toOSString() : (src instanceof String ? (String)src : ""));
                    ++t;
                }
                if (SystemDNDTransferRunnable.this._originatingViewer instanceof TreeViewer) {
                    try {
                        TreeViewer viewer = (TreeViewer)SystemDNDTransferRunnable.this._originatingViewer;
                        viewer.setExpandedState(this._target, true);
                    }
                    catch (Exception exception) {}
                }
                if (doRefresh) {
                    String operation = "COPY";
                    registry.fireRemoteResourceChangeEvent(operation, 1, (Object)SystemDNDTransferRunnable.this._resultTgtObjects, this._target, this._targetSubSystem, oldNames, (Object)SystemDNDTransferRunnable.this._originatingViewer);
                } else if (this._target instanceof SystemScratchpad) {
                    registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)SystemDNDTransferRunnable.this._resultTgtObjects, 51, this._target));
                }
            }
            return Status.OK_STATUS;
        }
    }

    public class ShowErrorRunnable
    implements Runnable {
        SystemMessage _errorMessage;

        public ShowErrorRunnable(SystemMessage errorMessage) {
            this._errorMessage = errorMessage;
        }

        public void run() {
            Shell shell = SystemBasePlugin.getActiveWorkbenchShell();
            SystemMessageDialog dlg = new SystemMessageDialog(shell, this._errorMessage);
            dlg.open();
        }
    }
}

