/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.shells.ui.view;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.shells.ui.ShellsUIPlugin;
import org.eclipse.rse.internal.shells.ui.actions.SystemCommandAction;
import org.eclipse.rse.internal.shells.ui.actions.SystemExportShellHistoryAction;
import org.eclipse.rse.internal.shells.ui.actions.SystemExportShellOutputAction;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.view.SubSystemConfigurationAdapter;
import org.eclipse.swt.widgets.Shell;

public class ShellServiceSubSystemConfigurationAdapter
extends SubSystemConfigurationAdapter {
    protected IAction _exportShellHistoryAction;
    protected IAction _exportShellOutputAction;
    protected SystemCommandAction _commandAction;
    protected ImageDescriptor _activeShellImageDescriptor;
    protected ImageDescriptor _inactiveShellImageDescriptor;

    public IAction[] getSubSystemActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup, ISubSystemConfiguration factory, ISubSystem selectedSubSystem) {
        ArrayList<IAction> allActions = new ArrayList<IAction>();
        IAction[] baseActions = super.getSubSystemActions(menu, selection, shell, menuGroup, factory, selectedSubSystem);
        int i = 0;
        while (i < baseActions.length) {
            allActions.add(baseActions[i]);
            ++i;
        }
        if (selectedSubSystem instanceof IRemoteFileSubSystem) {
            IRemoteFileSubSystem fs = (IRemoteFileSubSystem)selectedSubSystem;
            IRemoteCmdSubSystem cmdSubSystem = RemoteCommandHelpers.getCmdSubSystem(fs.getHost());
            if (cmdSubSystem != null) {
                allActions.add(this.getCommandShellAction(cmdSubSystem, shell));
            }
        } else if (selectedSubSystem instanceof IRemoteCmdSubSystem) {
            allActions.add(this.getCommandShellAction((IRemoteCmdSubSystem)selectedSubSystem, shell));
        }
        return allActions.toArray(new IAction[allActions.size()]);
    }

    public IAction getCommandShellAction(IRemoteCmdSubSystem selectedSubSystem, Shell shell) {
        if (this._commandAction == null) {
            this._commandAction = new SystemCommandAction(shell, true, selectedSubSystem);
        } else {
            this._commandAction.setSubSystem(selectedSubSystem);
        }
        return this._commandAction;
    }

    public IAction getCommandShellHistoryExportAction(Shell shell) {
        if (this._exportShellHistoryAction == null) {
            this._exportShellHistoryAction = new SystemExportShellHistoryAction(shell);
        }
        return this._exportShellHistoryAction;
    }

    public IAction getCommandShellOutputExportAction(Shell shell) {
        if (this._exportShellOutputAction == null) {
            this._exportShellOutputAction = new SystemExportShellOutputAction(shell);
        }
        return this._exportShellOutputAction;
    }

    public ImageDescriptor getActiveCommandShellImageDescriptor() {
        if (this._activeShellImageDescriptor == null) {
            this._activeShellImageDescriptor = ShellsUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.shells.ui.systemshellliveIcon");
        }
        return this._activeShellImageDescriptor;
    }

    public ImageDescriptor getInactiveCommandShellImageDescriptor() {
        if (this._inactiveShellImageDescriptor == null) {
            this._inactiveShellImageDescriptor = ShellsUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.shells.ui.systemshellIcon");
        }
        return this._inactiveShellImageDescriptor;
    }
}

