/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.terminals;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.rse.internal.services.terminals.IBaseShell;

public class ProcessBaseShell
extends PlatformObject
implements IBaseShell {
    protected final Process fProcess;

    public ProcessBaseShell(Process p) {
        this.fProcess = p;
    }

    public void exit() {
        this.fProcess.destroy();
    }

    public int exitValue() {
        return this.fProcess.exitValue();
    }

    public InputStream getErrorStream() {
        return this.fProcess.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.fProcess.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.fProcess.getOutputStream();
    }

    public boolean isActive() {
        try {
            this.fProcess.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        return false;
    }

    public boolean waitFor(long timeout) throws InterruptedException {
        boolean active = this.isActive();
        if (active) {
            Watchdog watchdog = null;
            if (timeout > 0L) {
                watchdog = new Watchdog(Thread.currentThread(), timeout){

                    protected boolean conditionDone() {
                        return !ProcessBaseShell.this.isActive();
                    }
                };
                watchdog.start();
            }
            try {
                this.fProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            if (watchdog != null) {
                watchdog.interrupt();
            }
            active = this.isActive();
        }
        return active;
    }

    private static abstract class Watchdog
    extends Thread {
        private final Thread fThreadToWatch;
        private long fTimeout;

        public Watchdog(Thread threadToWatch, long timeout) {
            this.fThreadToWatch = threadToWatch;
            this.fTimeout = timeout;
        }

        protected abstract boolean conditionDone();

        public void run() {
            try {
                try {
                    Watchdog.sleep(this.fTimeout);
                }
                catch (InterruptedException interruptedException) {
                    if (!this.conditionDone()) {
                        this.fThreadToWatch.interrupt();
                    }
                }
            }
            finally {
                if (!this.conditionDone()) {
                    this.fThreadToWatch.interrupt();
                }
            }
        }
    }
}

