/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SystemEncodingUtil {
    private static SystemEncodingUtil instance;
    public static String ENCODING_UTF_8;
    private DefaultEncodingProvider _defaultEncodingProvider = new DefaultEncodingProvider();

    static {
        ENCODING_UTF_8 = "UTF-8";
    }

    private SystemEncodingUtil() {
    }

    public static SystemEncodingUtil getInstance() {
        if (instance == null) {
            instance = new SystemEncodingUtil();
        }
        return instance;
    }

    public void setDefaultEncodingProvider(DefaultEncodingProvider p) {
        this._defaultEncodingProvider = p;
    }

    public String getLocalDefaultEncoding() {
        return this._defaultEncodingProvider.getLocalDefaultEncoding();
    }

    public String getEnvironmentEncoding() {
        return System.getProperty("file.encoding");
    }

    public boolean isXML(String filePath) {
        int index = filePath.lastIndexOf(".");
        if (index == -1) {
            return false;
        }
        if (index == filePath.length() - 1) {
            return false;
        }
        String extension = filePath.substring(index + 1);
        return extension.equalsIgnoreCase("xml") || extension.equalsIgnoreCase("xmi");
    }

    public String getXMLFileEncoding(String filePath) throws IOException {
        String encoding = null;
        FileInputStream stream = new FileInputStream(filePath);
        String encodingGuess = this.getEncodingFromBOM(stream);
        stream.close();
        if (encodingGuess == null) {
            stream = new FileInputStream(filePath);
            byte[] tempSigned = new byte[4];
            stream.read(tempSigned);
            stream.close();
            int[] temp = new int[4];
            int i = 0;
            while (i < 4) {
                temp[i] = 0xFF & tempSigned[i];
                ++i;
            }
            encodingGuess = temp[0] == 60 && temp[1] == 63 && temp[2] == 120 && temp[3] == 109 ? ENCODING_UTF_8 : (temp[0] == 0 && temp[1] == 60 && temp[2] == 0 && temp[3] == 63 ? "UnicodeBigUnmarked" : (temp[0] == 60 && temp[1] == 0 && temp[2] == 63 && temp[3] == 0 ? "UnicodeLittleUnmarked" : (temp[0] == 76 && temp[1] == 111 && temp[2] == 167 && temp[3] == 148 ? "Cp037" : ENCODING_UTF_8)));
        }
        if (encodingGuess != null) {
            boolean encodingFound = false;
            FileInputStream inputStream = new FileInputStream(filePath);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, encodingGuess);
            BufferedReader bufReader = new BufferedReader(reader, 1);
            String line = bufReader.readLine();
            while (line != null) {
                int encodingIndex = line.indexOf("encoding");
                if (encodingIndex != -1) {
                    boolean sameLine = true;
                    boolean doubleQuoteFound = false;
                    boolean singleQuoteFound = false;
                    while (line != null) {
                        int beginQuote = -1;
                        if (sameLine) {
                            beginQuote = line.indexOf(34, encodingIndex + 9);
                            if (beginQuote == -1) {
                                beginQuote = line.indexOf(39, encodingIndex + 9);
                                if (beginQuote != -1) {
                                    singleQuoteFound = true;
                                }
                            } else {
                                doubleQuoteFound = true;
                            }
                        } else {
                            beginQuote = line.indexOf(34);
                            if (beginQuote == -1) {
                                beginQuote = line.indexOf(39);
                                if (beginQuote != -1) {
                                    singleQuoteFound = true;
                                }
                            } else {
                                doubleQuoteFound = true;
                            }
                        }
                        if (beginQuote != -1) {
                            int endQuote = -1;
                            if (doubleQuoteFound) {
                                endQuote = line.indexOf(34, beginQuote + 1);
                            } else if (singleQuoteFound) {
                                endQuote = line.indexOf(39, beginQuote + 1);
                            }
                            if (endQuote == -1) break;
                            encoding = line.substring(beginQuote + 1, endQuote);
                            encodingFound = true;
                            break;
                        }
                        if (sameLine) {
                            sameLine = false;
                        }
                        line = bufReader.readLine();
                    }
                }
                if (encodingFound) break;
                line = bufReader.readLine();
            }
            bufReader.close();
            if (encoding == null && (encodingGuess.equals(ENCODING_UTF_8) || encodingGuess.startsWith("UnicodeBig") || encodingGuess.equals("UnicodeLittle"))) {
                encoding = encodingGuess;
            }
        }
        return encoding;
    }

    public String getEncodingFromBOM(String filePath) throws IOException {
        FileInputStream stream = new FileInputStream(filePath);
        String encoding = this.getEncodingFromBOM(stream);
        stream.close();
        return encoding;
    }

    private String getEncodingFromBOM(InputStream stream) throws IOException {
        byte[] bomBytes = new byte[4];
        stream.read(bomBytes, 0, 3);
        if (bomBytes[0] == 239 && bomBytes[1] == 187 && bomBytes[2] == 191) {
            return ENCODING_UTF_8;
        }
        stream.read(bomBytes, 3, 1);
        if (bomBytes[0] == 0 && bomBytes[1] == 0 && bomBytes[2] == 254 && bomBytes[3] == 255) {
            return null;
        }
        if (bomBytes[0] == 255 && bomBytes[1] == 254 && bomBytes[2] == 0 && bomBytes[3] == 0) {
            return null;
        }
        if (bomBytes[0] == 0 && bomBytes[1] == 0 && bomBytes[2] == 255 && bomBytes[3] == 254) {
            return null;
        }
        if (bomBytes[0] == 254 && bomBytes[1] == 255 && bomBytes[2] == 0 && bomBytes[3] == 0) {
            return null;
        }
        if (bomBytes[0] == 254 && bomBytes[1] == 255 && (bomBytes[2] != 0 || bomBytes[3] != 0)) {
            return "UnicodeBig";
        }
        if (bomBytes[0] == 255 && bomBytes[1] == 254 && (bomBytes[2] != 0 || bomBytes[3] != 0)) {
            return "UnicodeLittle";
        }
        return null;
    }

    public static class DefaultEncodingProvider {
        public String getLocalDefaultEncoding() {
            return System.getProperty("file.encoding");
        }
    }
}

