/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.core.filters.HostOwnedFilterPoolPattern;
import org.eclipse.rse.internal.persistence.IRSEImportExportProvider;
import org.eclipse.rse.internal.persistence.dom.RSEDOMExporter;
import org.eclipse.rse.internal.persistence.dom.RSEDOMImporter;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;
import org.eclipse.rse.persistence.dom.RSEDOMNode;

public class RSEEnvelope {
    private static IStatus INVALID_FORMAT = new Status(4, "org.eclipse.rse.core", 2, RSECoreMessages.RSEEnvelope_IncorrectFormat, null);
    private static IStatus MODEL_NOT_EXPORTED = new Status(4, "org.eclipse.rse.core", RSECoreMessages.RSEEnvelope_ModelNotExported);
    private RSEDOM dom = null;

    public void get(InputStream in, IProgressMonitor monitor) throws CoreException {
        File envelopeFolder = this.getTemporaryFolder();
        IStatus status = this.unzip(in, envelopeFolder);
        if (status.isOK()) {
            String providerId = this.loadProviderId(envelopeFolder);
            IRSEPersistenceManager manager = RSECorePlugin.getThePersistenceManager();
            IRSEPersistenceProvider provider = manager.getPersistenceProvider(providerId);
            if (provider != null) {
                if (provider instanceof IRSEImportExportProvider) {
                    IRSEImportExportProvider ieProvider = (IRSEImportExportProvider)((Object)provider);
                    this.dom = ieProvider.importRSEDOM(envelopeFolder, monitor);
                    if (this.dom == null) {
                        status = INVALID_FORMAT;
                    }
                } else {
                    status = INVALID_FORMAT;
                }
            } else {
                status = INVALID_FORMAT;
            }
        }
        this.deleteFileSystemObject(envelopeFolder);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public void put(OutputStream out, IRSEPersistenceProvider provider, IProgressMonitor monitor) throws CoreException {
        IStatus status = Status.OK_STATUS;
        if (provider instanceof IRSEImportExportProvider) {
            IRSEImportExportProvider exportProvider = (IRSEImportExportProvider)((Object)provider);
            File envelopeFolder = this.getTemporaryFolder();
            boolean saved = exportProvider.exportRSEDOM(envelopeFolder, this.dom, monitor);
            if (saved) {
                status = this.saveProviderId(envelopeFolder, exportProvider);
                if (status.isOK()) {
                    status = this.zip(envelopeFolder, out);
                }
                this.deleteFileSystemObject(envelopeFolder);
            } else {
                status = MODEL_NOT_EXPORTED;
            }
        } else {
            status = MODEL_NOT_EXPORTED;
        }
        try {
            out.close();
        }
        catch (IOException e) {
            status = this.makeStatus(e);
        }
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public void add(final IHost host) {
        ISubSystem[] subsystems = host.getSubSystems();
        int i = 0;
        while (i < subsystems.length) {
            ISubSystem subsystem = subsystems[i];
            ISystemFilterPool pool = subsystem.getUniqueOwningSystemFilterPool(false);
            if (pool != null) {
                this.add(pool);
            }
            ++i;
        }
        String type = "Host";
        String name = host.getName();
        Runnable action = new Runnable(){

            public void run() {
                RSEDOMExporter.getInstance().createNode((RSEDOMNode)RSEEnvelope.this.dom, host, true);
            }
        };
        this.addNode(type, name, action);
    }

    public void add(final ISystemFilterPool pool) {
        String type = "FilterPool";
        String name = pool.getName();
        Runnable action = new Runnable(){

            public void run() {
                RSEDOMExporter.getInstance().createNode((RSEDOMNode)RSEEnvelope.this.dom, pool, true);
            }
        };
        this.addNode(type, name, action);
    }

    public void add(final IPropertySet propertySet) {
        String type = "FilterPool";
        String name = propertySet.getName();
        Runnable action = new Runnable(){

            public void run() {
                RSEDOMExporter.getInstance().createNode((RSEDOMNode)RSEEnvelope.this.dom, propertySet, true);
            }
        };
        this.addNode(type, name, action);
    }

    public void mergeWith(ISystemProfile profile) throws CoreException {
        ArrayList<RSEDOMNode> hostNodes = new ArrayList<RSEDOMNode>(10);
        ArrayList<RSEDOMNode> filterPoolNodes = new ArrayList<RSEDOMNode>(10);
        ArrayList<RSEDOMNode> propertySetNodes = new ArrayList<RSEDOMNode>(10);
        HashMap<String, IHost> hostMap = new HashMap<String, IHost>(10);
        if (this.dom != null) {
            RSEDOMNode[] children = this.dom.getChildren();
            int i = 0;
            while (i < children.length) {
                RSEDOMNode child = children[i];
                String nodeType = child.getType();
                if (nodeType.equals("Host")) {
                    hostNodes.add(child);
                } else if (nodeType.equals("FilterPool")) {
                    filterPoolNodes.add(child);
                } else if (nodeType.equals("PropertySet")) {
                    propertySetNodes.add(child);
                } else {
                    throw new IllegalArgumentException("invalid dom node type");
                }
                ++i;
            }
            Iterator z = hostNodes.iterator();
            while (z.hasNext()) {
                RSEDOMNode hostNode = (RSEDOMNode)z.next();
                String originalName = hostNode.getName();
                IHost host = this.mergeHost(profile, hostNode);
                hostMap.put(originalName, host);
            }
            z = filterPoolNodes.iterator();
            while (z.hasNext()) {
                RSEDOMNode filterPoolNode = (RSEDOMNode)z.next();
                String filterPoolName = filterPoolNode.getName();
                String configurationId = filterPoolNode.getAttribute("id").getValue();
                HostOwnedFilterPoolPattern pattern = new HostOwnedFilterPoolPattern(configurationId);
                String hostName = pattern.extract(filterPoolName);
                if (hostName != null) {
                    IHost host = (IHost)hostMap.get(hostName);
                    if (host != null) {
                        this.mergeHostFilterPool(profile, host, filterPoolNode);
                        continue;
                    }
                    this.mergeFilterPool(profile, filterPoolNode);
                    continue;
                }
                this.mergeFilterPool(profile, filterPoolNode);
            }
        }
    }

    private IHost mergeHost(ISystemProfile profile, RSEDOMNode hostNode) {
        String baseHostName;
        String hostName;
        IHost host = null;
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        if (registry.getHost(profile, hostName = (baseHostName = hostNode.getName())) != null) {
            int n = 0;
            while (registry.getHost(profile, hostName) != null) {
                hostName = String.valueOf(baseHostName) + "-" + ++n;
            }
            hostNode.setName(hostName);
        }
        RSEDOMImporter importer = RSEDOMImporter.getInstance();
        host = importer.restoreHost(profile, hostNode);
        return host;
    }

    private void mergeHostFilterPool(ISystemProfile profile, IHost host, RSEDOMNode filterPoolNode) {
        String configurationId = filterPoolNode.getAttribute("id").getValue();
        HostOwnedFilterPoolPattern pattern = new HostOwnedFilterPoolPattern(configurationId);
        String hostName = host.getAliasName();
        String filterPoolName = pattern.make(hostName);
        filterPoolNode.setName(filterPoolName);
        RSEDOMImporter importer = RSEDOMImporter.getInstance();
        ISystemFilterPool filterPool = importer.restoreFilterPool(profile, filterPoolNode);
        filterPool.setOwningParentName(hostName);
    }

    private ISystemFilterPool mergeFilterPool(ISystemProfile profile, RSEDOMNode filterPoolNode) {
        ISystemFilterPool filterPool = this.getMatchingFilterPool(profile, filterPoolNode);
        if (filterPool != null) {
            String filterPoolName = filterPoolNode.getName();
            int n = 0;
            while (filterPool != null) {
                filterPoolName = String.valueOf(filterPoolName) + "-" + ++n;
                filterPoolNode.setName(filterPoolName);
                filterPool = this.getMatchingFilterPool(profile, filterPoolNode);
            }
        }
        RSEDOMImporter importer = RSEDOMImporter.getInstance();
        filterPool = importer.restoreFilterPool(profile, filterPoolNode);
        return filterPool;
    }

    private ISystemFilterPool getMatchingFilterPool(ISystemProfile profile, RSEDOMNode filterPoolNode) {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        String filterPoolName = filterPoolNode.getName();
        String configurationId = filterPoolNode.getAttribute("id").getValue();
        ISubSystemConfiguration subsystemConfiguration = registry.getSubSystemConfiguration(configurationId);
        ISystemFilterPoolManager manager = subsystemConfiguration.getFilterPoolManager(profile);
        ISystemFilterPool filterPool = manager.getSystemFilterPool(filterPoolName);
        return filterPool;
    }

    private IStatus saveProviderId(File parent, IRSEImportExportProvider provider) {
        IStatus status = Status.OK_STATUS;
        String providerId = provider.getId();
        File idFile = new File(parent, "provider.id");
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(idFile));
            out.write(providerId);
            out.close();
        }
        catch (IOException e) {
            status = this.makeStatus(e);
        }
        return status;
    }

    private String loadProviderId(File parent) throws CoreException {
        String providerId = null;
        File idFile = new File(parent, "provider.id");
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(idFile)));
            providerId = in.readLine();
            in.close();
        }
        catch (IOException iOException) {
            IStatus status = INVALID_FORMAT;
            throw new CoreException(status);
        }
        return providerId;
    }

    private void addNode(String type, String name, Runnable action) {
        this.ensureDOM();
        RSEDOMNode existingNode = this.dom.getChild(type, name);
        if (existingNode != null) {
            this.dom.removeChild(existingNode);
        }
        action.run();
    }

    private void ensureDOM() {
        if (this.dom == null) {
            this.dom = new RSEDOM("dom");
        }
    }

    private String generateName(List usedNames) {
        String prefix = "env_";
        int n = 0;
        String name = String.valueOf(prefix) + n;
        while (usedNames.contains(name)) {
            name = String.valueOf(prefix) + ++n;
        }
        return name;
    }

    private IStatus zip(File source, OutputStream target) {
        IStatus status = Status.OK_STATUS;
        try {
            ZipOutputStream out = new ZipOutputStream(target);
            this.zipEntry(out, source, "");
            out.close();
        }
        catch (IOException e) {
            status = this.makeStatus(e);
        }
        return status;
    }

    private void zipEntry(ZipOutputStream out, File file, String entryName) {
        if (file.isDirectory()) {
            this.zipDirectoryEntry(out, file, entryName);
        } else {
            this.zipFileEntry(out, file, entryName);
        }
    }

    private void zipDirectoryEntry(ZipOutputStream out, File file, String entryName) {
        String fileName = file.getName();
        if (!fileName.equals(".") && !fileName.equals("..")) {
            if (entryName.length() > 0) {
                try {
                    ZipEntry entry = new ZipEntry(String.valueOf(entryName) + "/");
                    out.putNextEntry(entry);
                    out.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                File child = files[i];
                String childName = child.getName();
                String childEntryName = String.valueOf(entryName) + "/" + childName;
                this.zipEntry(out, child, childEntryName);
                ++i;
            }
        }
    }

    private void zipFileEntry(ZipOutputStream out, File file, String entryName) {
        try {
            ZipEntry entry = new ZipEntry(entryName);
            out.putNextEntry(entry);
            byte[] buffer = new byte[4096];
            FileInputStream in = new FileInputStream(file);
            int n = in.read(buffer);
            while (n >= 0) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
            in.close();
            out.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    private IStatus unzip(InputStream in, File root) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                ZipInputStream inZip = new ZipInputStream(in);
                ZipEntry entry = inZip.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    File target = new File(root, name);
                    if (entry.isDirectory()) {
                        target.mkdir();
                    } else {
                        byte[] buffer = new byte[4096];
                        FileOutputStream out = new FileOutputStream(target);
                        int n = inZip.read(buffer);
                        while (n >= 0) {
                            out.write(buffer, 0, n);
                            n = inZip.read(buffer);
                        }
                        out.close();
                    }
                    entry = inZip.getNextEntry();
                }
            }
            catch (FileNotFoundException e) {
                status = this.makeStatus(e);
                try {
                    in.close();
                }
                catch (IOException e2) {
                    status = this.makeStatus(e2);
                }
            }
            catch (ZipException e) {
                RSECorePlugin.getDefault().getLogger().logError(RSECoreMessages.RSEEnvelope_IncorrectFormat, e);
                status = INVALID_FORMAT;
                try {
                    in.close();
                }
                catch (IOException e3) {
                    status = this.makeStatus(e3);
                }
            }
            catch (IOException e) {
                status = this.makeStatus(e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e4) {
                    status = this.makeStatus(e4);
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                status = this.makeStatus(e);
            }
        }
        return status;
    }

    private IStatus deleteFileSystemObject(File file) {
        IStatus status = Status.OK_STATUS;
        String fileName = file.getName();
        if (!fileName.equals(".") && !fileName.equals("..") && file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    File child = files[i];
                    this.deleteFileSystemObject(child);
                    ++i;
                }
            }
            file.delete();
        }
        return status;
    }

    private IStatus makeStatus(Exception e) {
        Status status = new Status(4, "org.eclipse.rse.core", "Unexpected exception", (Throwable)e);
        return status;
    }

    private File getTemporaryFolder() {
        IPath stateLocation = RSECorePlugin.getDefault().getStateLocation();
        File stateFolder = new File(stateLocation.toOSString());
        File envelopesFolder = new File(stateFolder, "envelopes");
        envelopesFolder.mkdir();
        List<String> envelopeNames = Arrays.asList(envelopesFolder.list());
        String envelopeName = this.generateName(envelopeNames);
        File envelopeFolder = new File(envelopesFolder, envelopeName);
        envelopeFolder.mkdir();
        return envelopeFolder;
    }
}

