/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.languageconfiguration.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPairConditional;
import org.eclipse.tm4e.languageconfiguration.internal.model.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.CommentRule;
import org.eclipse.tm4e.languageconfiguration.internal.model.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.model.FoldingRules;
import org.eclipse.tm4e.languageconfiguration.internal.model.IndentationRules;
import org.eclipse.tm4e.languageconfiguration.internal.model.OnEnterRule;
import org.eclipse.tm4e.languageconfiguration.internal.model.RegExPattern;

public final class LanguageConfiguration {
    private @Nullable CommentRule comments;
    private List<CharacterPair> brackets = (List)NullSafetyHelper.lateNonNull();
    private @Nullable String wordPattern;
    private @Nullable IndentationRules indentationRules;
    private List<OnEnterRule> onEnterRules = (List)NullSafetyHelper.lateNonNull();
    private List<AutoClosingPairConditional> autoClosingPairs = (List)NullSafetyHelper.lateNonNull();
    private List<AutoClosingPair> surroundingPairs = (List)NullSafetyHelper.lateNonNull();
    private List<CharacterPair> colorizedBracketPairs = (List)NullSafetyHelper.lateNonNull();
    private @Nullable String autoCloseBefore;
    private @Nullable FoldingRules folding;

    private static String removeTrailingCommas(String jsonString) {
        return jsonString.replaceAll("(,)(\\s*\\n(\\s*\\/\\/.*\\n)*\\s*[\\]}])", "$2");
    }

    @NonNullByDefault(value={})
    public static @Nullable LanguageConfiguration load(@NonNull Reader reader) {
        String jsonString = LanguageConfiguration.removeTrailingCommas(new BufferedReader(reader).lines().collect(Collectors.joining("\n")));
        Gson gsonBuilder = new GsonBuilder().registerTypeAdapter(String.class, (json, typeOfT, context) -> {
            if (json.isJsonObject()) {
                JsonObject jsonObj = json.getAsJsonObject();
                return jsonObj.has("pattern") && jsonObj.get("pattern").isJsonPrimitive() ? jsonObj.get("pattern").getAsString() : null;
            }
            return json.getAsString();
        }).registerTypeAdapter(OnEnterRule.class, (json, typeOfT, context) -> {
            JsonObject actionJsonObj;
            String indentActionString;
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObj = json.getAsJsonObject();
            RegExPattern beforeText = LanguageConfiguration.getAsPattern(jsonObj.get("beforeText"));
            if (beforeText == null) {
                return null;
            }
            JsonElement actionElem = jsonObj.get("action");
            if (actionElem != null && actionElem.isJsonObject() && (indentActionString = LanguageConfiguration.getAsString((actionJsonObj = actionElem.getAsJsonObject()).get("indent"))) != null) {
                RegExPattern afterText = LanguageConfiguration.getAsPattern(jsonObj.get("afterText"));
                RegExPattern previousLineText = LanguageConfiguration.getAsPattern(jsonObj.get("previousLineText"));
                EnterAction.IndentAction indentAction = EnterAction.IndentAction.get(indentActionString);
                String appendText = LanguageConfiguration.getAsString(actionJsonObj.get("appendText"));
                Integer removeText = LanguageConfiguration.getAsInteger(actionJsonObj.get("removeText"));
                EnterAction action = new EnterAction(indentAction, appendText, removeText);
                return new OnEnterRule(beforeText, afterText, previousLineText, action);
            }
            return null;
        }).registerTypeAdapter(CommentRule.class, (json, typeOfT, context) -> {
            JsonArray blockCommentArray;
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObj = json.getAsJsonObject();
            String lineComment = LanguageConfiguration.getAsString(jsonObj.get("lineComment"));
            JsonElement blockCommentElem = jsonObj.get("blockComment");
            CharacterPair blockComment = null;
            if (blockCommentElem != null && blockCommentElem.isJsonArray() && (blockCommentArray = blockCommentElem.getAsJsonArray()).size() == 2) {
                String blockCommentStart = LanguageConfiguration.getAsString(blockCommentArray.get(0));
                String blockCommentEnd = LanguageConfiguration.getAsString(blockCommentArray.get(1));
                if (blockCommentStart != null && blockCommentEnd != null) {
                    blockComment = new CharacterPair(blockCommentStart, blockCommentEnd);
                }
            }
            return lineComment == null && blockComment == null ? null : new CommentRule(lineComment, blockComment);
        }).registerTypeAdapter(CharacterPair.class, (json, typeOfT, context) -> {
            if (!json.isJsonArray()) {
                return null;
            }
            JsonArray charsPair = json.getAsJsonArray();
            if (charsPair.size() != 2) {
                return null;
            }
            String open = LanguageConfiguration.getAsString(charsPair.get(0));
            String close = LanguageConfiguration.getAsString(charsPair.get(1));
            return open == null || close == null ? null : new CharacterPair(open, close);
        }).registerTypeAdapter(AutoClosingPair.class, (json, typeOfT, context) -> {
            String open = null;
            String close = null;
            if (json.isJsonArray()) {
                JsonArray charsPair = json.getAsJsonArray();
                if (charsPair.size() != 2) {
                    return null;
                }
                open = LanguageConfiguration.getAsString(charsPair.get(0));
                close = LanguageConfiguration.getAsString(charsPair.get(1));
            } else if (json.isJsonObject()) {
                JsonObject autoClosePair = json.getAsJsonObject();
                open = LanguageConfiguration.getAsString(autoClosePair.get("open"));
                close = LanguageConfiguration.getAsString(autoClosePair.get("close"));
            }
            return open == null || close == null ? null : new AutoClosingPair(open, close);
        }).registerTypeAdapter(AutoClosingPairConditional.class, (json, typeOfT, context) -> {
            ArrayList<String> notInList = new ArrayList<String>(2);
            String open = null;
            String close = null;
            if (json.isJsonArray()) {
                JsonArray charsPair = json.getAsJsonArray();
                if (charsPair.size() != 2) {
                    return null;
                }
                open = LanguageConfiguration.getAsString(charsPair.get(0));
                close = LanguageConfiguration.getAsString(charsPair.get(1));
            } else if (json.isJsonObject()) {
                JsonObject autoClosePair = json.getAsJsonObject();
                open = LanguageConfiguration.getAsString(autoClosePair.get("open"));
                close = LanguageConfiguration.getAsString(autoClosePair.get("close"));
                JsonElement notInElem = autoClosePair.get("notIn");
                if (notInElem != null && notInElem.isJsonArray()) {
                    for (JsonElement elem : notInElem.getAsJsonArray()) {
                        String string = LanguageConfiguration.getAsString(elem);
                        if (string == null) continue;
                        notInList.add(string);
                    }
                }
            }
            return open == null || close == null ? null : new AutoClosingPairConditional(open, close, notInList);
        }).registerTypeAdapter(FoldingRules.class, (json, typeOfT, context) -> {
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObj = json.getAsJsonObject();
            JsonElement markersElem = jsonObj.get("markers");
            if (markersElem != null && markersElem.isJsonObject()) {
                JsonObject markersObj = markersElem.getAsJsonObject();
                RegExPattern startMarker = LanguageConfiguration.getAsPattern(markersObj.get("start"));
                RegExPattern endMarker = LanguageConfiguration.getAsPattern(markersObj.get("end"));
                if (startMarker != null && endMarker != null) {
                    boolean offSide = LanguageConfiguration.getAsBoolean(jsonObj.get("offSide"), false);
                    return new FoldingRules(offSide, startMarker, endMarker);
                }
            }
            return null;
        }).registerTypeAdapter(IndentationRules.class, (json, typeT, context) -> {
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObj = json.getAsJsonObject();
            RegExPattern decreaseIndentPattern = LanguageConfiguration.getAsPattern(jsonObj.get("decreaseIndentPattern"));
            if (decreaseIndentPattern == null) {
                return null;
            }
            RegExPattern increaseIndentPattern = LanguageConfiguration.getAsPattern(jsonObj.get("increaseIndentPattern"));
            if (increaseIndentPattern == null) {
                return null;
            }
            return new IndentationRules(decreaseIndentPattern, increaseIndentPattern, LanguageConfiguration.getAsPattern(jsonObj.get("indentNextLinePattern")), LanguageConfiguration.getAsPattern(jsonObj.get("unIndentedLinePattern")));
        }).create();
        try {
            LanguageConfiguration langCfg = (LanguageConfiguration)NullSafetyHelper.castNonNull((Object)((LanguageConfiguration)gsonBuilder.fromJson(jsonString, LanguageConfiguration.class)));
            if (NullSafetyHelper.castNullable(langCfg.autoClosingPairs) == null) {
                langCfg.autoClosingPairs = Collections.emptyList();
            } else {
                langCfg.autoClosingPairs.removeIf(Objects::isNull);
            }
            if (NullSafetyHelper.castNullable(langCfg.brackets) == null) {
                langCfg.brackets = Collections.emptyList();
            } else {
                langCfg.brackets.removeIf(Objects::isNull);
            }
            if (NullSafetyHelper.castNullable(langCfg.onEnterRules) == null) {
                langCfg.onEnterRules = Collections.emptyList();
            } else {
                langCfg.onEnterRules.removeIf(Objects::isNull);
            }
            if (NullSafetyHelper.castNullable(langCfg.surroundingPairs) == null) {
                langCfg.surroundingPairs = Collections.emptyList();
            } else {
                langCfg.surroundingPairs.removeIf(Objects::isNull);
            }
            if (NullSafetyHelper.castNullable(langCfg.colorizedBracketPairs) == null) {
                langCfg.colorizedBracketPairs = Collections.emptyList();
            } else {
                langCfg.colorizedBracketPairs.removeIf(Objects::isNull);
            }
            return langCfg;
        }
        catch (Exception ex) {
            LanguageConfigurationPlugin.logError("Failed to load language configuration: " + String.valueOf(ex), ex);
            return null;
        }
    }

    private static @Nullable RegExPattern getAsPattern(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        if (element.isJsonObject()) {
            String pattern = LanguageConfiguration.getAsString(((JsonObject)element).get("pattern"));
            if (pattern == null || pattern.isEmpty()) {
                return null;
            }
            String flags = LanguageConfiguration.getAsString(((JsonObject)element).get("flags"));
            return RegExPattern.of(pattern, flags);
        }
        return RegExPattern.ofNullable(LanguageConfiguration.getAsString(element), null);
    }

    private static @Nullable String getAsString(@Nullable JsonElement element) {
        if (element != null) {
            try {
                return element.getAsString();
            }
            catch (Exception ex) {
                LanguageConfigurationPlugin.logError("Failed to convert JSON element [" + String.valueOf(element) + "] to String.", ex);
            }
        }
        return null;
    }

    private static boolean getAsBoolean(@Nullable JsonElement element, boolean defaultValue) {
        if (element != null) {
            try {
                return element.getAsBoolean();
            }
            catch (Exception ex) {
                LanguageConfigurationPlugin.logError("Failed to convert JSON element [" + String.valueOf(element) + "] to boolean.", ex);
            }
        }
        return defaultValue;
    }

    private static @Nullable Integer getAsInteger(@Nullable JsonElement element) {
        if (element != null) {
            try {
                return element.getAsInt();
            }
            catch (Exception ex) {
                LanguageConfigurationPlugin.logError("Failed to convert JSON element [" + String.valueOf(element) + "] to Integer.", ex);
            }
        }
        return null;
    }

    public @Nullable CommentRule getComments() {
        return this.comments;
    }

    public List<CharacterPair> getBrackets() {
        return this.brackets;
    }

    public @Nullable String getWordPattern() {
        return this.wordPattern;
    }

    public @Nullable IndentationRules getIndentationRules() {
        return this.indentationRules;
    }

    public List<OnEnterRule> getOnEnterRules() {
        return this.onEnterRules;
    }

    public List<AutoClosingPairConditional> getAutoClosingPairs() {
        return this.autoClosingPairs;
    }

    public List<AutoClosingPair> getSurroundingPairs() {
        return this.surroundingPairs;
    }

    public List<CharacterPair> getColorizedBracketPairs() {
        return this.colorizedBracketPairs;
    }

    public @Nullable String getAutoCloseBefore() {
        return this.autoCloseBefore;
    }

    public @Nullable FoldingRules getFolding() {
        return this.folding;
    }
}

