/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.registry.IGrammarSource;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.core.registry.Registry;

public class ReloadingRegistry
extends Registry {
    private static final long RECHECK_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(5L);
    private final Map<String, GrammarCacheState> grammarCacheStates = new HashMap<String, GrammarCacheState>();

    public ReloadingRegistry() {
    }

    public ReloadingRegistry(IRegistryOptions options) {
        super(options);
    }

    public @Nullable IGrammar grammarForScopeName(String scopeName) {
        GrammarCacheState state = this.grammarCacheStates.get(scopeName);
        if (state == null) {
            return null;
        }
        this._loadSingleGrammar(scopeName);
        return super.grammarForScopeName(scopeName);
    }

    protected boolean _loadSingleGrammar(String scopeName) {
        long nowNanos = System.nanoTime();
        return ((GrammarCacheState)NullSafetyHelper.castNonNull((Object)this.grammarCacheStates.compute(scopeName, (key, oldState) -> {
            if (oldState == null) {
                boolean isLoaded = this._doLoadSingleGrammar((String)key);
                IGrammarSource source = this._grammarSourceForScopeName((String)key);
                long lastModified = Math.max(source == null ? 0L : source.getLastModified(), 0L);
                return new GrammarCacheState(isLoaded, lastModified, nowNanos);
            }
            if (nowNanos - oldState.lastCheckedAt() < RECHECK_INTERVAL_NANOS) {
                return oldState;
            }
            IGrammarSource source = this._grammarSourceForScopeName((String)key);
            if (source == null) {
                return new GrammarCacheState(oldState.isLoaded(), oldState.modifiedAt(), nowNanos);
            }
            long lastModified = source.getLastModified();
            if (lastModified > oldState.modifiedAt()) {
                boolean isLoaded = this._doLoadSingleGrammar((String)key);
                return new GrammarCacheState(isLoaded, lastModified, nowNanos);
            }
            return new GrammarCacheState(oldState.isLoaded(), oldState.modifiedAt(), nowNanos);
        }))).isLoaded();
    }

    private record GrammarCacheState(boolean isLoaded, long modifiedAt, long lastCheckedAt) {
    }
}

