/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IToken;
import org.eclipse.tm4e.core.internal.grammar.AttributedScopeStack;
import org.eclipse.tm4e.core.internal.grammar.BalancedBracketSelectors;
import org.eclipse.tm4e.core.internal.grammar.StateStack;
import org.eclipse.tm4e.core.internal.grammar.TokenTypeMatcher;
import org.eclipse.tm4e.core.internal.grammar.tokenattrs.EncodedTokenAttributes;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;

public final class LineTokens {
    private static final System.Logger LOGGER = System.getLogger(LineTokens.class.getName());
    private static final Deque<Token> EMPTY_DEQUE = new ArrayDeque<Token>(0);
    private final boolean _emitBinaryTokens;
    private final String _lineText;
    private final Deque<Token> _tokens;
    private final List<Integer> _binaryTokens;
    private int _lastTokenEndIndex = 0;
    private @Nullable String _currentGrammarScope;
    private final List<TokenTypeMatcher> _tokenTypeOverrides;
    private final @Nullable BalancedBracketSelectors balancedBracketSelectors;

    LineTokens(boolean emitBinaryTokens, String lineText, List<TokenTypeMatcher> tokenTypeOverrides, @Nullable BalancedBracketSelectors balancedBracketSelectors) {
        this._emitBinaryTokens = emitBinaryTokens;
        this._tokenTypeOverrides = tokenTypeOverrides;
        String string = this._lineText = LOGGER.isLoggable(System.Logger.Level.TRACE) ? lineText : "";
        if (this._emitBinaryTokens) {
            this._tokens = EMPTY_DEQUE;
            this._binaryTokens = new ArrayList<Integer>();
        } else {
            this._tokens = new ArrayDeque<Token>();
            this._binaryTokens = Collections.emptyList();
        }
        this.balancedBracketSelectors = balancedBracketSelectors;
    }

    void produce(StateStack stack, int endIndex) {
        this._currentGrammarScope = stack.grammarScope;
        this.produceFromScopes(stack.contentNameScopesList, endIndex);
    }

    void produceFromScopes(@Nullable AttributedScopeStack scopesList, int endIndex) {
        List<String> scopes;
        if (this._lastTokenEndIndex >= endIndex) {
            return;
        }
        if (this._emitBinaryTokens) {
            List<String> scopes2;
            int metadata = scopesList != null ? scopesList.tokenAttributes : 0;
            boolean containsBalancedBrackets = false;
            BalancedBracketSelectors balancedBracketSelectors = this.balancedBracketSelectors;
            if (balancedBracketSelectors != null && balancedBracketSelectors.matchesAlways()) {
                containsBalancedBrackets = true;
            }
            if (!this._tokenTypeOverrides.isEmpty() || balancedBracketSelectors != null && !balancedBracketSelectors.matchesAlways() && !balancedBracketSelectors.matchesNever()) {
                scopes2 = scopesList != null ? scopesList.getScopeNames() : Collections.emptyList();
                for (TokenTypeMatcher tokenType : this._tokenTypeOverrides) {
                    if (!tokenType.matcher.matches(scopes2)) continue;
                    metadata = EncodedTokenAttributes.set(metadata, 0, tokenType.type, null, -1, 0, 0);
                }
                if (this.balancedBracketSelectors != null) {
                    containsBalancedBrackets = this.balancedBracketSelectors.match(scopes2);
                }
            }
            if (containsBalancedBrackets) {
                metadata = EncodedTokenAttributes.set(metadata, 0, 8, containsBalancedBrackets, -1, 0, 0);
            }
            if (!this._binaryTokens.isEmpty() && MoreCollections.getLastElement(this._binaryTokens) == metadata) {
                this._lastTokenEndIndex = endIndex;
                return;
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                scopes2 = scopesList != null ? scopesList.getScopeNames() : Collections.emptyList();
                LOGGER.log(System.Logger.Level.TRACE, "  token: |" + this._lineText.substring(this._lastTokenEndIndex >= 0 ? this._lastTokenEndIndex : 0, endIndex).replace("\n", "\\n") + "|");
                for (String scope : scopes2) {
                    LOGGER.log(System.Logger.Level.TRACE, "      * " + scope);
                }
            }
            this._binaryTokens.add(this._lastTokenEndIndex);
            this._binaryTokens.add(metadata);
            this._lastTokenEndIndex = endIndex;
            return;
        }
        List<String> list = scopes = scopesList != null ? scopesList.getScopeNames() : Collections.emptyList();
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "  token: |" + this._lineText.substring(this._lastTokenEndIndex >= 0 ? this._lastTokenEndIndex : 0, endIndex).replace("\n", "\\n") + "|");
            for (String scope : scopes) {
                LOGGER.log(System.Logger.Level.TRACE, "      * " + scope);
            }
        }
        this._tokens.add(new Token(this._lastTokenEndIndex, endIndex, scopes, this._currentGrammarScope));
        this._lastTokenEndIndex = endIndex;
    }

    IToken[] getResult(StateStack stack, int lineLength) {
        if (!this._tokens.isEmpty() && this._tokens.getLast().startIndex == lineLength - 1) {
            this._tokens.removeLast();
        }
        if (this._tokens.isEmpty()) {
            this._lastTokenEndIndex = -1;
            this.produce(stack, lineLength);
            this._tokens.getLast().startIndex = 0;
        }
        return (IToken[])this._tokens.toArray(Token[]::new);
    }

    int[] getBinaryResult(StateStack stack, int lineLength) {
        if (!this._binaryTokens.isEmpty() && MoreCollections.getElementAt(this._binaryTokens, -2) == lineLength - 1) {
            MoreCollections.removeLastElement(this._binaryTokens);
            MoreCollections.removeLastElement(this._binaryTokens);
        }
        if (this._binaryTokens.isEmpty()) {
            this._lastTokenEndIndex = -1;
            this.produce(stack, lineLength);
            this._binaryTokens.set(this._binaryTokens.size() - 2, 0);
        }
        return this._binaryTokens.stream().mapToInt(Integer::intValue).toArray();
    }

    public static final class Token
    implements IToken {
        public int startIndex;
        public final int endIndex;
        public final List<String> scopes;
        public final @Nullable String grammarScope;

        Token(int startIndex, int endIndex, List<String> scopes, @Nullable String grammarScope) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.scopes = scopes;
            this.grammarScope = grammarScope;
        }

        @Override
        public int getStartIndex() {
            return this.startIndex;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Token) {
                Token other = (Token)obj;
                return this.startIndex == other.startIndex && this.endIndex == other.endIndex && this.scopes.equals(other.scopes);
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.endIndex;
            result = 31 * result + this.scopes.hashCode();
            result = 31 * result + this.startIndex;
            return result;
        }

        @Override
        public void setStartIndex(int startIndex) {
            this.startIndex = startIndex;
        }

        @Override
        public int getEndIndex() {
            return this.endIndex;
        }

        @Override
        public List<String> getScopes() {
            return this.scopes;
        }

        public String toString() {
            return "{startIndex: " + this.startIndex + ", endIndex: " + this.endIndex + ", scopes: " + String.valueOf(this.scopes) + "}";
        }
    }
}

