/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.Collections;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeScope;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.NewMemberClassTypeMunger;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.UnresolvedType;

public class IntertypeMemberClassDeclaration
extends TypeDeclaration {
    private TypeReference onType;
    private ReferenceBinding onTypeResolvedBinding;
    private NewMemberClassTypeMunger newMemberClassTypeMunger;
    protected InterTypeScope interTypeScope;
    private boolean scopeSetup = false;

    public IntertypeMemberClassDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public ResolvedTypeMunger getMunger() {
        return this.newMemberClassTypeMunger;
    }

    @Override
    public void resolve(ClassScope aspectScope) {
        this.resolveOnType(aspectScope);
        this.ensureScopeSetup();
        super.resolve(aspectScope);
    }

    @Override
    public void resolve() {
        super.resolve();
    }

    @Override
    public void resolve(BlockScope blockScope) {
        throw new IllegalStateException();
    }

    @Override
    public void resolve(CompilationUnitScope upperScope) {
        throw new IllegalStateException();
    }

    @Override
    protected void generateAttributes(ClassFile classFile) {
        super.generateAttributes(classFile);
    }

    public AjAttribute getAttribute() {
        if (this.newMemberClassTypeMunger == null) {
            return null;
        }
        return new AjAttribute.TypeMunger((ResolvedTypeMunger)this.newMemberClassTypeMunger);
    }

    public void ensureScopeSetup() {
        if (this.scopeSetup) {
            return;
        }
        ClassScope scope = this.scope;
        if (scope != null) {
            this.interTypeScope = new InterTypeScope(scope.parent, this.onTypeResolvedBinding, Collections.emptyList());
            scope.setParent(this.interTypeScope);
        }
        this.scopeSetup = true;
    }

    public void setOnType(TypeReference onType) {
        this.onType = onType;
    }

    private void resolveOnType(ClassScope cuScope) {
        if (this.onType == null || this.onTypeResolvedBinding != null) {
            return;
        }
        this.onTypeResolvedBinding = (ReferenceBinding)this.onType.getTypeBindingPublic(cuScope);
        if (!this.onTypeResolvedBinding.isValidBinding()) {
            cuScope.problemReporter().invalidType(this.onType, this.onTypeResolvedBinding);
            this.ignoreFurtherInvestigation = true;
        } else if (this.binding != null) {
            ((NestedTypeBinding)this.binding).enclosingType = (SourceTypeBinding)this.onTypeResolvedBinding;
        }
    }

    public EclipseTypeMunger build(ClassScope classScope) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(classScope);
        this.resolveOnType(classScope);
        this.ensureScopeSetup();
        if (this.ignoreFurtherInvestigation) {
            return null;
        }
        if (this.onTypeResolvedBinding.isInterface() || this.onTypeResolvedBinding.isEnum() || this.onTypeResolvedBinding.isAnnotationType()) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "Cannot declare new member type on '" + this.onType.toString() + "'. New member types can only be specified on classes (compiler limitation)");
            return null;
        }
        if (!Modifier.isStatic(this.modifiers)) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "Intertype declared member types can only be static (compiler limitation)");
            return null;
        }
        ResolvedType declaringType = world.fromBinding(this.onTypeResolvedBinding).resolve(world.getWorld());
        if (declaringType.isRawType() || declaringType.isParameterizedType()) {
            declaringType = declaringType.getGenericType();
        }
        if (this.interTypeScope == null) {
            return null;
        }
        this.newMemberClassTypeMunger = new NewMemberClassTypeMunger((UnresolvedType)declaringType, new String(this.name));
        this.newMemberClassTypeMunger.setSourceLocation((ISourceLocation)new EclipseSourceLocation(this.compilationResult, this.sourceStart, this.sourceEnd));
        ResolvedType aspectType = world.fromEclipse(classScope.referenceContext.binding);
        return new EclipseTypeMunger(world, (ResolvedTypeMunger)this.newMemberClassTypeMunger, aspectType, null);
    }

    @Override
    public char[] alternativeName() {
        return CharOperation.concatWith(this.onType.getTypeName(), '.');
    }
}

