/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.bcel.ClassPathManager;

public class EclipseClassPathManager
extends ClassPathManager {
    private INameEnvironment nameEnv;

    public EclipseClassPathManager(INameEnvironment env) {
        this.nameEnv = env;
    }

    public void setNameEnvironment(INameEnvironment env) {
        this.nameEnv = env;
    }

    public void addPath(String name, IMessageHandler handler) {
        throw new UnsupportedOperationException("Can't add paths to an *Eclipse*ClassPathManager.");
    }

    public ClassPathManager.ClassFile find(UnresolvedType type) {
        char[][] cname;
        NameEnvironmentAnswer answer;
        ClassFileReaderBackedClassFile cf = null;
        String name = type.getName();
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        if ((answer = this.nameEnv.findType(cname = CharOperation.splitOn('.', name.toCharArray()))) == null || !answer.isBinaryType()) {
            return null;
        }
        IBinaryType binType = answer.getBinaryType();
        if (!(binType instanceof ClassFileReader)) {
            throw new IllegalArgumentException("I'm only geared up to handle ClassFileReaders, and you gave me a " + binType.getClass().getName());
        }
        ClassFileReader cfr = (ClassFileReader)binType;
        cf = new ClassFileReaderBackedClassFile(cfr);
        return cf;
    }

    public List getAllClassFiles() {
        throw new UnsupportedOperationException("I don't implement getAllClassFiles()");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("EclipseClassPathManager: ");
        buf.append(this.nameEnv.toString());
        return buf.toString();
    }

    private class ClassFileReaderBackedClassFile
    extends ClassPathManager.ClassFile {
        private ClassFileReader source;
        private InputStream is;

        public ClassFileReaderBackedClassFile(ClassFileReader cfr) {
            this.source = cfr;
        }

        public InputStream getInputStream() throws IOException {
            this.is = new ByteArrayInputStream(this.source.getReferenceBytes());
            return this.is;
        }

        public void close() {
            try {
                if (this.is != null) {
                    this.is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public String getPath() {
            return new String(this.source.getFileName());
        }
    }
}

