/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.util;

import java.util.List;
import org.eclipse.cdt.visualizer.ui.util.ListenerList;
import org.eclipse.cdt.visualizer.ui.util.SelectionProviderAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class WorkbenchSelectionAdapter
implements ISelectionListener,
ISelectionProvider {
    protected IViewPart m_view = null;
    protected ISelection m_selection = null;
    protected ListenerList m_selectionListeners = null;
    protected boolean m_trackSelection = true;

    public WorkbenchSelectionAdapter(IViewPart view) {
        this.m_view = view;
        this.m_selection = null;
        this.m_selectionListeners = new ListenerList(view, "WorkbenchSelectionAdapter for view " + view.getClass().getSimpleName()){

            @Override
            public void raise(Object listener, Object event) {
                if (listener instanceof ISelectionChangedListener && event instanceof SelectionChangedEvent) {
                    ISelectionChangedListener typedListener = (ISelectionChangedListener)listener;
                    SelectionChangedEvent typedEvent = (SelectionChangedEvent)event;
                    typedListener.selectionChanged(typedEvent);
                }
            }
        };
        this.m_view.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.m_view.getSite().setSelectionProvider((ISelectionProvider)this);
        this.setSelection(this.m_view.getSite().getPage().getSelection());
    }

    public void dispose() {
        if (this.m_view != null) {
            this.m_view.getSite().getPage().removeSelectionListener((ISelectionListener)this);
            this.m_view.getViewSite().setSelectionProvider(null);
            this.m_view = null;
        }
        this.m_selection = null;
        if (this.m_selectionListeners != null) {
            this.m_selectionListeners.clear();
            this.m_selectionListeners = null;
        }
    }

    public boolean getTrackSelection() {
        return this.m_trackSelection;
    }

    public void setTrackSelection(boolean trackSelection) {
        this.m_trackSelection = trackSelection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this.m_view) {
            return;
        }
        if (this.m_trackSelection) {
            this.workbenchSelectionChanged(part, selection);
        }
    }

    public void workbenchSelectionChanged(ISelection selection) {
        this.setSelection(selection);
    }

    public void workbenchSelectionChanged(ISelectionProvider provider, ISelection selection) {
        this.setSelection(provider, selection);
    }

    public void workbenchSelectionChanged(Object provider, ISelection selection) {
        this.setSelection(provider, selection);
    }

    public ISelection getSelection() {
        return this.m_selection;
    }

    public void setSelection(ISelection selection) {
        if (selection == null) {
            selection = StructuredSelection.EMPTY;
        }
        this.m_selection = selection;
        this.m_selectionListeners.raise(new SelectionChangedEvent((ISelectionProvider)this, this.m_selection));
    }

    public void setSelection(ISelectionProvider source, ISelection selection) {
        if (selection == null) {
            selection = StructuredSelection.EMPTY;
        }
        this.m_selection = selection;
        this.m_selectionListeners.raise(new SelectionChangedEvent(source, this.m_selection));
    }

    public void setSelection(Object source, ISelection selection) {
        if (selection == null) {
            selection = StructuredSelection.EMPTY;
        }
        this.m_selection = selection;
        this.m_selectionListeners.raise(new SelectionChangedEvent((ISelectionProvider)new SelectionProviderAdapter(source), this.m_selection));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionListeners.addListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionListeners.removeListener(listener);
    }

    protected String selectionToString(ISelection selection) {
        Object result = null;
        if (this.m_selection == null) {
            result = "No Selection";
        } else if (this.m_selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.m_selection;
            List elements = structuredSelection.toList();
            int size = elements.size();
            if (size == 0) {
                result = "Empty Selection";
            } else {
                result = "";
                int i = 0;
                while (i < size) {
                    if (i > 0) {
                        result = (String)result + "\n";
                    }
                    Object o = elements.get(i);
                    String type = o.getClass().getName();
                    String value = o.toString();
                    result = (String)result + "[" + i + "]: type= + " + type + ", value='" + value + "'";
                    ++i;
                }
            }
        } else {
            String type = this.m_selection.getClass().getName();
            String value = this.m_selection.toString();
            result = "type=" + type + ", value='" + value + "'";
        }
        return result;
    }
}

