/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.parts;

import java.util.HashMap;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.examples.flow.parts.ActivityDiagramPart;
import org.eclipse.gef.examples.flow.parts.GraphAnimation;

class GraphLayoutManager
extends AbstractLayout {
    private final ActivityDiagramPart diagram;

    GraphLayoutManager(ActivityDiagramPart diagram) {
        this.diagram = diagram;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        container.validate();
        Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
        container.getChildren().forEach(child -> {
            Rectangle rectangle2 = result.union(child.getBounds());
        });
        result.resize(container.getInsets().getWidth(), container.getInsets().getHeight());
        return result.getSize();
    }

    public void layout(IFigure container) {
        GraphAnimation.recordInitialState(container);
        if (GraphAnimation.playbackState(container)) {
            return;
        }
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        HashMap<AbstractGraphicalEditPart, Object> partsToNodes = new HashMap<AbstractGraphicalEditPart, Object>();
        this.diagram.contributeNodesToGraph(graph, null, partsToNodes);
        this.diagram.contributeEdgesToGraph(graph, partsToNodes);
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        this.diagram.applyGraphResults(graph, partsToNodes);
    }
}

