/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.scrollpane;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GroupBoxBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.draw2d.examples.ExampleUtil;
import org.eclipse.draw2d.examples.scrollpane.InternalFrame;
import org.eclipse.draw2d.geometry.Rectangle;

public class ScrollPaneExample
extends AbstractExample {
    int count = 1;

    public static void main(String[] args) {
        new ScrollPaneExample().run();
    }

    @Override
    protected IFigure createContents() {
        Figure mainPanel = new Figure();
        mainPanel.add((IFigure)this.newScrollingFrame("Flow layouts", ExampleUtil.createToolbarLayout()));
        Figure fixedSize = new Figure();
        fixedSize.setBorder((Border)new LineBorder());
        fixedSize.setPreferredSize(100, 100);
        mainPanel.add((IFigure)this.newScrollingFrame("fixed 100x100", (IFigure)fixedSize));
        return mainPanel;
    }

    private InternalFrame newScrollingFrame(String title, IFigure contents) {
        InternalFrame frame = new InternalFrame();
        frame.setLabel(title);
        ScrollPane scrollpane = new ScrollPane();
        scrollpane.setBorder((Border)new GroupBoxBorder("scrollpane"));
        scrollpane.getViewport().setContentsTracksWidth(true);
        scrollpane.setContents(contents);
        frame.add((IFigure)scrollpane);
        frame.setBounds(new Rectangle(this.count * 20, this.count * 20, 200, 140));
        return frame;
    }
}

