/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples.logo.ui.properties;

import javafx.collections.ObservableList;
import org.eclipse.gef.mvc.examples.logo.ui.view.MvcLogoExampleView;
import org.eclipse.gef.mvc.fx.handlers.ISnapToStrategy;
import org.eclipse.gef.mvc.fx.handlers.SnapToGeometry;
import org.eclipse.gef.mvc.fx.handlers.SnapToGrid;
import org.eclipse.gef.mvc.fx.models.GridModel;
import org.eclipse.gef.mvc.fx.models.SnappingModel;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class MvcLogoExampleViewPropertySource
implements IPropertySource {
    private static final SnapToGrid SNAP_TO_GRID_STRATEGY = new SnapToGrid();
    private static final SnapToGeometry SNAP_TO_GEOMETRY_STRATEGY = new SnapToGeometry();
    private static final String SNAP_TO_GRID_ID = "SNAP_TO_GRID";
    private static final String SNAP_TO_GEOMETRY_ID = "SNAP_TO_GEOMETRY";
    private static final IPropertyDescriptor SNAP_TO_GEOMETRY_PROPERTY_DESCRIPTOR = new ComboBoxPropertyDescriptor((Object)"SNAP_TO_GEOMETRY", "Snap To Geometry", new String[]{Boolean.FALSE.toString(), Boolean.TRUE.toString()});
    private static final IPropertyDescriptor SNAP_TO_GRID_PROPERTY_DESCRIPTOR = new ComboBoxPropertyDescriptor((Object)"SNAP_TO_GRID", "Snap To Grid", new String[]{Boolean.FALSE.toString(), Boolean.TRUE.toString()});
    private static final IPropertyDescriptor GRID_CELL_WIDTH_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor((Object)"gridCellWidth", "Grid Cell Width");
    private static final IPropertyDescriptor GRID_CELL_HEIGHT_PROPERTY_DESCRIPTOR = new TextPropertyDescriptor((Object)"gridCellHeight", "Grid Cell Height");
    private MvcLogoExampleView view;

    public MvcLogoExampleViewPropertySource(MvcLogoExampleView view) {
        this.view = view;
    }

    private GridModel getGridModel() {
        return (GridModel)this.view.getContentViewer().getAdapter(GridModel.class);
    }

    private SnapToGrid getSnapToGrid() {
        ObservableList<ISnapToStrategy> supportedSnapToStrategies = this.getSupportedSnapToStrategies();
        SnapToGrid snapToGrid = null;
        for (ISnapToStrategy s : supportedSnapToStrategies) {
            if (!(s instanceof SnapToGrid)) continue;
            snapToGrid = (SnapToGrid)s;
            break;
        }
        return snapToGrid;
    }

    private ObservableList<ISnapToStrategy> getSupportedSnapToStrategies() {
        return ((SnappingModel)this.view.getContentViewer().getAdapter(SnappingModel.class)).snapToStrategiesProperty();
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{SNAP_TO_GEOMETRY_PROPERTY_DESCRIPTOR, SNAP_TO_GRID_PROPERTY_DESCRIPTOR, GRID_CELL_WIDTH_PROPERTY_DESCRIPTOR, GRID_CELL_HEIGHT_PROPERTY_DESCRIPTOR};
    }

    public Object getPropertyValue(Object id) {
        if (SNAP_TO_GEOMETRY_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            return this.getSnapToGeometry() != null ? 1 : 0;
        }
        if (SNAP_TO_GRID_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            return this.getSnapToGrid() != null ? 1 : 0;
        }
        if (GRID_CELL_WIDTH_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            return Double.toString(this.getGridModel().gridCellWidthProperty().get());
        }
        if (GRID_CELL_HEIGHT_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            return Double.toString(this.getGridModel().gridCellHeightProperty().get());
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (SNAP_TO_GEOMETRY_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            return this.getSnapToGeometry() != null;
        }
        if (SNAP_TO_GRID_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            return this.getSnapToGrid() != null;
        }
        if (GRID_CELL_WIDTH_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            return this.getGridModel().gridCellWidthProperty().get() == 10.0;
        }
        if (GRID_CELL_HEIGHT_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            return this.getGridModel().gridCellHeightProperty().get() == 10.0;
        }
        return false;
    }

    private SnapToGeometry getSnapToGeometry() {
        ObservableList<ISnapToStrategy> supportedSnapToStrategies = this.getSupportedSnapToStrategies();
        SnapToGeometry snapToGeometry = null;
        for (ISnapToStrategy s : supportedSnapToStrategies) {
            if (!(s instanceof SnapToGeometry)) continue;
            snapToGeometry = (SnapToGeometry)s;
            break;
        }
        return snapToGeometry;
    }

    public void resetPropertyValue(Object id) {
        if (SNAP_TO_GEOMETRY_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            this.removeSnapToGeometry();
        } else if (SNAP_TO_GRID_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            this.removeSnapToGrid();
        } else if (GRID_CELL_WIDTH_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            this.getGridModel().gridCellWidthProperty().set(10.0);
        } else if (GRID_CELL_HEIGHT_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            this.getGridModel().gridCellHeightProperty().set(10.0);
        }
    }

    private void addSnapToGrid() {
        if (this.getSnapToGrid() == null) {
            this.getSupportedSnapToStrategies().add((Object)SNAP_TO_GRID_STRATEGY);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (SNAP_TO_GEOMETRY_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            if (value instanceof Integer && (Integer)value == 1) {
                this.addSnapToGeometry();
            } else {
                this.removeSnapToGeometry();
            }
        } else if (SNAP_TO_GRID_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            if (value instanceof Integer && (Integer)value == 1) {
                this.addSnapToGrid();
            } else {
                this.removeSnapToGrid();
            }
        } else if (GRID_CELL_WIDTH_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            this.getGridModel().gridCellWidthProperty().set(Double.parseDouble((String)value));
        } else if (GRID_CELL_HEIGHT_PROPERTY_DESCRIPTOR.getId().equals(id)) {
            this.getGridModel().gridCellHeightProperty().set(Double.parseDouble((String)value));
        }
    }

    private void removeSnapToGeometry() {
        this.getSupportedSnapToStrategies().remove((Object)this.getSnapToGeometry());
    }

    private void addSnapToGeometry() {
        if (this.getSnapToGeometry() == null) {
            this.getSupportedSnapToStrategies().add((Object)SNAP_TO_GEOMETRY_STRATEGY);
        }
    }

    private void removeSnapToGrid() {
        this.getSupportedSnapToStrategies().remove((Object)this.getSnapToGrid());
    }
}

