/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.contentassist;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.htmllabel.DotHtmlLabelHelper;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlLabel;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmllabelFactory;
import org.eclipse.gef.dot.internal.ui.language.contentassist.AbstractDotHtmlLabelProposalProvider;
import org.eclipse.gef.dot.internal.ui.language.contentassist.DotProposalProviderDelegator;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class DotHtmlLabelProposalProvider
extends AbstractDotHtmlLabelProposalProvider {
    @Inject
    private IImageHelper imageHelper;

    @Override
    public void complete_HtmlTag(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String parentName = null;
        EList siblings = new ArrayList();
        if (model instanceof HtmlTag) {
            HtmlTag tag = (HtmlTag)model;
            parentName = tag.getName();
            siblings = tag.getChildren();
        } else {
            parentName = DotHtmlLabelHelper.getRootTagKey();
            if (model instanceof HtmlLabel) {
                siblings = ((HtmlLabel)model).getParts();
            }
            if (model instanceof HtmlContent) {
                siblings.add((HtmlContent)model);
            }
        }
        Image image = this.imageHelper.getImage("html_tag.png");
        for (String tagName : (Set)DotHtmlLabelHelper.getValidTags().get(parentName)) {
            if (!this.isValidSibling(tagName, (List<HtmlContent>)siblings)) continue;
            String proposal = this.calculateProposalString(tagName);
            String format = "%s: Tag";
            StyledString displayString = DotEditorUtils.style(format, proposal);
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, displayString, image, context);
            if (!(completionProposal instanceof ConfigurableCompletionProposal)) continue;
            ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
            int cursorPosition = this.calculateCursorPosition(proposal);
            String tagDescription = DotHtmlLabelHelper.getTagDescription((String)tagName);
            configurableCompletionProposal.setCursorPosition(cursorPosition);
            configurableCompletionProposal.setAdditionalProposalInfo((Object)tagDescription);
            acceptor.accept((ICompletionProposal)configurableCompletionProposal);
        }
    }

    @Override
    public void completeHtmlAttr_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeHtmlAttr_Name(model, assignment, context, acceptor);
        if (model instanceof HtmlTag) {
            HtmlTag htmlTag = (HtmlTag)model;
            String htmlTagName = htmlTag.getName();
            Map validAttributes = DotHtmlLabelHelper.getValidAttributes();
            if (validAttributes.containsKey(htmlTagName)) {
                Image image = this.imageHelper.getImage("attribute.png");
                Set validAttributeNames = (Set)validAttributes.get(htmlTagName);
                Iterator iterator = validAttributeNames.iterator();
                while (iterator.hasNext()) {
                    String validAttributeName;
                    String proposal = validAttributeName = (String)iterator.next();
                    String format = "%s: Attribute";
                    StyledString displayString = DotEditorUtils.style(format, proposal);
                    ICompletionProposal completionProposal = this.createCompletionProposal(proposal, displayString, image, context);
                    if (!(completionProposal instanceof ConfigurableCompletionProposal)) continue;
                    ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
                    String replacementString = String.valueOf(validAttributeName) + "=\"\"";
                    configurableCompletionProposal.setReplacementString(replacementString);
                    configurableCompletionProposal.setCursorPosition(replacementString.length() - 1);
                    acceptor.accept((ICompletionProposal)configurableCompletionProposal);
                }
            }
        }
    }

    @Override
    public void completeHtmlAttr_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block10: {
            super.completeHtmlAttr_Value(model, assignment, context, acceptor);
            if (!(model instanceof HtmlAttr)) break block10;
            HtmlAttr htmlAttr = (HtmlAttr)model;
            HtmlTag htmlTag = (HtmlTag)htmlAttr.eContainer();
            switch (htmlAttr.getName().toLowerCase(Locale.ENGLISH)) {
                case "bgcolor": {
                    this.proposeHtmlBgColorAttributeValues(context, acceptor);
                    break;
                }
                case "color": {
                    this.proposeHtmlColorAttributeValues(context, acceptor);
                    break;
                }
                default: {
                    this.proposeHtmlAttributeValues(htmlTag.getName(), htmlAttr.getName(), context, acceptor);
                }
            }
        }
    }

    protected boolean isValidProposal(String proposal, String prefix, ContentAssistContext context) {
        if (prefix == null) {
            return false;
        }
        if (context.getCurrentModel() instanceof HtmlAttr && (prefix.startsWith("\"") || prefix.startsWith("'"))) {
            prefix = prefix.substring(1);
            return context.getMatcher().isCandidateMatchingPrefix(proposal, prefix);
        }
        return super.isValidProposal(proposal, prefix, context);
    }

    private boolean isValidSibling(String tagName, List<HtmlContent> siblings) {
        HtmlContent newSibling = HtmllabelFactory.eINSTANCE.createHtmlContent();
        HtmlTag htmlTag = HtmllabelFactory.eINSTANCE.createHtmlTag();
        htmlTag.setName(tagName);
        newSibling.setTag(htmlTag);
        ArrayList<HtmlContent> extendedSiblings = new ArrayList<HtmlContent>(siblings);
        extendedSiblings.add(newSibling);
        return DotHtmlLabelHelper.isValidSiblings(extendedSiblings);
    }

    private void proposeHtmlAttributeValues(String htmlTagName, String htmlAttributeName, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block60: {
            block58: {
                block56: {
                    block54: {
                        if (!"BR".equalsIgnoreCase(htmlTagName)) break block54;
                        switch (htmlAttributeName.toUpperCase()) {
                            case "ALIGN": {
                                this.proposeHtmlAttributeValues(context, acceptor, "CENTER", "LEFT", "RIGHT");
                                break;
                            }
                        }
                    }
                    if (!"IMG".equalsIgnoreCase(htmlTagName)) break block56;
                    switch (htmlAttributeName.toUpperCase()) {
                        case "SCALE": {
                            this.proposeHtmlAttributeValues(context, acceptor, "FALSE", "TRUE", "WIDTH", "HEIGHT", "BOTH");
                            break;
                        }
                    }
                }
                if (!"TABLE".equalsIgnoreCase(htmlTagName)) break block58;
                switch (htmlAttributeName.toUpperCase()) {
                    case "ALIGN": {
                        this.proposeHtmlAttributeValues(context, acceptor, "CENTER", "LEFT", "RIGHT");
                        break;
                    }
                    case "FIXEDSIZE": {
                        this.proposeHtmlAttributeValues(context, acceptor, "FALSE", "TRUE");
                        break;
                    }
                    case "ROWS": 
                    case "COLUMNS": {
                        this.proposeHtmlAttributeValues(context, acceptor, "*");
                        break;
                    }
                    case "SIDES": {
                        this.proposeHtmlAttributeValues(context, acceptor, "L", "T", "R", "B", "LT", "LR", "LB", "TR", "TB", "RB", "LTR", "TRB", "LRB", "LTB", "LTRB");
                        break;
                    }
                    case "VALIGN": {
                        this.proposeHtmlAttributeValues(context, acceptor, "MIDDLE", "BOTTOM", "TOP");
                        break;
                    }
                }
            }
            if (!"TD".equalsIgnoreCase(htmlTagName)) break block60;
            switch (htmlAttributeName.toUpperCase()) {
                case "ALIGN": {
                    this.proposeHtmlAttributeValues(context, acceptor, "CENTER", "LEFT", "RIGHT", "TEXT");
                    break;
                }
                case "BALIGN": {
                    this.proposeHtmlAttributeValues(context, acceptor, "CENTER", "LEFT", "RIGHT");
                    break;
                }
                case "FIXEDSIZE": {
                    this.proposeHtmlAttributeValues(context, acceptor, "FALSE", "TRUE");
                    break;
                }
                case "SIDES": {
                    this.proposeHtmlAttributeValues(context, acceptor, "L", "T", "R", "B", "LT", "LR", "LB", "TR", "TB", "RB", "LTR", "TRB", "LRB", "LTB", "LTRB");
                    break;
                }
                case "VALIGN": {
                    this.proposeHtmlAttributeValues(context, acceptor, "MIDDLE", "BOTTOM", "TOP");
                    break;
                }
            }
        }
    }

    private void proposeHtmlBgColorAttributeValues(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String fullText;
        INode currentNode = context.getCurrentNode();
        String text = fullText = currentNode.getText();
        int beginReplacementOffset = currentNode.getOffset();
        if (context.getPrefix().contains(":")) {
            int colonOffset = fullText.indexOf(58) + 1;
            text = fullText.substring(colonOffset);
            beginReplacementOffset += colonOffset;
        } else {
            beginReplacementOffset += this.beginsWithQuote(text) ? 1 : 0;
        }
        this.proposeHtmlColorAttributeValues(context, acceptor, text.replaceAll("['\"]", ""), beginReplacementOffset, context.getOffset());
        if (!fullText.contains(":")) {
            acceptor.accept((ICompletionProposal)new ConfigurableCompletionProposal(":", context.getOffset(), 0, 1));
        }
    }

    private void proposeHtmlColorAttributeValues(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        INode currentNode = context.getCurrentNode();
        String text = currentNode.getText();
        this.proposeHtmlColorAttributeValues(context, acceptor, text.replaceAll("['\"]", ""), currentNode.getOffset() + (this.beginsWithQuote(text) ? 1 : 0), context.getOffset());
    }

    private void proposeHtmlColorAttributeValues(ContentAssistContext context, ICompletionProposalAcceptor acceptor, String text, int beginReplacementOffset, int contextOffset) {
        String subgrammarName = "org.eclipse.gef.dot.internal.language.DotColor";
        List<ConfigurableCompletionProposal> configurableCompletionProposals = new DotProposalProviderDelegator(subgrammarName).computeConfigurableCompletionProposals(text, contextOffset - beginReplacementOffset);
        for (ConfigurableCompletionProposal configurableCompletionProposal : configurableCompletionProposals) {
            configurableCompletionProposal.setReplacementOffset(beginReplacementOffset + configurableCompletionProposal.getReplacementOffset());
            acceptor.accept((ICompletionProposal)configurableCompletionProposal);
        }
    }

    private boolean beginsWithQuote(String baseText) {
        if (baseText.length() == 0) {
            return false;
        }
        char first = baseText.charAt(0);
        return first == '\'' || first == '\"';
    }

    private void proposeHtmlAttributeValues(ContentAssistContext context, ICompletionProposalAcceptor acceptor, String ... proposals) {
        String[] stringArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            String proposal = stringArray[n2];
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            String text = context.getCurrentNode().getText();
            if ((text.startsWith("\"") || text.startsWith("'")) && completionProposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
                configurableCompletionProposal.setReplacementOffset(configurableCompletionProposal.getReplacementOffset() + 1);
                configurableCompletionProposal.setReplacementLength(configurableCompletionProposal.getReplacementLength() - 1);
                configurableCompletionProposal.setReplaceContextLength(configurableCompletionProposal.getReplaceContextLength() - 1);
            }
            acceptor.accept(completionProposal);
            ++n2;
        }
    }

    private String calculateProposalString(String tagName) {
        StringBuilder sb = new StringBuilder();
        if (DotHtmlLabelHelper.getNonSelfClosingTags().contains(tagName.toUpperCase())) {
            sb.append("<");
            sb.append(tagName);
            sb.append(">");
            sb.append("</");
            sb.append(tagName);
            sb.append(">");
        } else {
            sb.append("<");
            sb.append(tagName);
            sb.append("/>");
        }
        return sb.toString();
    }

    private int calculateCursorPosition(String htmlTagText) {
        if (htmlTagText.contains("/>")) {
            return htmlTagText.indexOf("/>");
        }
        return htmlTagText.indexOf("><") + 1;
    }
}

