/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.actions;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Parent;
import javafx.scene.transform.Affine;
import javafx.scene.transform.TransformChangedEvent;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.domain.HistoricizingDomain;
import org.eclipse.gef.mvc.fx.ui.MvcFxUiBundle;
import org.eclipse.gef.mvc.fx.ui.actions.FitToViewportAction;
import org.eclipse.swt.widgets.Event;

public class FitToViewportLockAction
extends FitToViewportAction {
    private boolean boundsChanged = false;
    private boolean sizeChanged = false;
    private boolean offsetChanged = false;
    private double savedContentBoundsWidth = 0.0;
    private double savedContentBoundsHeight = 0.0;
    private ReadOnlyObjectProperty<Bounds> contentBoundsProperty;
    private Affine contentTransform;
    private InfiniteCanvas infiniteCanvas;
    private boolean running;
    private EventHandler<TransformChangedEvent> trafoChangeListener = new EventHandler<TransformChangedEvent>(){

        public void handle(TransformChangedEvent event) {
            FitToViewportLockAction.this.setChecked(false);
        }
    };
    private ChangeListener<? super Bounds> contentBoundsChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            FitToViewportLockAction.this.boundsChanged = true;
        }
    };
    private ChangeListener<? super Number> scrollOffsetChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            FitToViewportLockAction.this.offsetChanged = true;
        }
    };
    private ChangeListener<? super Number> sizeChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            FitToViewportLockAction.this.sizeChanged = true;
            FitToViewportLockAction.this.onSizeChanged();
        }
    };
    private IOperationHistoryListener historyListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            if (event.getEventType() == 5) {
                Bounds contentBounds = FitToViewportLockAction.this.infiniteCanvas.getContentBounds();
                if (FitToViewportLockAction.this.offsetChanged && (!FitToViewportLockAction.this.boundsChanged || contentBounds.getWidth() == FitToViewportLockAction.this.savedContentBoundsWidth && contentBounds.getHeight() == FitToViewportLockAction.this.savedContentBoundsHeight)) {
                    FitToViewportLockAction.this.setChecked(false);
                } else if (FitToViewportLockAction.this.boundsChanged && !FitToViewportLockAction.this.sizeChanged) {
                    FitToViewportLockAction.this.onSizeChanged();
                }
                FitToViewportLockAction.this.boundsChanged = false;
                FitToViewportLockAction.this.sizeChanged = false;
                FitToViewportLockAction.this.offsetChanged = false;
            }
        }
    };

    public FitToViewportLockAction() {
        super("Fit-To-Viewport Lock", 2, MvcFxUiBundle.getDefault().getImageRegistry().getDescriptor("IMG_ICONS_FIT_TO_VIEWPORT_LOCK"));
    }

    protected void disableViewportListeners() {
        this.infiniteCanvas.horizontalScrollOffsetProperty().removeListener(this.scrollOffsetChangeListener);
        this.infiniteCanvas.verticalScrollOffsetProperty().removeListener(this.scrollOffsetChangeListener);
        this.contentTransform.removeEventHandler(TransformChangedEvent.TRANSFORM_CHANGED, this.trafoChangeListener);
        this.contentBoundsProperty.removeListener(this.contentBoundsChangeListener);
    }

    protected void enableViewportListeners() {
        this.infiniteCanvas.horizontalScrollOffsetProperty().addListener(this.scrollOffsetChangeListener);
        this.infiniteCanvas.verticalScrollOffsetProperty().addListener(this.scrollOffsetChangeListener);
        this.contentTransform.addEventHandler(TransformChangedEvent.TRANSFORM_CHANGED, this.trafoChangeListener);
        this.contentBoundsProperty.addListener(this.contentBoundsChangeListener);
        this.savedContentBoundsWidth = this.infiniteCanvas.getContentBounds().getWidth();
        this.savedContentBoundsHeight = this.infiniteCanvas.getContentBounds().getHeight();
    }

    protected void lock() {
        ((HistoricizingDomain)this.getViewer().getDomain()).getOperationHistory().addOperationHistoryListener(this.historyListener);
        Parent canvas = this.getViewer().getCanvas();
        if (canvas instanceof InfiniteCanvas) {
            this.infiniteCanvas = (InfiniteCanvas)canvas;
            this.contentTransform = this.infiniteCanvas.getContentTransform();
            this.contentBoundsProperty = this.infiniteCanvas.contentBoundsProperty();
            this.enableViewportListeners();
            this.infiniteCanvas.widthProperty().addListener(this.sizeChangeListener);
            this.infiniteCanvas.heightProperty().addListener(this.sizeChangeListener);
        }
    }

    protected void onSizeChanged() {
        if (this.isEnabled()) {
            this.runWithEvent(null);
        }
    }

    @Override
    protected void register() {
        super.register();
        if (this.isChecked()) {
            this.lock();
            this.runWithEvent(null);
        }
    }

    @Override
    public void runWithEvent(Event event) {
        if (this.running) {
            return;
        }
        this.running = true;
        if (this.isChecked()) {
            this.disableViewportListeners();
            super.runWithEvent(event);
            this.enableViewportListeners();
        }
        this.running = false;
    }

    public void setChecked(boolean checked) {
        if (this.isEnabled()) {
            if (this.isChecked() && !checked) {
                this.unlock();
            } else if (!this.isChecked() && checked) {
                this.lock();
            }
        }
        super.setChecked(checked);
    }

    protected void unlock() {
        ((HistoricizingDomain)this.getViewer().getDomain()).getOperationHistory().removeOperationHistoryListener(this.historyListener);
        if (this.infiniteCanvas != null) {
            this.disableViewportListeners();
            this.infiniteCanvas.widthProperty().removeListener(this.sizeChangeListener);
            this.infiniteCanvas.heightProperty().removeListener(this.sizeChangeListener);
        }
        this.boundsChanged = false;
        this.sizeChanged = false;
        this.offsetChanged = false;
    }

    @Override
    protected void unregister() {
        this.unlock();
        super.unregister();
    }
}

