/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Scene;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.swt.canvas.IFXCanvasFactory;
import org.eclipse.gef.mvc.fx.domain.HistoricizingDomain;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.ui.actions.DeleteAction;
import org.eclipse.gef.mvc.fx.ui.actions.SelectAllAction;
import org.eclipse.gef.mvc.fx.ui.parts.ISelectionProviderFactory;
import org.eclipse.gef.mvc.fx.ui.properties.IPropertySheetPageFactory;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class AbstractFXView
extends ViewPart {
    @Inject
    private IDomain domain;
    @Inject
    private IFXCanvasFactory canvasFactory;
    private FXCanvas canvas = null;
    @Inject(optional=true)
    private ISelectionProviderFactory selectionProviderFactory;
    private ISelectionProvider selectionProvider;
    @Inject(optional=true)
    private IPropertySheetPageFactory propertySheetPageFactory;
    private IPropertySheetPage propertySheetPage;
    private UndoRedoActionGroup undoRedoActionGroup;
    private DeleteAction deleteAction;
    private SelectAllAction selectAllAction;

    public AbstractFXView(Injector injector) {
        injector.injectMembers((Object)this);
    }

    protected void activate() {
        this.domain.activate();
    }

    protected void createActions() {
        IViewSite site = this.getViewSite();
        this.undoRedoActionGroup = new UndoRedoActionGroup(this.getSite(), (IUndoContext)this.getAdapter(IUndoContext.class), true);
        this.undoRedoActionGroup.fillActionBars(site.getActionBars());
        this.deleteAction = new DeleteAction();
        this.getContentViewer().setAdapter((Object)this.deleteAction);
        site.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.selectAllAction = new SelectAllAction();
        this.getContentViewer().setAdapter((Object)this.selectAllAction);
        site.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
    }

    private FXCanvas createCanvas(Composite parent) {
        return this.canvasFactory.createCanvas(parent, 0);
    }

    public void createPartControl(Composite parent) {
        this.canvas = this.createCanvas(parent);
        this.hookViewers();
        if (this.selectionProviderFactory != null) {
            this.selectionProvider = this.selectionProviderFactory.create((IWorkbenchPart)this);
            this.getSite().setSelectionProvider(this.selectionProvider);
        }
        this.activate();
    }

    private IPropertySheetPage createPropertySheetPage() {
        if (this.propertySheetPageFactory != null) {
            return this.propertySheetPageFactory.create((IWorkbenchPart)this);
        }
        return null;
    }

    protected void deactivate() {
        this.domain.deactivate();
    }

    public void dispose() {
        this.deactivate();
        this.unhookViewers();
        this.selectionProviderFactory = null;
        if (this.selectionProvider != null) {
            this.getSite().setSelectionProvider(null);
            if (this.selectionProvider instanceof IDisposable) {
                ((IDisposable)this.selectionProvider).dispose();
            }
            this.selectionProvider = null;
        }
        this.propertySheetPage = null;
        this.propertySheetPageFactory = null;
        this.disposeActions();
        this.domain.dispose();
        this.domain = null;
        this.canvasFactory = null;
        if (!this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
        this.canvas = null;
        super.dispose();
    }

    protected void disposeActions() {
        if (this.undoRedoActionGroup != null) {
            this.undoRedoActionGroup.dispose();
            this.undoRedoActionGroup = null;
        }
        if (this.deleteAction != null) {
            this.getContentViewer().unsetAdapter((Object)this.deleteAction);
            this.deleteAction = null;
        }
        if (this.selectAllAction != null) {
            this.getContentViewer().unsetAdapter((Object)this.selectAllAction);
            this.selectAllAction = null;
        }
    }

    public Object getAdapter(Class key) {
        if (ISelectionProvider.class.equals((Object)key) && this.selectionProvider != null) {
            return this.selectionProvider;
        }
        if (IPropertySheetPage.class.equals((Object)key)) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = this.createPropertySheetPage();
            }
            if (this.propertySheetPage != null) {
                return this.propertySheetPage;
            }
        }
        if (IUndoContext.class.equals((Object)key) && this.domain instanceof HistoricizingDomain) {
            return ((HistoricizingDomain)this.domain).getUndoContext();
        }
        if (IOperationHistory.class.equals((Object)key) && this.domain instanceof HistoricizingDomain) {
            return ((HistoricizingDomain)this.domain).getOperationHistory();
        }
        return super.getAdapter(key);
    }

    protected FXCanvas getCanvas() {
        return this.canvas;
    }

    public IViewer getContentViewer() {
        return (IViewer)this.domain.getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
    }

    public IDomain getDomain() {
        return this.domain;
    }

    protected void hookViewers() {
        this.canvas.setScene(new Scene(this.getContentViewer().getCanvas()));
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.createActions();
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    protected void unhookViewers() {
    }
}

