/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.layout.algorithms;

import java.util.HashMap;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.LayoutContext;
import org.eclipse.gef.layout.LayoutProperties;
import org.eclipse.gef.layout.algorithms.AlgorithmHelper;

public class SpringLayoutAlgorithm
implements ILayoutAlgorithm {
    private static final int DEFAULT_SPRING_ITERATIONS = 1000;
    private static final long MAX_SPRING_TIME = 10000L;
    private static final boolean DEFAULT_SPRING_RANDOM = true;
    private static final double DEFAULT_SPRING_MOVE = 1.0;
    private static final double DEFAULT_SPRING_STRAIN = 1.0;
    private static final double DEFAULT_SPRING_LENGTH = 3.0;
    private static final double DEFAULT_SPRING_GRAVITATION = 2.0;
    private static final double MIN_DISTANCE = 1.0;
    private int sprIterations = 1000;
    private long maxTimeMS = 10000L;
    private boolean sprRandom = true;
    private double sprMove = 1.0;
    private double sprStrain = 1.0;
    private double sprLength = 3.0;
    private double sprGravitation = 2.0;
    private boolean resize = false;
    private int iteration;
    private double[][] srcDestToSumOfWeights;
    private Node[] entities;
    private double[] forcesX;
    private double[] forcesY;
    private double[] locationsX;
    private double[] locationsY;
    private double[] sizeW;
    private double[] sizeH;
    private Rectangle bounds;
    private double boundsScaleX = 0.2;
    private double boundsScaleY = 0.2;
    private LayoutContext layoutContext;
    private boolean fitWithinBounds = true;
    private long startTime = 0L;

    /*
     * Unable to fully structure code
     */
    @Override
    public void applyLayout(LayoutContext layoutContext, boolean clean) {
        this.layoutContext = layoutContext;
        this.initLayout(layoutContext);
        if (clean) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            this.computeOneIteration();
lbl6:
            // 2 sources

            ** while (this.performAnotherNonContinuousIteration())
        }
lbl7:
        // 1 sources

        this.saveLocations();
        if (this.resize) {
            AlgorithmHelper.maximizeSizes(this.entities);
        }
        if (this.fitWithinBounds) {
            bounds2 = new Rectangle(this.bounds);
            insets = 4;
            bounds2.setX(bounds2.getX() + (double)insets);
            bounds2.setY(bounds2.getY() + (double)insets);
            bounds2.setWidth(bounds2.getWidth() - (double)(2 * insets));
            bounds2.setHeight(bounds2.getHeight() - (double)(2 * insets));
            AlgorithmHelper.fitWithinBounds(this.entities, bounds2, this.resize);
        }
    }

    public void performNIteration(int n) {
        this.layoutContext.preLayout();
        if (this.iteration == 0) {
            this.entities = this.layoutContext.getNodes();
            this.loadLocations();
            this.initLayout(this.layoutContext);
        }
        this.bounds = LayoutProperties.getBounds(this.layoutContext.getGraph());
        int i = 0;
        while (i < n) {
            this.computeOneIteration();
            this.saveLocations();
            ++i;
        }
        this.layoutContext.postLayout();
    }

    public void performOneIteration() {
        this.layoutContext.preLayout();
        if (this.iteration == 0) {
            this.entities = this.layoutContext.getNodes();
            this.loadLocations();
            this.initLayout(this.layoutContext);
        }
        this.bounds = LayoutProperties.getBounds(this.layoutContext.getGraph());
        this.computeOneIteration();
        this.saveLocations();
        this.layoutContext.postLayout();
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
    }

    public void setSpringMove(double move) {
        this.sprMove = move;
    }

    public double getSpringMove() {
        return this.sprMove;
    }

    public void setSpringStrain(double strain) {
        this.sprStrain = strain;
    }

    public double getSpringStrain() {
        return this.sprStrain;
    }

    public void setSpringLength(double length) {
        this.sprLength = length;
    }

    public long getSpringTimeout() {
        return this.maxTimeMS;
    }

    public void setSpringTimeout(long timeout) {
        this.maxTimeMS = timeout;
    }

    public double getSpringLength() {
        return this.sprLength;
    }

    public void setSpringGravitation(double gravitation) {
        this.sprGravitation = gravitation;
    }

    public double getSpringGravitation() {
        return this.sprGravitation;
    }

    public void setIterations(int iterations) {
        this.sprIterations = iterations;
    }

    public int getIterations() {
        return this.sprIterations;
    }

    public void setRandom(boolean random) {
        this.sprRandom = random;
    }

    public boolean getRandom() {
        return this.sprRandom;
    }

    private void initLayout(LayoutContext context) {
        this.entities = context.getNodes();
        this.bounds = LayoutProperties.getBounds(context.getGraph());
        this.loadLocations();
        this.srcDestToSumOfWeights = new double[this.entities.length][this.entities.length];
        HashMap<Node, Integer> entityToPosition = new HashMap<Node, Integer>();
        int i = 0;
        while (i < this.entities.length) {
            entityToPosition.put(this.entities[i], new Integer(i));
            ++i;
        }
        Edge[] connections = context.getEdges();
        int i2 = 0;
        while (i2 < connections.length) {
            Edge connection = connections[i2];
            Integer source = (Integer)entityToPosition.get(connection.getSource());
            Integer target = (Integer)entityToPosition.get(connection.getTarget());
            if (source != null && target != null) {
                double weight = LayoutProperties.getWeight(connection);
                weight = weight <= 0.0 ? 0.1 : weight;
                double[] dArray = this.srcDestToSumOfWeights[source];
                int n = target;
                dArray[n] = dArray[n] + weight;
                double[] dArray2 = this.srcDestToSumOfWeights[target];
                int n2 = source;
                dArray2[n2] = dArray2[n2] + weight;
            }
            ++i2;
        }
        if (this.sprRandom) {
            this.placeRandomly();
        }
        this.iteration = 1;
        this.startTime = System.currentTimeMillis();
    }

    private void loadLocations() {
        if (this.locationsX == null || this.locationsX.length != this.entities.length) {
            int length = this.entities.length;
            this.locationsX = new double[length];
            this.locationsY = new double[length];
            this.sizeW = new double[length];
            this.sizeH = new double[length];
            this.forcesX = new double[length];
            this.forcesY = new double[length];
        }
        int i = 0;
        while (i < this.entities.length) {
            Point location = LayoutProperties.getLocation(this.entities[i]);
            this.locationsX[i] = location.x;
            this.locationsY[i] = location.y;
            Dimension size = LayoutProperties.getSize(this.entities[i]);
            this.sizeW[i] = size.width;
            this.sizeH[i] = size.height;
            ++i;
        }
    }

    private void saveLocations() {
        if (this.entities == null) {
            return;
        }
        int i = 0;
        while (i < this.entities.length) {
            if (Double.isNaN(this.locationsX[i]) || Double.isNaN(this.locationsY[i])) {
                this.locationsX[i] = 0.0;
                this.locationsY[i] = 0.0;
            }
            LayoutProperties.setLocation(this.entities[i], new Point(this.locationsX[i], this.locationsY[i]));
            ++i;
        }
    }

    private void setSprIterationsBasedOnTime() {
        if (this.maxTimeMS <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        double fractionComplete = (double)(currentTime - this.startTime) / (double)this.maxTimeMS;
        int currentIteration = (int)(fractionComplete * (double)this.sprIterations);
        if (currentIteration > this.iteration) {
            this.iteration = currentIteration;
        }
    }

    protected boolean performAnotherNonContinuousIteration() {
        this.setSprIterationsBasedOnTime();
        return this.iteration <= this.sprIterations;
    }

    protected int getCurrentLayoutStep() {
        return this.iteration;
    }

    protected int getTotalNumberOfLayoutSteps() {
        return this.sprIterations;
    }

    protected void computeOneIteration() {
        this.computeForces();
        this.computePositions();
        Rectangle currentBounds = this.getLayoutBounds();
        this.improveBoundScaleX(currentBounds);
        this.improveBoundScaleY(currentBounds);
        this.moveToCenter(currentBounds);
        ++this.iteration;
    }

    protected void placeRandomly() {
        if (this.locationsX.length == 0) {
            return;
        }
        if (this.locationsX.length == 1) {
            this.locationsX[0] = this.bounds.getX() + 0.5 * this.bounds.getWidth();
            this.locationsY[0] = this.bounds.getY() + 0.5 * this.bounds.getHeight();
        } else {
            this.locationsX[0] = this.bounds.getX();
            this.locationsY[0] = this.bounds.getY();
            this.locationsX[1] = this.bounds.getX() + this.bounds.getWidth();
            this.locationsY[1] = this.bounds.getY() + this.bounds.getHeight();
            int i = 2;
            while (i < this.locationsX.length) {
                this.locationsX[i] = this.bounds.getX() + Math.random() * this.bounds.getWidth();
                this.locationsY[i] = this.bounds.getY() + Math.random() * this.bounds.getHeight();
                ++i;
            }
        }
    }

    protected void computeForces() {
        int i;
        double[][] forcesX = new double[2][this.forcesX.length];
        double[][] forcesY = new double[2][this.forcesX.length];
        double[] locationsX = new double[this.forcesX.length];
        double[] locationsY = new double[this.forcesX.length];
        int j = 0;
        while (j < 2) {
            i = 0;
            while (i < this.forcesX.length) {
                forcesX[j][i] = 0.0;
                forcesY[j][i] = 0.0;
                locationsX[i] = this.locationsX[i];
                locationsY[i] = this.locationsY[i];
                ++i;
            }
            ++j;
        }
        int k = 0;
        while (k < 2) {
            i = 0;
            while (i < this.locationsX.length) {
                int j2 = i + 1;
                while (j2 < locationsX.length) {
                    double dx = (locationsX[i] - locationsX[j2]) / this.bounds.getWidth() / this.boundsScaleX;
                    double dy = (locationsY[i] - locationsY[j2]) / this.bounds.getHeight() / this.boundsScaleY;
                    double distance_sq = dx * dx + dy * dy;
                    distance_sq = Math.max(1.0, distance_sq);
                    double distance = Math.sqrt(distance_sq);
                    double sumOfWeights = this.srcDestToSumOfWeights[i][j2];
                    double f = sumOfWeights > 0.0 ? -this.sprStrain * Math.log(distance / this.sprLength) * sumOfWeights : this.sprGravitation / distance_sq;
                    double dfx = f * dx / distance;
                    double dfy = f * dy / distance;
                    double[] dArray = forcesX[k];
                    int n = i;
                    dArray[n] = dArray[n] + dfx;
                    double[] dArray2 = forcesY[k];
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + dfy;
                    double[] dArray3 = forcesX[k];
                    int n3 = j2;
                    dArray3[n3] = dArray3[n3] - dfx;
                    double[] dArray4 = forcesY[k];
                    int n4 = j2++;
                    dArray4[n4] = dArray4[n4] - dfy;
                }
                ++i;
            }
            i = 0;
            while (i < this.entities.length) {
                if (LayoutProperties.isMovable(this.entities[i]).booleanValue()) {
                    double maxMovement;
                    double deltaX = this.sprMove * forcesX[k][i];
                    double deltaY = this.sprMove * forcesY[k][i];
                    double dist = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                    if (dist > (maxMovement = 0.2 * this.sprMove)) {
                        deltaX *= maxMovement / dist;
                        deltaY *= maxMovement / dist;
                    }
                    int n = i;
                    locationsX[n] = locationsX[n] + deltaX * this.bounds.getWidth() * this.boundsScaleX;
                    int n5 = i;
                    locationsY[n5] = locationsY[n5] + deltaY * this.bounds.getHeight() * this.boundsScaleY;
                }
                ++i;
            }
            ++k;
        }
        int i2 = 0;
        while (i2 < this.entities.length) {
            this.forcesX[i2] = forcesX[0][i2] * forcesX[1][i2] < 0.0 ? 0.0 : forcesX[1][i2];
            this.forcesY[i2] = forcesY[0][i2] * forcesY[1][i2] < 0.0 ? 0.0 : forcesY[1][i2];
            ++i2;
        }
    }

    protected void computePositions() {
        int i = 0;
        while (i < this.entities.length) {
            if (LayoutProperties.isMovable(this.entities[i]).booleanValue()) {
                double maxMovement;
                double deltaX = this.sprMove * this.forcesX[i];
                double deltaY = this.sprMove * this.forcesY[i];
                double dist = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                if (dist > (maxMovement = 0.2 * this.sprMove)) {
                    deltaX *= maxMovement / dist;
                    deltaY *= maxMovement / dist;
                }
                int n = i;
                this.locationsX[n] = this.locationsX[n] + deltaX * this.bounds.getWidth() * this.boundsScaleX;
                int n2 = i;
                this.locationsY[n2] = this.locationsY[n2] + deltaY * this.bounds.getHeight() * this.boundsScaleY;
            }
            ++i;
        }
    }

    private Rectangle getLayoutBounds() {
        double minY = Double.POSITIVE_INFINITY;
        double minX = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.locationsX.length) {
            maxX = Math.max(maxX, this.locationsX[i] + this.sizeW[i] / 2.0);
            minX = Math.min(minX, this.locationsX[i] - this.sizeW[i] / 2.0);
            maxY = Math.max(maxY, this.locationsY[i] + this.sizeH[i] / 2.0);
            minY = Math.min(minY, this.locationsY[i] - this.sizeH[i] / 2.0);
            ++i;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    private void improveBoundScaleX(Rectangle currentBounds) {
        double boundaryProportionX = currentBounds.getWidth() / this.bounds.getWidth();
        if (boundaryProportionX < 0.9) {
            this.boundsScaleX *= 1.01;
        } else if (boundaryProportionX > 1.0) {
            if (this.boundsScaleX < 0.01) {
                return;
            }
            this.boundsScaleX /= 1.01;
        }
    }

    private void improveBoundScaleY(Rectangle currentBounds) {
        double boundaryProportionY = currentBounds.getHeight() / this.bounds.getHeight();
        if (boundaryProportionY < 0.9) {
            this.boundsScaleY *= 1.01;
        } else if (boundaryProportionY > 1.0) {
            if (this.boundsScaleY < 0.01) {
                return;
            }
            this.boundsScaleY /= 1.01;
        }
    }

    private void moveToCenter(Rectangle currentBounds) {
        double moveX = currentBounds.getX() + currentBounds.getWidth() / 2.0 - (this.bounds.getX() + this.bounds.getWidth() / 2.0);
        double moveY = currentBounds.getY() + currentBounds.getHeight() / 2.0 - (this.bounds.getY() + this.bounds.getHeight() / 2.0);
        int i = 0;
        while (i < this.locationsX.length) {
            int n = i;
            this.locationsX[n] = this.locationsX[n] - moveX;
            int n2 = i++;
            this.locationsY[n2] = this.locationsY[n2] - moveY;
        }
    }
}

