/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples;

import com.google.inject.Guice;
import com.google.inject.Module;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public abstract class AbstractMvcExample
extends Application {
    protected final String title;
    private Stage primaryStage;
    private IDomain domain;

    public AbstractMvcExample(String title) {
        this.title = title;
    }

    protected abstract Module createModule();

    protected IViewer getContentViewer() {
        return (IViewer)this.domain.getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
    }

    protected IDomain getDomain() {
        return this.domain;
    }

    protected Stage getPrimaryStage() {
        return this.primaryStage;
    }

    protected void hookViewers() {
        this.primaryStage.setScene(new Scene(this.getContentViewer().getCanvas()));
    }

    protected abstract void populateViewerContents();

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.domain = (IDomain)Guice.createInjector((Module[])new Module[]{this.createModule()}).getInstance(IDomain.class);
        this.hookViewers();
        primaryStage.setResizable(true);
        primaryStage.setWidth(640.0);
        primaryStage.setHeight(480.0);
        primaryStage.setTitle(this.title);
        primaryStage.sizeToScene();
        primaryStage.show();
        this.domain.activate();
        this.populateViewerContents();
    }
}

