/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.model;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;

public class PHPThreadEventHandler
extends DebugEventHandler {
    private final Set<IThread> fThreadQueue = new LinkedHashSet<IThread>();
    private final Map<IThread, IStackFrame> fLastTopFrame = new HashMap<IThread, IStackFrame>();

    public PHPThreadEventHandler(AbstractModelProxy proxy) {
        super(proxy);
    }

    public synchronized void dispose() {
        this.fLastTopFrame.clear();
        this.fThreadQueue.clear();
        super.dispose();
    }

    protected boolean handlesEvent(DebugEvent event) {
        return event.getSource() instanceof IThread;
    }

    protected void handleSuspend(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        if (!event.isEvaluation()) {
            int extras = 0;
            switch (event.getDetail()) {
                case 16: {
                    extras = 0x1100000;
                    break;
                }
                case 32: {
                    extras = 0x1100000;
                    break;
                }
            }
            this.fireDeltaUpdatingSelectedFrame(thread, extras, event);
        }
    }

    protected void handleResume(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        this.fireDeltaAndClearTopFrame(thread, 0x200C00);
    }

    protected void handleCreate(DebugEvent event) {
        this.fireDeltaAndClearTopFrame((IThread)event.getSource(), 2049);
    }

    protected void handleTerminate(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        IDebugTarget target = thread.getLaunch().getDebugTarget();
        if (!target.isTerminated() && !target.isDisconnected()) {
            this.fireDeltaAndClearTopFrame(thread, 2);
        }
    }

    protected void handleChange(DebugEvent event) {
        if (event.getDetail() == 256) {
            this.fireDeltaUpdatingThread((IThread)event.getSource(), 2048);
        } else {
            this.fireDeltaUpdatingThread((IThread)event.getSource(), 1024);
        }
    }

    protected void handleOther(DebugEvent event) {
    }

    protected void handleLateSuspend(DebugEvent suspend, DebugEvent resume) {
        IThread thread = this.queueSuspendedThread(suspend);
        if (suspend.isEvaluation() && suspend.getDetail() == 128) {
            ModelDelta delta = this.buildRootDelta();
            ModelDelta node = this.addPathToThread(delta, thread);
            node = node.addNode((Object)thread, 2048);
            try {
                IStackFrame frame = thread.getTopStackFrame();
                if (frame != null) {
                    node.addNode((Object)frame, 2048);
                    this.fireDelta((IModelDelta)delta);
                }
            }
            catch (DebugException debugException) {}
        } else {
            this.fireDeltaUpdatingSelectedFrame(thread, 0x100800, suspend);
        }
    }

    protected void handleSuspendTimeout(DebugEvent event) {
        IThread thread = this.removeSuspendedThread(event);
        this.fireDeltaUpdatingThread(thread, 2048);
    }

    protected ModelDelta buildRootDelta() {
        return new ModelDelta((Object)this.getLaunchManager(), 0);
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ModelDelta addPathToThread(ModelDelta delta, IThread thread) {
        ILaunch launch = thread.getLaunch();
        Object[] children = launch.getChildren();
        delta = delta.addNode((Object)launch, this.indexOf(this.getLaunchManager().getLaunches(), launch), 1024, children.length);
        IDebugTarget debugTarget = launch.getDebugTarget();
        int numThreads = -1;
        try {
            numThreads = debugTarget.getThreads().length;
        }
        catch (DebugException debugException) {}
        return delta.addNode((Object)debugTarget, this.indexOf(children, debugTarget), 0, numThreads);
    }

    protected int indexOf(IThread thread) {
        try {
            return this.indexOf(thread.getLaunch().getDebugTarget().getThreads(), thread);
        }
        catch (DebugException debugException) {
            return -1;
        }
    }

    protected int indexOf(IStackFrame frame) {
        try {
            return this.indexOf(frame.getThread().getStackFrames(), frame);
        }
        catch (DebugException debugException) {
            return -1;
        }
    }

    protected int childCount(IThread thread) {
        try {
            return thread.getStackFrames().length;
        }
        catch (DebugException debugException) {
            return -1;
        }
    }

    protected int childCount(IStackFrame frame) {
        return 0;
    }

    protected synchronized IThread queueSuspendedThread(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        if (!this.isDisposed()) {
            this.fThreadQueue.add(thread);
        }
        return thread;
    }

    protected synchronized IThread removeSuspendedThread(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        this.fThreadQueue.remove(thread);
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeltaAndClearTopFrame(IThread thread, int flags) {
        ModelDelta delta = this.buildRootDelta();
        ModelDelta node = this.addPathToThread(delta, thread);
        node.addNode((Object)thread, flags);
        PHPThreadEventHandler pHPThreadEventHandler = this;
        synchronized (pHPThreadEventHandler) {
            this.fLastTopFrame.remove(thread);
        }
        this.fireDelta((IModelDelta)delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeltaUpdatingSelectedFrame(IThread thread, int flags, DebugEvent event) {
        ModelDelta delta = this.buildRootDelta();
        ModelDelta node = this.addPathToThread(delta, thread);
        IStackFrame prev = null;
        PHPThreadEventHandler pHPThreadEventHandler = this;
        synchronized (pHPThreadEventHandler) {
            prev = this.fLastTopFrame.get(thread);
        }
        IStackFrame frame = null;
        try {
            Object frameToSelect = event.getData();
            frame = frameToSelect == null || !(frameToSelect instanceof IStackFrame) ? thread.getTopStackFrame() : (IStackFrame)frameToSelect;
        }
        catch (DebugException debugException) {}
        int threadIndex = this.indexOf(thread);
        int childCount = this.childCount(thread);
        if (this.isEqual(frame, prev)) {
            if (frame == null) {
                if (thread.isSuspended()) {
                    node = node.addNode((Object)thread, threadIndex, flags | 0x800 | 0x200000, childCount);
                }
            } else {
                node = node.addNode((Object)thread, threadIndex, flags, childCount);
            }
        } else {
            if (event.getDetail() == 8) {
                if (prev == null) {
                    flags |= 0x100000;
                } else if (frame == null) {
                    return;
                }
            }
            node = node.addNode((Object)thread, threadIndex, flags | 0x400, childCount);
        }
        if (frame != null) {
            node.addNode((Object)frame, this.indexOf(frame), 0x200800, this.childCount(frame));
        }
        PHPThreadEventHandler pHPThreadEventHandler2 = this;
        synchronized (pHPThreadEventHandler2) {
            if (!this.isDisposed()) {
                this.fLastTopFrame.put(thread, frame);
            }
        }
        this.fireDelta((IModelDelta)delta);
    }

    private void fireDeltaUpdatingThread(IThread thread, int flags) {
        ModelDelta delta = this.buildRootDelta();
        ModelDelta node = this.addPathToThread(delta, thread);
        node = node.addNode((Object)thread, flags);
        this.fireDelta((IModelDelta)delta);
    }

    private boolean isEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

