/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;

public class VirtualPartition
implements IVariable,
IVariableFacet {
    private IValue value;
    private int startIndex;
    private int endIndex;

    public VirtualPartition(IDebugElement element, IVariableProvider variableProvider, int start, int end) {
        this.value = new Value(element, variableProvider);
        this.startIndex = start;
        this.endIndex = end;
    }

    public String getModelIdentifier() {
        return this.value.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.value.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.value.getLaunch();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public String getName() throws DebugException {
        return "[" + this.startIndex + "..." + this.endIndex + "]";
    }

    public String getReferenceTypeName() throws DebugException {
        return "";
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    @Override
    public boolean hasFacet(IVariableFacet.Facet facet) {
        return facet == IVariableFacet.Facet.VIRTUAL_PARTITION;
    }

    @Override
    public void addFacets(IVariableFacet.Facet ... facet) {
    }

    public static interface IVariableProvider {
        public IVariable[] getVariables() throws DebugException;
    }

    private final class Value
    implements IValue {
        private final IDebugElement debugElement;
        private final IVariableProvider variableProvider;

        private Value(IDebugElement debugElement, IVariableProvider variableProvider) {
            this.debugElement = debugElement;
            this.variableProvider = variableProvider;
        }

        public String getModelIdentifier() {
            return this.debugElement.getModelIdentifier();
        }

        public IDebugTarget getDebugTarget() {
            return this.debugElement.getDebugTarget();
        }

        public ILaunch getLaunch() {
            return this.debugElement.getLaunch();
        }

        public Object getAdapter(Class adapter) {
            return this.debugElement.getAdapter(adapter);
        }

        public String getReferenceTypeName() throws DebugException {
            return "";
        }

        public String getValueString() throws DebugException {
            return "";
        }

        public boolean isAllocated() throws DebugException {
            return false;
        }

        public IVariable[] getVariables() throws DebugException {
            return this.variableProvider.getVariables();
        }

        public boolean hasVariables() throws DebugException {
            return true;
        }
    }
}

