/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.sourcelookup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.dltk.core.IArchiveEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.util.HandleFactory;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.PHPSymbolicLinksCache;
import org.eclipse.php.internal.core.phar.PharArchiveFile;
import org.eclipse.php.internal.core.phar.PharPath;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;

public class PHPSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private LinkSubjectFileFinder linkSubjectFileFinder = new LinkSubjectFileFinder();

    public String getSourceName(Object object) throws CoreException {
        if (object instanceof PHPStackFrame) {
            return ((PHPStackFrame)((Object)object)).getSourceName();
        }
        if (object instanceof DBGpStackFrame) {
            String sourceName = ((DBGpStackFrame)((Object)object)).getSourceName();
            if (sourceName == null) {
                sourceName = ((DBGpStackFrame)((Object)object)).getQualifiedFile();
                Path path = new Path(sourceName);
                sourceName = path.lastSegment();
            }
            return sourceName;
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] sourceElements = EMPTY;
        try {
            sourceElements = super.findSourceElements(object);
        }
        catch (CoreException coreException) {}
        if (sourceElements == EMPTY) {
            String sourceFilePath = null;
            if (object instanceof PHPStackFrame) {
                sourceFilePath = ((PHPStackFrame)((Object)object)).getSourceName();
            } else if (object instanceof DBGpStackFrame) {
                sourceFilePath = ((DBGpStackFrame)((Object)object)).getQualifiedFile();
            }
            if (sourceFilePath != null) {
                File file;
                HandleFactory handleFactory = new HandleFactory();
                IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
                IPath localPath = EnvironmentPathUtils.getFile((IEnvironment)LocalEnvironment.getInstance(), (IPath)new Path(sourceFilePath)).getFullPath();
                Openable openable = handleFactory.createOpenable(localPath.toString(), scope);
                if (openable instanceof IStorage) {
                    return new Object[]{openable};
                }
                PharPath pharPath = PharPath.getPharPath((IPath)new Path(sourceFilePath));
                if (pharPath != null && !pharPath.getFile().isEmpty()) {
                    try {
                        PharArchiveFile archiveFile = new PharArchiveFile(pharPath.getPharName());
                        IArchiveEntry entry = archiveFile.getArchiveEntry(String.valueOf(pharPath.getFolder().length() == 0 ? "" : String.valueOf(pharPath.getFolder()) + "/") + pharPath.getFile());
                        return new Object[]{new ExternalEntryFile(sourceFilePath, archiveFile, entry)};
                    }
                    catch (Exception e) {
                        PHPDebugPlugin.log(e);
                    }
                }
                if (!(file = new File(sourceFilePath)).exists()) {
                    return EMPTY;
                }
                Object linkedFile = this.linkSubjectFileFinder.find(sourceFilePath, object);
                if (linkedFile != null) {
                    return new Object[]{linkedFile};
                }
                return new Object[]{new LocalFile(file)};
            }
        }
        return sourceElements;
    }

    private static final class ExternalEntryFile
    extends PlatformObject
    implements IStorage {
        private String fileName;
        private IArchiveEntry entry;
        private PharArchiveFile archiveFile;

        public ExternalEntryFile(String fileName, PharArchiveFile archiveFile, IArchiveEntry entry) {
            this.fileName = fileName;
            this.entry = entry;
            this.archiveFile = archiveFile;
        }

        public InputStream getContents() throws CoreException {
            try {
                return this.archiveFile.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new ModelException((Throwable)e, 985);
            }
        }

        public IPath getFullPath() {
            return new Path(this.fileName);
        }

        public String getName() {
            return this.entry.getName();
        }

        public boolean isReadOnly() {
            return true;
        }

        public String toString() {
            return "ExternalEntryFile[" + this.fileName + "]";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExternalEntryFile)) {
                return false;
            }
            ExternalEntryFile other = (ExternalEntryFile)((Object)obj);
            return this.fileName.toLowerCase().equals(other.fileName.toLowerCase());
        }

        public int hashCode() {
            return this.fileName.toLowerCase().hashCode();
        }
    }

    private final class LinkSubjectFileFinder {
        private LinkSubjectFileFinder() {
        }

        public Object find(final String sourceLocation, Object element) {
            final LinkedList matches = new LinkedList();
            final String sourceFileName = new Path(sourceLocation).lastSegment();
            IWorkspaceRoot project = null;
            if (element instanceof IStackFrame) {
                IDebugTarget target = ((IStackFrame)element).getDebugTarget();
                project = PHPLaunchUtilities.getProject(target);
            }
            IWorkspaceRoot scope = project != null ? project : ResourcesPlugin.getWorkspace().getRoot();
            try {
                scope.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        block6: {
                            block5: {
                                if (matches.isEmpty()) break block5;
                                return false;
                            }
                            if (resource.getType() == 1) break block6;
                            return true;
                        }
                        try {
                            String fileLocation;
                            if ((resource.getName().equals(sourceFileName) || resource.isLinked() || PHPSymbolicLinksCache.INSTANCE.isSymbolicLink(resource)) && FileUtils.isSameFile((String)sourceLocation, (String)(fileLocation = resource.getLocation().toOSString()))) {
                                matches.add(resource);
                            }
                        }
                        catch (IOException e) {
                            PHPDebugPlugin.log(e);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                PHPDebugPlugin.log(e);
            }
            return !matches.isEmpty() ? (IResource)matches.getFirst() : null;
        }
    }
}

