/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.text.MessageFormat;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsManager;

public class ExpressionsUtil {
    private static final int PROP_MOD_PUBLIC = 256;
    private static final int PROP_MOD_PROTECTED = 512;
    private static final int PROP_MOD_PRIVATE = 1024;
    private static final Map<Expression, String> staticMemberClassNames = new WeakHashMap<Expression, String>();

    private ExpressionsUtil() {
    }

    public static Expression[] fetchStaticMembers(String className, ExpressionsManager expressionsManager) {
        FetchStaticsExpression staticMembers = new FetchStaticsExpression(className);
        expressionsManager.update(staticMembers, 1);
        Expression[] members = staticMembers.getValue().getChildren();
        if (members == null) {
            return new Expression[0];
        }
        int[] mods = ExpressionsUtil.fetchStaticMembersVisibility(className, members, expressionsManager);
        if (mods == null) {
            return new Expression[0];
        }
        if (members.length > 0) {
            int i = 0;
            while (i < members.length) {
                Expression member = members[i];
                staticMemberClassNames.put(member, className);
                if ((mods[i] & 0x400) > 0) {
                    member.addFacets(IVariableFacet.Facet.MOD_PRIVATE);
                } else if ((mods[i] & 0x200) > 0) {
                    member.addFacets(IVariableFacet.Facet.MOD_PROTECTED);
                } else if ((mods[i] & 0x100) > 0) {
                    member.addFacets(IVariableFacet.Facet.MOD_PUBLIC);
                }
                ++i;
            }
            return members;
        }
        return new Expression[0];
    }

    public static String fetchStaticMemberClassName(Expression staticMember) {
        return staticMemberClassNames.get(staticMember);
    }

    public static Expression fetchStaticContext(String className, ExpressionsManager expressionsManager) {
        Expression[] staticMembers = ExpressionsUtil.fetchStaticMembers(className, expressionsManager);
        if (staticMembers.length == 0) {
            return null;
        }
        DefaultExpression classStaticContext = new DefaultExpression("<class>", IVariableFacet.Facet.VIRTUAL_CLASS);
        ExpressionValue classStaticContextValue = new ExpressionValue(IPHPDataType.DataType.PHP_VIRTUAL_CLASS, className, "Class of: " + className, staticMembers, staticMembers.length);
        classStaticContext.setValue(classStaticContextValue);
        return classStaticContext;
    }

    private static int[] fetchStaticMembersVisibility(String className, Expression[] members, ExpressionsManager expressionsManager) {
        StringBuffer tuple = new StringBuffer();
        int i = 0;
        while (i < members.length) {
            tuple.append(MessageFormat.format("(new ReflectionProperty(\\''{0}\\'', \\''{1}\\''))->getModifiers()", className, members[i].getLastName()));
            if (i < members.length - 1) {
                tuple.append(',');
            }
            ++i;
        }
        FetchStaticsVisibilityExpression fetchModifiersExpression = new FetchStaticsVisibilityExpression(tuple.toString());
        expressionsManager.update(fetchModifiersExpression, 1);
        Expression[] computed = fetchModifiersExpression.getValue().getOriChildren();
        if (computed == null) {
            return null;
        }
        int[] mods = new int[computed.length];
        int i2 = 0;
        while (i2 < computed.length) {
            mods[i2] = Integer.valueOf((String)computed[i2].getValue().getValue());
            ++i2;
        }
        return mods;
    }

    private static final class FetchStaticsExpression
    extends DefaultExpression {
        static final String FETCH_STATIC_MEMBERS = "eval(''if (class_exists(\\''ReflectionClass\\'') && class_exists(\\''{0}\\'')) return (new ReflectionClass(\\''{0}\\''))->getStaticProperties(); else return array();'');";

        public FetchStaticsExpression(String className) {
            super(MessageFormat.format(FETCH_STATIC_MEMBERS, className));
        }

        @Override
        public Expression createChildExpression(String endName, String endRepresentation, IVariableFacet.Facet ... facets) {
            return new DefaultExpression(this, endName, endRepresentation, IVariableFacet.Facet.KIND_OBJECT_MEMBER, IVariableFacet.Facet.MOD_STATIC);
        }
    }

    private static final class FetchStaticsVisibilityExpression
    extends DefaultExpression {
        static final String FETCH_STATICS_MODIFIERS = "eval(''if (class_exists(\\''ReflectionProperty\\'')) return array({0}); else return array();'');";
        static final String TUPLE_ELEMENT = "(new ReflectionProperty(\\''{0}\\'', \\''{1}\\''))->getModifiers()";

        public FetchStaticsVisibilityExpression(String tuple) {
            super(MessageFormat.format(FETCH_STATICS_MODIFIERS, tuple));
        }
    }
}

