/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.launching.PHPExecutableLaunchDelegate;
import org.eclipse.php.internal.debug.core.launching.PHPWebPageLaunchDelegate;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerConfigurationDialog;
import org.eclipse.swt.widgets.Shell;

public class ZendDebuggerConfiguration
extends AbstractDebuggerConfiguration {
    public static final String ID = "org.eclipse.php.debug.core.zendDebugger";
    private static final String EXTENSION_MODULE_ID = "Zend Debugger";

    @Override
    public String getModuleId() {
        return EXTENSION_MODULE_ID;
    }

    @Override
    public void openConfigurationDialog(Shell parentShell) {
        new ZendDebuggerConfigurationDialog(this, parentShell).open();
    }

    @Override
    public int getPort() {
        return Platform.getPreferencesService().getInt("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, 0, null);
    }

    @Override
    public void setPort(int port) {
        this.preferences.putInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, port);
    }

    public int getBroadcastPort() {
        return Platform.getPreferencesService().getInt("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT, 0, null);
    }

    public void setBroadcastPort(int broadcastPort) {
        this.preferences.putInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT, broadcastPort);
    }

    public String getDummyFile() {
        return Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE, null, null);
    }

    public void setDummyFile(String dummyFile) {
        this.preferences.put(PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE, dummyFile);
    }

    public boolean isUseNewProtocol() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, true, null);
    }

    public void setUNewProtocol(boolean enable) {
        this.preferences.putBoolean(PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, enable);
    }

    @Override
    public String getScriptLaunchDelegateClass() {
        return PHPExecutableLaunchDelegate.class.getName();
    }

    @Override
    public String getWebLaunchDelegateClass() {
        return PHPWebPageLaunchDelegate.class.getName();
    }

    @Override
    public void applyDefaults() {
        this.setPort(this.defaultPreferences.getInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, 0));
        this.preferences.put(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, this.defaultPreferences.get(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, null));
        this.setBroadcastPort(this.defaultPreferences.getInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT, 0));
        this.setDummyFile(this.defaultPreferences.get(PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE, null));
        this.save();
    }

    @Override
    public IStatus validate(PHPexeItem item) {
        File executable = item.getExecutable();
        PHPexes.changePermissions(executable);
        if (this.isInstalled(item, EXTENSION_MODULE_ID)) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.eclipse.php.debug.core", PHPDebugCoreMessages.ZendDebuggerConfiguration_ZendDebuggerNotInstalledError);
    }
}

