/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.semantic_highlighter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.Position;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.ClassHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.ConstantHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.DeprecatedHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.FieldHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.FunctionHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.InternalClassHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.InternalConstantHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.InternalFunctionHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.MethodHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.ParameterVariableHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.StaticFieldHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.StaticMethodHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.SuperGlobalHighlighting;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class SemanticHighlightingTests {
    protected IProject project;
    protected IFile testFile;
    protected List<IFile> otherFiles = null;
    protected PHPVersion phpVersion;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private static Map<String, AbstractSemanticHighlighting> highlighters;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/semantic_highlighting/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/semantic_highlighting/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/semantic_highlighting/php54"});
        highlighters = new HashMap<String, AbstractSemanticHighlighting>();
        highlighters.put("class", (AbstractSemanticHighlighting)new ClassHighlighting());
        highlighters.put("constant", (AbstractSemanticHighlighting)new ConstantHighlighting());
        highlighters.put("deprecated", (AbstractSemanticHighlighting)new DeprecatedHighlighting());
        highlighters.put("field", (AbstractSemanticHighlighting)new FieldHighlighting());
        highlighters.put("function", (AbstractSemanticHighlighting)new FunctionHighlighting());
        highlighters.put("internal_class", (AbstractSemanticHighlighting)new InternalClassHighlighting());
        highlighters.put("internal_constant", (AbstractSemanticHighlighting)new InternalConstantHighlighting());
        highlighters.put("internal_function", (AbstractSemanticHighlighting)new InternalFunctionHighlighting());
        highlighters.put("method", (AbstractSemanticHighlighting)new MethodHighlighting());
        highlighters.put("parameter_variable", (AbstractSemanticHighlighting)new ParameterVariableHighlighting());
        highlighters.put("static_field", (AbstractSemanticHighlighting)new StaticFieldHighlighting());
        highlighters.put("static_method", (AbstractSemanticHighlighting)new StaticMethodHighlighting());
        highlighters.put("super_global", (AbstractSemanticHighlighting)new SuperGlobalHighlighting());
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }

    public SemanticHighlightingTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("SemanticHighlighting_" + this.phpVersion);
        if (this.project.exists()) {
            return;
        }
        this.project.create(null);
        this.project.open(null);
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        this.project.setDescription(desc, null);
        PHPCoreTests.setProjectPhpVersion((IProject)this.project, (PHPVersion)this.phpVersion);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        this.project.close(null);
        this.project.delete(true, true, null);
        this.project = null;
    }

    @After
    public void tearDown() throws Exception {
        if (this.testFile != null) {
            this.testFile.delete(true, null);
            this.testFile = null;
        }
        if (this.otherFiles != null) {
            for (IFile file : this.otherFiles) {
                if (file == null) continue;
                file.delete(true, null);
            }
            this.otherFiles = null;
        }
    }

    @Test
    public void highlighter(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
        String result = "";
        this.createFile(pdttFile);
        ISourceModule module = this.getSourceModule();
        Assert.assertNotNull((Object)module);
        String index = fileName.substring(fileName.lastIndexOf(47) + 1, fileName.indexOf(46));
        int endIndex = index.indexOf(45);
        if (endIndex != -1) {
            index = index.substring(0, endIndex);
        }
        AbstractSemanticHighlighting highlighter = highlighters.get(index);
        Assert.assertNotNull((Object)highlighter);
        Program program = this.getProgram(module);
        Position[] positions = highlighter.consumes(program);
        this.assertNoDuplicates(highlighter.getDisplayName(), positions);
        result = String.valueOf(result) + highlighter.getClass().getName() + ":\n";
        Position[] positionArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Position position = positionArray[n2];
            result = String.valueOf(result) + "highlight(" + pdttFile.getFile().substring(position.getOffset(), position.getOffset() + position.getLength()) + ")\n";
            ++n2;
        }
        Assert.assertEquals((Object)pdttFile.getExpected(), (Object)result);
        for (AbstractSemanticHighlighting h : highlighters.values()) {
            if (h == highlighter) continue;
            positions = h.consumes(program);
            this.assertNoDuplicates(highlighter.getDisplayName(), positions);
        }
    }

    private Program getProgram(ISourceModule module) throws ModelException, IOException {
        return SharedASTProvider.getAST((ISourceModule)module, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
    }

    protected void assertNoDuplicates(String highlighter, Position[] positions) {
        Position[] positionArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Position p1 = positionArray[n2];
            Position[] positionArray2 = positions;
            int n3 = positions.length;
            int n4 = 0;
            while (n4 < n3) {
                Position p2 = positionArray2[n4];
                if (p1 != p2 && p1.equals((Object)p2)) {
                    throw new IllegalStateException("Found duplicate position in " + highlighter + ": " + p1);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void createFile(PdttFile pdttFile) throws Exception {
        this.testFile = this.project.getFile("test.php");
        this.testFile.create((InputStream)new ByteArrayInputStream(pdttFile.getFile().getBytes()), true, null);
        String[] otherFiles = pdttFile.getOtherFiles();
        this.otherFiles = new ArrayList<IFile>(otherFiles.length);
        int i = 0;
        String[] stringArray = otherFiles;
        int n = otherFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String otherFileContent = stringArray[n2];
            IFile tmp = this.project.getFile(String.format("test%s.php", i));
            tmp.create((InputStream)new ByteArrayInputStream(otherFileContent.getBytes()), true, null);
            this.otherFiles.add(i, tmp);
            ++i;
            ++n2;
        }
        this.project.refreshLocal(2, null);
        this.project.build(6, null);
        PHPCoreTests.waitForIndexer();
    }

    protected ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)this.testFile);
    }
}

