/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.corext.ASTNodes;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;

public final class ASTProvider {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/ASTProvider"));
    public static final boolean SHARED_AST_STATEMENT_RECOVERY = true;
    public static final boolean SHARED_BINDING_RECOVERY = true;
    private static final String DEBUG_PREFIX = "ASTProvider > ";
    private ISourceModule fReconcilingJavaElement;
    private ISourceModule fActiveJavaElement;
    private Program fAST;
    private ActivationListener fActivationListener;
    private Object fReconcileLock = new Object();
    private Object fWaitLock = new Object();
    private boolean fIsReconciling;
    private IWorkbenchPart fActiveEditor;

    public static ASTProvider getASTProvider() {
        return PHPUiPlugin.getDefault().getASTProvider();
    }

    public ASTProvider() {
        this.install();
    }

    void install() {
        this.fActivationListener = new ActivationListener();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        int length = windows.length;
        while (i < length) {
            windows[i].getPartService().addPartListener((IPartListener2)this.fActivationListener);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeJavaEditorChanged(IWorkbenchPart editor) {
        ISourceModule javaElement = null;
        if (editor instanceof PHPStructuredEditor) {
            javaElement = (ISourceModule)((PHPStructuredEditor)editor).getModelElement();
        }
        Object object = this;
        synchronized (object) {
            this.fActiveEditor = editor;
            this.fActiveJavaElement = javaElement;
            this.cache(null, javaElement);
        }
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "active editor is: " + this.toString(javaElement));
        }
        object = this.fReconcileLock;
        synchronized (object) {
            if (this.fIsReconciling && (this.fReconcilingJavaElement == null || !this.fReconcilingJavaElement.equals(javaElement))) {
                this.fIsReconciling = false;
                this.fReconcilingJavaElement = null;
            } else if (javaElement == null) {
                this.fIsReconciling = false;
                this.fReconcilingJavaElement = null;
            }
        }
    }

    public boolean isCached(Program ast) {
        return ast != null && this.fAST == ast;
    }

    public boolean isActive(ISourceModule cu) {
        return cu != null && cu.equals(this.fActiveJavaElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aboutToBeReconciled(ISourceModule javaElement) {
        if (javaElement == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "about to reconcile: " + this.toString(javaElement));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = true;
            this.fReconcilingJavaElement = javaElement;
            this.cache(null, javaElement);
        }
    }

    private synchronized void disposeAST() {
        if (this.fAST == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "disposing AST: " + this.toString(this.fAST) + " for: " + this.toString(this.fActiveJavaElement));
        }
        this.fAST = null;
        this.cache(null, null);
    }

    private String toString(ISourceModule javaElement) {
        if (javaElement == null) {
            return "null";
        }
        return javaElement.getElementName();
    }

    private String toString(Program ast) {
        if (ast == null) {
            return "null";
        }
        return "AST without any type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cache(Program ast, ISourceModule javaElement) {
        if (this.fActiveJavaElement != null && !this.fActiveJavaElement.equals(javaElement)) {
            if (DEBUG && javaElement != null) {
                System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "don't cache AST for inactive: " + this.toString(javaElement));
            }
            return;
        }
        if (DEBUG && (javaElement != null || ast != null)) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "caching AST: " + this.toString(ast) + " for: " + this.toString(javaElement));
        }
        if (this.fAST != null) {
            this.disposeAST();
        }
        this.fAST = ast;
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Program getAST(ISourceModule input, SharedASTProvider.WAIT_FLAG waitFlag, IProgressMonitor progressMonitor) {
        boolean isActiveElement;
        if (input == null) throw new IllegalArgumentException("input or wait flag are null");
        if (waitFlag == null) {
            throw new IllegalArgumentException("input or wait flag are null");
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            isActiveElement = input.equals(this.fActiveJavaElement);
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (!DEBUG) return this.fAST;
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "returning cached AST:" + this.toString(this.fAST) + " for: " + input.getElementName());
                    return this.fAST;
                }
                if (waitFlag == SharedASTProvider.WAIT_NO) {
                    if (!DEBUG) return null;
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "returning null (WAIT_NO) for: " + input.getElementName());
                    return null;
                }
            }
        }
        boolean canReturnNull = waitFlag == SharedASTProvider.WAIT_NO || waitFlag == SharedASTProvider.WAIT_ACTIVE_ONLY && (!isActiveElement || this.fAST != null);
        boolean isReconciling = false;
        if (isActiveElement) {
            Object object = this.fReconcileLock;
            synchronized (object) {
                isReconciling = this.isReconciling(input);
                if (!isReconciling && !canReturnNull) {
                    this.aboutToBeReconciled(input);
                }
            }
        }
        if (isReconciling) {
            try {
                ISourceModule activeElement = this.fReconcilingJavaElement;
                Object object = this.fWaitLock;
                synchronized (object) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "waiting for AST for: " + input.getElementName());
                    }
                    this.fWaitLock.wait(30000L);
                }
                object = this;
                synchronized (object) {
                    if (activeElement != this.fActiveJavaElement) return this.getAST(input, waitFlag, progressMonitor);
                    if (this.fAST == null) return this.getAST(input, waitFlag, progressMonitor);
                    if (!DEBUG) return this.fAST;
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "...got AST for: " + input.getElementName());
                    return this.fAST;
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        if (canReturnNull) {
            return null;
        }
        Program ast = null;
        try {
            ast = ASTProvider.createAST(input, progressMonitor);
            if (progressMonitor == null) return ast;
            if (!progressMonitor.isCanceled()) return ast;
            ast = null;
            if (!DEBUG) return ast;
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "Ignore created AST for: " + input.getElementName() + " - operation has been cancelled");
            return ast;
        }
        finally {
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "Ignore created AST for " + input.getElementName() + " - AST from reconciler is newer");
                    }
                    this.reconciled(this.fAST, input, null);
                    return this.fAST;
                }
                this.reconciled(ast, input, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReconciling(ISourceModule javaElement) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            return javaElement != null && javaElement.equals(this.fReconcilingJavaElement) && this.fIsReconciling && !(javaElement instanceof IExternalSourceModule) && !this.isValidatorDisabled(javaElement);
        }
    }

    private boolean isValidatorDisabled(ISourceModule javaElement) {
        if (ValidationFramework.getDefault().isSuspended()) {
            return true;
        }
        if (javaElement.getResource() != null) {
            IResource resource = javaElement.getResource();
            if (!resource.getProject().isAccessible()) {
                return true;
            }
            if (ValidationFramework.getDefault().isSuspended(resource.getProject())) {
                return true;
            }
            if (ValidationFramework.getDefault().getProjectSettings(resource.getProject()).getSuspend()) {
                return true;
            }
            if (ModelManager.getExternalManager().getExternalFoldersProject().equals((Object)javaElement.getScriptProject())) {
                return false;
            }
            Set validators = ValidationFramework.getDefault().getDisabledValidatorsFor(resource);
            for (Validator v : validators) {
                if (!v.getId().equals("org.eclipse.php.ui.internal.validation.phpreconciler")) continue;
                return true;
            }
        }
        return false;
    }

    private static Program createAST(final ISourceModule input, final IProgressMonitor progressMonitor) {
        if (!ASTProvider.hasSource(input)) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final ASTParser parser = ASTParser.newParser((ISourceModule)input);
        if (parser == null) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final Program[] root = new Program[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        return;
                    }
                    if (DEBUG) {
                        System.err.println(String.valueOf(ASTProvider.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "creating AST for: " + input.getElementName());
                    }
                    root[0] = parser.createAST(progressMonitor);
                    ASTNodes.setFlagsToAST((ASTNode)root[0], (int)4);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return;
                }
                catch (Exception e) {
                    PHPUiPlugin.log(e);
                    return;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.php.ui", 0, "Error in PDT UI during AST creation", ex);
                PHPUiPlugin.log((IStatus)status);
            }
        });
        return root[0];
    }

    private static boolean hasSource(ISourceModule je) {
        return je != null && je.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
        this.fActivationListener = null;
        this.disposeAST();
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconciled(Program ast, ISourceModule javaElement, IProgressMonitor progressMonitor) {
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "reconciled: " + this.toString(javaElement) + ", AST: " + this.toString(ast));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            if (javaElement == null || !javaElement.equals(this.fReconcilingJavaElement)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "  ignoring AST of out-dated editor");
                }
                Object object2 = this.fWaitLock;
                synchronized (object2) {
                    this.fWaitLock.notifyAll();
                }
                return;
            }
            this.fIsReconciling = progressMonitor != null && progressMonitor.isCanceled();
            this.cache(ast, javaElement);
        }
    }

    private static String getThreadName() {
        String name = Thread.currentThread().getName();
        if (name != null) {
            return name;
        }
        return Thread.currentThread().toString();
    }

    private class ActivationListener
    implements IPartListener2,
    IWindowListener {
        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partClosed(IWorkbenchPartReference ref) {
            if (this.isActiveEditor(ref)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + ref.getTitle());
                }
                ASTProvider.this.activeJavaEditorChanged(null);
            }
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            IWorkbenchPartReference ref = window.getPartService().getActivePartReference();
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (ASTProvider.this.fActiveEditor != null && ASTProvider.this.fActiveEditor.getSite() != null && window == ASTProvider.this.fActiveEditor.getSite().getWorkbenchWindow()) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + ASTProvider.this.fActiveEditor.getTitle());
                }
                ASTProvider.this.activeJavaEditorChanged(null);
            }
            window.getPartService().removePartListener((IPartListener2)this);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener((IPartListener2)this);
        }

        private boolean isActiveEditor(IWorkbenchPartReference ref) {
            return ref != null && this.isActiveEditor(ref.getPart(false));
        }

        private boolean isActiveEditor(IWorkbenchPart part) {
            return part != null && part == ASTProvider.this.fActiveEditor;
        }

        private boolean isJavaEditor(IWorkbenchPartReference ref) {
            if (ref == null) {
                return false;
            }
            String id = ref.getId();
            return "org.eclipse.php.editor".equals(id) || ref.getPart(false) instanceof PHPStructuredEditor;
        }
    }
}

