/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.BrowserInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.documentation.PHPDocumentationContentAccess;
import org.eclipse.php.internal.ui.documentation.PHPElementLinks;
import org.eclipse.php.internal.ui.editor.hover.AbstractPHPEditorTextHover;
import org.eclipse.php.internal.ui.editor.hover.PHPDocumentationBrowserInformationControlInput;
import org.eclipse.php.internal.ui.editor.hover.PHPHoverMessages;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.php.internal.ui.util.OpenBrowserUtil;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.ui.PHPElementLabels;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.osgi.framework.Bundle;

public class PHPDocumentationHover
extends AbstractPHPEditorTextHover
implements IPHPTextHover,
IInformationProviderExtension2 {
    private static final long LABEL_FLAGS = ScriptElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L | 0x20L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static String fgStyleSheet;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    @Override
    public IHoverMessageDecorator getMessageDecorator() {
        return null;
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    private static void addLinkListener(final BrowserInformationControl control) {
        control.addLocationListener(PHPElementLinks.createLocationListener(new PHPElementLinks.ILinkHandler(){

            @Override
            public void handleInlineLink(IModelElement linkTarget) {
                PHPDocumentationBrowserInformationControlInput hoverInfo = PHPDocumentationHover.getHoverInfo(new IModelElement[]{linkTarget}, null, (PHPDocumentationBrowserInformationControlInput)control.getInput());
                if (control.hasDelayedInputChangeListener()) {
                    control.notifyDelayedInputChange((Object)hoverInfo);
                } else {
                    control.setInput((Object)hoverInfo);
                }
            }

            @Override
            public void handleDeclarationLink(IModelElement linkTarget) {
                control.notifyDelayedInputChange(null);
                control.dispose();
            }

            @Override
            public boolean handleExternalLink(URL url, Display display) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                OpenBrowserUtil.open(url, display);
                return true;
            }

            @Override
            public void handleTextSet() {
            }
        }));
    }

    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.internalGetHoverInfo(textViewer, hoverRegion);
    }

    private PHPDocumentationBrowserInformationControlInput internalGetHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String constantValue;
        IModelElement[] elements = this.getElementsAt(textViewer, hoverRegion);
        if (elements == null || elements.length == 0) {
            return null;
        }
        TreeSet<IModelElement> elementSet = new TreeSet<IModelElement>(new Comparator<IModelElement>(){

            @Override
            public int compare(IModelElement o1, IModelElement o2) {
                if (o1 instanceof IType && o2 instanceof IType) {
                    IType type1 = (IType)o1;
                    IType type2 = (IType)o2;
                    try {
                        if (PHPFlags.isNamespace((int)type1.getFlags()) && PHPFlags.isNamespace((int)type2.getFlags()) && type1.getElementName().equals(type2.getElementName())) {
                            return 0;
                        }
                    }
                    catch (ModelException modelException) {}
                }
                return 1;
            }
        });
        ArrayList<IModelElement> elementList = new ArrayList<IModelElement>();
        int i = 0;
        while (i < elements.length) {
            if (!elementSet.contains(elements[i])) {
                elementSet.add(elements[i]);
                elementList.add(elements[i]);
            }
            ++i;
        }
        elements = elementList.toArray(new IModelElement[elementList.size()]);
        if (elements.length == 1 && elements[0].getElementType() == 8) {
            constantValue = this.getConstantValue((IField)elements[0], hoverRegion);
            if (constantValue != null) {
                constantValue = HTMLPrinter.convertToHTMLContent((String)constantValue);
            }
        } else {
            constantValue = null;
        }
        return PHPDocumentationHover.getHoverInfo(elements, constantValue, null);
    }

    private static PHPDocumentationBrowserInformationControlInput getHoverInfo(IModelElement[] elements, String constantValue, PHPDocumentationBrowserInformationControlInput previousInput) {
        StringBuffer buffer = new StringBuffer();
        boolean hasContents = false;
        IModelElement element = null;
        int leadingImageWidth = 20;
        int i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)PHPDocumentationHover.getInfoText((IModelElement)member, constantValue, true, i == 0));
                Reader reader = null;
                try {
                    reader = PHPDocumentationHover.getHTMLContent(member);
                }
                catch (ModelException modelException) {}
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
                }
                if (i != elements.length - 1) {
                    buffer.append("<hr>");
                }
                hasContents = true;
            } else if (element.getElementType() == 8) {
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)PHPDocumentationHover.getInfoText(element, constantValue, true, i == 0));
                hasContents = true;
            }
            ++i;
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)PHPDocumentationHover.getStyleSheet());
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return new PHPDocumentationBrowserInformationControlInput(previousInput, element, buffer.toString(), leadingImageWidth);
        }
        return null;
    }

    private static String getInfoText(IModelElement element, String constantValue, boolean allowImage, boolean isFirstElement) {
        URL imageUrl;
        StringBuffer label = PHPDocumentationHover.getInfoText(element);
        if (element.getElementType() == 8 && constantValue != null) {
            label.append(' ');
            label.append('=');
            label.append(' ');
            label.append(constantValue);
        }
        String imageName = null;
        if (allowImage && (imageUrl = PHPUiPlugin.getDefault().getImagesOnFSRegistry().getImageURL(element)) != null) {
            imageName = imageUrl.toExternalForm();
        }
        StringBuffer buf = new StringBuffer();
        PHPDocumentationHover.addImageAndLabel(buf, imageName, 16, 16, 2, 2, label.toString(), 20, 2, isFirstElement);
        return buf.toString();
    }

    private static boolean isFinal(IField field) {
        try {
            return PHPFlags.isFinal((int)field.getFlags());
        }
        catch (ModelException e) {
            PHPUiPlugin.log(e);
            return false;
        }
    }

    private String getConstantValue(IField field, IRegion hoverRegion) {
        if (!PHPDocumentationHover.isFinal(field)) {
            return null;
        }
        ISourceModule typeRoot = this.getEditorInputModelElement();
        if (typeRoot == null) {
            return null;
        }
        Object constantValue = null;
        if (field != null && field.exists()) {
            try {
                org.eclipse.php.internal.core.ast.nodes.ASTNode node;
                Program unit = SharedASTProvider.getAST(field.getSourceModule(), SharedASTProvider.WAIT_YES, null);
                org.eclipse.php.internal.core.ast.nodes.ASTNode aSTNode = node = unit != null ? NodeFinder.perform((org.eclipse.php.internal.core.ast.nodes.ASTNode)unit, (int)field.getNameRange().getOffset(), (int)field.getNameRange().getLength()) : null;
                if (node != null) {
                    if (node instanceof Identifier && node.getParent() instanceof ConstantDeclaration) {
                        ConstantDeclaration decl = (ConstantDeclaration)node.getParent();
                        if (decl.initializers().size() == 1 && decl.initializers().get(0) instanceof Scalar) {
                            Scalar scalar = (Scalar)decl.initializers().get(0);
                            constantValue = scalar.getStringValue();
                        }
                    } else if (node instanceof Scalar && node.getParent() instanceof FunctionInvocation) {
                        FunctionInvocation invocation = (FunctionInvocation)node.getParent();
                        Expression function = invocation.getFunctionName().getName();
                        String functionName = "";
                        if (function instanceof NamespaceName) {
                            if (((NamespaceName)function).isGlobal()) {
                                functionName = ((NamespaceName)function).getName();
                                if (functionName.charAt(0) == '\\') {
                                    functionName = functionName.substring(1);
                                }
                            } else {
                                ModuleDeclaration parsedUnit = SourceParserUtil.getModuleDeclaration((ISourceModule)field.getSourceModule(), null);
                                ASTNode func = ASTUtils.findMinimalNode((ModuleDeclaration)parsedUnit, (int)function.getStart(), (int)function.getEnd());
                                if (func instanceof FullyQualifiedReference) {
                                    functionName = ((FullyQualifiedReference)func).getFullyQualifiedName();
                                }
                                if (functionName.indexOf(92) == -1) {
                                    IType currentNamespace = PHPModelUtils.getCurrentNamespace((ISourceModule)field.getSourceModule(), (int)function.getStart());
                                    String fullyQualifiedFuncName = "";
                                    fullyQualifiedFuncName = currentNamespace != null ? "\\" + currentNamespace.getElementName() + "\\" + functionName : functionName;
                                    IMethod[] methods = PHPModelUtils.getFunctions((String)fullyQualifiedFuncName, (ISourceModule)field.getSourceModule(), (int)function.getStart(), null);
                                    if (methods != null && methods.length > 0) {
                                        functionName = fullyQualifiedFuncName;
                                    }
                                }
                            }
                        } else if (function instanceof Identifier) {
                            functionName = ((Identifier)function).getName();
                        }
                        if (functionName.equalsIgnoreCase("define") && invocation.parameters().size() >= 2 && invocation.parameters().get(1) instanceof Scalar) {
                            constantValue = ((Scalar)invocation.parameters().get(1)).getStringValue();
                        }
                    }
                }
            }
            catch (ModelException modelException) {
            }
            catch (IOException iOException) {}
        }
        if (constantValue == null) {
            return null;
        }
        if (constantValue instanceof String) {
            StringBuffer result = new StringBuffer();
            String stringConstant = (String)constantValue;
            if (stringConstant.length() > 80) {
                result.append(stringConstant.substring(0, 80));
                result.append("...");
            } else {
                result.append(stringConstant);
            }
            return result.toString();
        }
        if (constantValue instanceof Integer) {
            int intValue = (Integer)constantValue;
            return PHPDocumentationHover.formatWithHexValue(constantValue, "0x" + Integer.toHexString(intValue));
        }
        return constantValue.toString();
    }

    private static String formatWithHexValue(Object constantValue, String hexValue) {
        return Messages.format(PHPHoverMessages.JavadocHover_constantValue_hexValue, new String[]{constantValue.toString(), hexValue});
    }

    protected static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = PHPDocumentationHover.loadStyleSheet();
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.dltk.ui.documentationFont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)PHPUiPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/PHPDocumentationHoverStyleSheet.css");
        if (styleSheetURL != null) {
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(1500);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            String string = buffer.toString();
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return string;
            catch (IOException ex) {
                try {
                    PHPUiPlugin.log(ex);
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                return "";
            }
        }
        return null;
    }

    public static void addImageAndLabel(StringBuffer buf, String imageName, int imageWidth, int imageHeight, int imageLeft, int imageTop, String label, int labelLeft, int labelTop) {
        PHPDocumentationHover.addImageAndLabel(buf, imageName, imageWidth, imageHeight, imageLeft, imageTop, label, labelLeft, labelTop, true);
    }

    private static void addImageAndLabel(StringBuffer buf, String imageName, int imageWidth, int imageHeight, int imageLeft, int imageTop, String label, int labelLeft, int labelTop, boolean isFirstElement) {
        label = String.valueOf(label) + "&nbsp;";
        if (imageName != null) {
            StringBuffer imageStyle = new StringBuffer("position: absolute; ");
            imageStyle.append("width: ").append(imageWidth).append("px; ");
            imageStyle.append("height: ").append(imageHeight).append("px; ");
            if (isFirstElement) {
                imageStyle.append("top: ").append(imageTop).append("px; ");
                imageStyle.append("left: ").append(imageLeft).append("px; ");
            } else {
                imageStyle.append("margin-top: ").append(imageTop).append("px; ");
                imageStyle.append("margin-left: ").append(-imageLeft).append("px; ");
            }
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            buf.append("<span style=\"").append(imageStyle).append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(imageName).append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img style='").append(imageStyle).append("' src='").append(imageName).append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img style='").append(imageStyle).append("' src='").append(imageName).append("'/>\n");
            buf.append("<![endif]-->\n");
        }
        buf.append("<div style='word-wrap:break-word;");
        if (imageName != null) {
            buf.append("margin-left: ").append(labelLeft).append("px; ");
            buf.append("margin-top: ").append(labelTop).append("px; ");
        }
        buf.append("'>");
        buf.append(label);
        buf.append("</div>");
    }

    protected static Reader getHTMLContent(IMember curr) throws ModelException {
        String html = PHPDocumentationContentAccess.getHTMLContent(curr);
        if (html != null) {
            return new StringReader(html);
        }
        return null;
    }

    private static StringBuffer getInfoText(IModelElement member) {
        long flags = member.getElementType() == 8 ? LOCAL_VARIABLE_FLAGS : LABEL_FLAGS;
        String label = PHPElementLabels.getDefault().getElementLabel(member, flags);
        return new StringBuffer(label);
    }

    private static final class BackAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public BackAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(PHPHoverMessages.JavadocHover_back);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput previous = (BrowserInformationControlInput)this.fInfoControl.getInput().getPrevious();
            if (previous != null) {
                this.fInfoControl.setInput((Object)previous);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getPrevious() != null) {
                BrowserInput previous = current.getPrevious();
                this.setToolTipText(Messages.format(PHPHoverMessages.JavadocHover_back_toElement_toolTip, BasicElementLabels.getJavaElementName((String)previous.getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(PHPHoverMessages.JavadocHover_back);
                this.setEnabled(false);
            }
        }
    }

    private static final class ForwardAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ForwardAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(PHPHoverMessages.JavadocHover_forward);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput next = (BrowserInformationControlInput)this.fInfoControl.getInput().getNext();
            if (next != null) {
                this.fInfoControl.setInput((Object)next);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getNext() != null) {
                this.setToolTipText(Messages.format(PHPHoverMessages.JavadocHover_forward_toElement_toolTip, BasicElementLabels.getJavaElementName((String)current.getNext().getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(PHPHoverMessages.JavadocHover_forward_toolTip);
                this.setEnabled(false);
            }
        }
    }

    public static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fInformationPresenterControlCreator;

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            String tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                String font = "org.eclipse.dltk.ui.documentationFont";
                BrowserInformationControl iControl = new BrowserInformationControl(parent, font, tooltipAffordanceString){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return HoverControlCreator.this.fInformationPresenterControlCreator;
                    }
                };
                PHPDocumentationHover.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, tooltipAffordanceString);
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                String tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
                ((IInformationControlExtension4)control).setStatusText(tooltipAffordanceString);
            }
            return true;
        }
    }

    private static final class OpenDeclarationAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public OpenDeclarationAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(PHPHoverMessages.JavadocHover_openDeclaration);
            PHPPluginImages.setLocalImageDescriptors((IAction)this, "goto_input.png");
        }

        public void run() {
            PHPDocumentationBrowserInformationControlInput infoInput = (PHPDocumentationBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                IEditorPart editor = EditorUtility.openInEditor((Object)infoInput.getElement(), (boolean)true);
                EditorUtility.revealInEditor((IEditorPart)editor, (IModelElement)infoInput.getElement());
            }
            catch (PartInitException e) {
                PHPUiPlugin.log(e);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
        }
    }

    public static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                ToolBarManager tbm = new ToolBarManager(0x800000);
                String font = "org.eclipse.dltk.ui.documentationFont";
                BrowserInformationControl iControl = new BrowserInformationControl(parent, font, tbm);
                final BackAction backAction = new BackAction(iControl);
                backAction.setEnabled(false);
                tbm.add((IAction)backAction);
                final ForwardAction forwardAction = new ForwardAction(iControl);
                tbm.add((IAction)forwardAction);
                forwardAction.setEnabled(false);
                final OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(iControl);
                tbm.add((IAction)openDeclarationAction);
                IInputChangedListener inputChangeListener = new IInputChangedListener(){

                    public void inputChanged(Object newInput) {
                        backAction.update();
                        forwardAction.update();
                        if (newInput != null && newInput instanceof BrowserInformationControlInput) {
                            BrowserInformationControlInput input = (BrowserInformationControlInput)newInput;
                            Object inputElement = input.getInputElement();
                            boolean isJavaElementInput = inputElement instanceof IModelElement;
                            openDeclarationAction.setEnabled(isJavaElementInput);
                        }
                    }
                };
                iControl.addInputChangeListener(inputChangeListener);
                tbm.update(true);
                PHPDocumentationHover.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, true);
        }
    }
}

