/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.php.internal.ui.editor.contentassist.CompletionProposalComparator;
import org.eclipse.php.internal.ui.editor.hover.AbstractAnnotationHover;
import org.eclipse.php.internal.ui.text.correction.AssistContext;
import org.eclipse.php.internal.ui.text.correction.IProblemLocation;
import org.eclipse.php.internal.ui.text.correction.PHPCorrectionProcessor;
import org.eclipse.php.internal.ui.text.correction.ProblemLocation;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ProblemHover
extends AbstractAnnotationHover
implements IPHPTextHover {
    public ProblemHover() {
        super(false);
    }

    @Override
    protected AbstractAnnotationHover.AnnotationInfo createAnnotationInfo(Annotation annotation, Position position, ITextViewer textViewer) {
        return new ProblemInfo(annotation, position, textViewer);
    }

    @Override
    public IHoverMessageDecorator getMessageDecorator() {
        return null;
    }

    protected static class ProblemInfo
    extends AbstractAnnotationHover.AnnotationInfo {
        private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];

        public ProblemInfo(Annotation annotation, Position position, ITextViewer textViewer) {
            super(annotation, position, textViewer);
        }

        @Override
        public ICompletionProposal[] getCompletionProposals() {
            ICompletionProposal[] result;
            if (this.annotation instanceof IScriptAnnotation && (result = this.getScriptAnnotationFixes((IScriptAnnotation)this.annotation)).length > 0) {
                return result;
            }
            if (this.annotation instanceof MarkerAnnotation) {
                return this.getMarkerAnnotationFixes((MarkerAnnotation)this.annotation);
            }
            return NO_PROPOSALS;
        }

        private ICompletionProposal[] getScriptAnnotationFixes(IScriptAnnotation scriptAnnotation) {
            ProblemLocation location = new ProblemLocation(this.position.getOffset(), this.position.getLength(), scriptAnnotation);
            ISourceModule cu = scriptAnnotation.getSourceModule();
            if (cu == null) {
                return NO_PROPOSALS;
            }
            ISourceViewer sourceViewer = null;
            if (this.viewer instanceof ISourceViewer) {
                sourceViewer = (ISourceViewer)this.viewer;
            }
            AssistContext context = new AssistContext(cu, sourceViewer, location.getOffset(), location.getLength(), SharedASTProvider.WAIT_ACTIVE_ONLY);
            ArrayList proposals = new ArrayList();
            PHPCorrectionProcessor.collectCorrections(context, new IProblemLocation[]{location}, proposals);
            Collections.sort(proposals, new CompletionProposalComparator());
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        private ICompletionProposal[] getMarkerAnnotationFixes(MarkerAnnotation markerAnnotation) {
            if (markerAnnotation.isQuickFixableStateSet() && !markerAnnotation.isQuickFixable()) {
                return NO_PROPOSALS;
            }
            IMarker marker = markerAnnotation.getMarker();
            ISourceModule cu = ProblemInfo.getSourceModule(marker);
            if (cu == null) {
                return NO_PROPOSALS;
            }
            IEditorInput input = EditorUtility.getEditorInput((Object)cu);
            if (input == null) {
                return NO_PROPOSALS;
            }
            IAnnotationModel model = DLTKUIPlugin.getDocumentProvider().getAnnotationModel((Object)input);
            if (model == null) {
                return NO_PROPOSALS;
            }
            ISourceViewer sourceViewer = null;
            if (this.viewer instanceof ISourceViewer) {
                sourceViewer = (ISourceViewer)this.viewer;
            }
            AssistContext context = new AssistContext(cu, sourceViewer, this.position.getOffset(), this.position.getLength());
            ArrayList proposals = new ArrayList();
            PHPCorrectionProcessor.collectProposals(context, model, new Annotation[]{markerAnnotation}, true, false, proposals);
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        private static ISourceModule getSourceModule(IMarker marker) {
            IModelElement element;
            IResource res = marker.getResource();
            if (res instanceof IFile && res.isAccessible() && (element = DLTKCore.create((IFile)((IFile)res))) instanceof ISourceModule) {
                return (ISourceModule)element;
            }
            return null;
        }
    }
}

