/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.phar.wizard;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.tar.TarEntry;
import org.eclipse.php.internal.core.tar.TarException;
import org.eclipse.php.internal.core.tar.TarFile;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;

public class TarLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private TarFile tarFile;
    private TarEntry root = new TarEntry("/");
    private Map children;
    private Map directoryEntryCache = new HashMap();
    private int stripLevel;

    public TarLeveledStructureProvider(TarFile sourceFile) {
        this.tarFile = sourceFile;
        this.root.setFileType(53);
    }

    protected TarEntry createContainer(IPath pathname) {
        TarEntry existingEntry = (TarEntry)this.directoryEntryCache.get(pathname);
        if (existingEntry != null) {
            return existingEntry;
        }
        TarEntry parent = pathname.segmentCount() == 1 ? this.root : this.createContainer(pathname.removeLastSegments(1));
        TarEntry newEntry = new TarEntry(pathname.toString());
        newEntry.setFileType(53);
        this.directoryEntryCache.put(pathname, newEntry);
        ArrayList childList = new ArrayList();
        this.children.put(newEntry, childList);
        List parentChildList = (List)this.children.get(parent);
        parentChildList.add(newEntry);
        return newEntry;
    }

    protected void createFile(TarEntry entry) {
        Path pathname = new Path(entry.getName());
        TarEntry parent = pathname.segmentCount() == 1 ? this.root : (TarEntry)this.directoryEntryCache.get(pathname.removeLastSegments(1));
        List childList = (List)this.children.get(parent);
        childList.add(entry);
    }

    public List getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return (List)this.children.get(element);
    }

    public InputStream getContents(Object element) {
        try {
            return this.tarFile.getInputStream((TarEntry)element);
        }
        catch (TarException e) {
            IDEWorkbenchPlugin.log((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public ResourceAttributes getResourceAttributes(Object element) {
        ResourceAttributes attributes = new ResourceAttributes();
        TarEntry entry = (TarEntry)element;
        attributes.setExecutable((entry.getMode() & 0x40L) != 0L);
        attributes.setReadOnly((entry.getMode() & 0x80L) == 0L);
        return attributes;
    }

    public String getFullPath(Object element) {
        return this.stripPath(((TarEntry)element).getName());
    }

    public String getLabel(Object element) {
        if (element.equals(this.root)) {
            return ((TarEntry)element).getName();
        }
        return this.stripPath(new Path(((TarEntry)element).getName()).lastSegment());
    }

    public Object getRoot() {
        return this.root;
    }

    public TarFile getTarFile() {
        return this.tarFile;
    }

    public boolean closeArchive() {
        try {
            this.getTarFile().close();
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)(String.valueOf(DataTransferMessages.ZipImport_couldNotClose) + this.getTarFile().getName()), (Throwable)e);
            return false;
        }
        return true;
    }

    protected void initialize() {
        this.children = new HashMap(1000);
        this.children.put(this.root, new ArrayList());
        Enumeration entries = this.tarFile.entries();
        while (entries.hasMoreElements()) {
            TarEntry entry = (TarEntry)entries.nextElement();
            IPath path = new Path(entry.getName()).addTrailingSeparator();
            if (entry.getFileType() == 53) {
                this.createContainer(path);
                continue;
            }
            int pathSegmentCount = path.segmentCount();
            if (pathSegmentCount > 1) {
                this.createContainer(path.uptoSegment(pathSegmentCount - 1));
            }
            this.createFile(entry);
        }
    }

    public boolean isFolder(Object element) {
        return ((TarEntry)element).getFileType() == 53;
    }

    private String stripPath(String path) {
        String pathOrig = path;
        int i = 0;
        while (i < this.stripLevel) {
            int firstSep = path.indexOf(47);
            if (firstSep == 0) {
                path = path.substring(1);
                firstSep = path.indexOf(47);
            }
            if (firstSep == -1) {
                return pathOrig;
            }
            path = path.substring(firstSep);
            ++i;
        }
        return path;
    }

    public void setStrip(int level) {
        this.stripLevel = level;
    }

    public int getStrip() {
        return this.stripLevel;
    }
}

