/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.php.internal.ui.text.correction.proposals.AbstractCorrectionProposal;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class ChangeCorrectionProposal
extends AbstractCorrectionProposal {
    private Change fChange;

    public ChangeCorrectionProposal(String name, Change change, int relevance, Image image) {
        this(name, change, relevance, image, null);
    }

    public ChangeCorrectionProposal(String name, Change change, int relevance, Image image, String commandId) {
        super(name, relevance, image, commandId);
        this.fChange = change;
    }

    public void apply(IDocument document) {
        try {
            this.performChange(PHPUiPlugin.getActivePage().getActiveEditor(), document);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, CorrectionMessages.ChangeCorrectionProposal_error_title, CorrectionMessages.ChangeCorrectionProposal_error_message);
        }
    }

    protected void performChange(IEditorPart activeEditor, IDocument document) throws CoreException {
        block12: {
            Change change = null;
            IRewriteTarget rewriteTarget = null;
            try {
                Change undoChange;
                change = this.getChange();
                if (change == null) break block12;
                if (document != null) {
                    LinkedModeModel.closeAllModels((IDocument)document);
                }
                if (activeEditor != null && (rewriteTarget = (IRewriteTarget)activeEditor.getAdapter(IRewriteTarget.class)) != null) {
                    rewriteTarget.beginCompoundChange();
                }
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                RefactoringStatus valid = change.isValid((IProgressMonitor)new NullProgressMonitor());
                if (valid.hasFatalError()) {
                    Status status = new Status(4, "org.eclipse.php.ui", 4, valid.getMessageMatchingSeverity(4), null);
                    throw new CoreException((IStatus)status);
                }
                IUndoManager manager = RefactoringCore.getUndoManager();
                boolean successful = false;
                try {
                    manager.aboutToPerformChange(change);
                    undoChange = change.perform((IProgressMonitor)new NullProgressMonitor());
                    successful = true;
                }
                finally {
                    manager.changePerformed(change, successful);
                }
                if (undoChange != null) {
                    undoChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    manager.addUndo(this.getName(), undoChange);
                }
            }
            finally {
                if (rewriteTarget != null) {
                    rewriteTarget.endCompoundChange();
                }
                if (change != null) {
                    change.dispose();
                }
            }
        }
    }

    public String getAdditionalProposalInfo() {
        Object info = this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        return info == null ? null : info.toString();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        StringBuffer buf;
        block3: {
            String name;
            block4: {
                buf = new StringBuffer();
                buf.append("<p>");
                Change change = this.getChange();
                if (change == null) break block3;
                name = change.getName();
                if (name.length() != 0) break block4;
                return null;
            }
            try {
                buf.append(name);
            }
            catch (CoreException e) {
                buf.append(CorrectionMessages.ChangeCorrectionProposal_2);
                buf.append(e.getLocalizedMessage());
                buf.append("</pre>");
            }
        }
        return null;
        buf.append("</p>");
        return buf.toString();
    }

    public final Change getChange() throws CoreException {
        if (this.fChange == null) {
            this.fChange = this.createChange();
        }
        return this.fChange;
    }

    protected Change createChange() throws CoreException {
        return new NullChange();
    }
}

