/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ForStatement
extends Statement {
    private final ASTNode.NodeList<Expression> initializers = new ASTNode.NodeList(INITIALIZERS_PROPERTY);
    private final ASTNode.NodeList<Expression> conditions = new ASTNode.NodeList(EXPRESSION_PROPERTY);
    private final ASTNode.NodeList<Expression> updaters = new ASTNode.NodeList(UPDATERS_PROPERTY);
    private Statement body;
    public static final ChildListPropertyDescriptor INITIALIZERS_PROPERTY = new ChildListPropertyDescriptor(ForStatement.class, "initializers", Expression.class, true);
    public static final ChildListPropertyDescriptor EXPRESSION_PROPERTY = new ChildListPropertyDescriptor(ForStatement.class, "conditions", Expression.class, true);
    public static final ChildListPropertyDescriptor UPDATERS_PROPERTY = new ChildListPropertyDescriptor(ForStatement.class, "updaters", Expression.class, true);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(ForStatement.class, "body", Statement.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(4);
        properyList.add(INITIALIZERS_PROPERTY);
        properyList.add(EXPRESSION_PROPERTY);
        properyList.add(UPDATERS_PROPERTY);
        properyList.add(BODY_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public static List<StructuralPropertyDescriptor> propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    private ForStatement(int start, int end, AST ast, Expression[] initializations, Expression[] conditions, Expression[] increasements, Statement action) {
        super(start, end, ast);
        if (initializations == null || conditions == null || increasements == null || action == null) {
            throw new IllegalArgumentException();
        }
        Expression[] expressionArray = initializations;
        int n = initializations.length;
        int n2 = 0;
        while (n2 < n) {
            Expression init = expressionArray[n2];
            this.initializers.add(init);
            ++n2;
        }
        expressionArray = conditions;
        n = conditions.length;
        n2 = 0;
        while (n2 < n) {
            Expression cond = expressionArray[n2];
            this.conditions.add(cond);
            ++n2;
        }
        expressionArray = increasements;
        n = increasements.length;
        n2 = 0;
        while (n2 < n) {
            Expression inc = expressionArray[n2];
            this.updaters.add(inc);
            ++n2;
        }
        this.setBody(action);
    }

    public ForStatement(int start, int end, AST ast, List initializations, List conditions, List increasements, Statement action) {
        this(start, end, ast, initializations == null ? null : initializations.toArray(new Expression[initializations.size()]), conditions == null ? null : conditions.toArray(new Expression[conditions.size()]), increasements == null ? null : increasements.toArray(new Expression[increasements.size()]), action);
    }

    public ForStatement(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.initializers) {
            aSTNode.accept(visitor);
        }
        for (ASTNode aSTNode : this.conditions) {
            aSTNode.accept(visitor);
        }
        for (ASTNode aSTNode : this.updaters) {
            aSTNode.accept(visitor);
        }
        this.body.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        for (ASTNode aSTNode : this.initializers) {
            aSTNode.traverseTopDown(visitor);
        }
        for (ASTNode aSTNode : this.conditions) {
            aSTNode.traverseTopDown(visitor);
        }
        for (ASTNode aSTNode : this.updaters) {
            aSTNode.traverseTopDown(visitor);
        }
        this.body.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.initializers) {
            aSTNode.traverseBottomUp(visitor);
        }
        for (ASTNode aSTNode : this.conditions) {
            aSTNode.traverseBottomUp(visitor);
        }
        for (ASTNode aSTNode : this.updaters) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.body.traverseBottomUp(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ForStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Initializations>\n");
        for (ASTNode aSTNode : this.initializers) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Initializations>\n");
        buffer.append("\t").append(tab).append("<Conditions>\n");
        for (ASTNode aSTNode : this.conditions) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Conditions>\n");
        buffer.append("\t").append(tab).append("<Increasements>\n");
        for (ASTNode aSTNode : this.updaters) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Increasements>\n");
        this.body.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</ForStatement>");
    }

    @Override
    public int getType() {
        return 28;
    }

    public List<Expression> initializers() {
        return this.initializers;
    }

    public List<Expression> conditions() {
        return this.conditions;
    }

    public List<Expression> updaters() {
        return this.updaters;
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException();
        }
        Statement oldChild = this.body;
        this.preReplaceChild(oldChild, statement, BODY_PROPERTY);
        this.body = statement;
        this.postReplaceChild(oldChild, statement, BODY_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List inits = ASTNode.copySubtrees(target, this.initializers());
        List conds = ASTNode.copySubtrees(target, this.conditions());
        List updtaters = ASTNode.copySubtrees(target, this.updaters());
        Statement body = ASTNode.copySubtree(target, this.getBody());
        ForStatement result = new ForStatement(this.getStart(), this.getEnd(), target, inits, conds, updtaters, body);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == INITIALIZERS_PROPERTY) {
            return this.initializers();
        }
        if (property == EXPRESSION_PROPERTY) {
            return this.conditions();
        }
        if (property == UPDATERS_PROPERTY) {
            return this.updaters();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }
}

