/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.ast.nodes.BindingResolver;
import org.eclipse.php.internal.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;

public class FunctionBinding
implements IFunctionBinding {
    protected static final int VALID_MODIFIERS = 245;
    protected BindingResolver resolver;
    protected IMethod modelElement;

    public FunctionBinding(BindingResolver resolver, IMethod modelElement) {
        this.resolver = resolver;
        this.modelElement = modelElement;
    }

    @Override
    public ITypeBinding[] getExceptionTypes() {
        return null;
    }

    @Override
    public String getName() {
        return this.modelElement.getElementName();
    }

    @Override
    public ITypeBinding[] getParameterTypes() {
        return null;
    }

    @Override
    public ITypeBinding[] getReturnType() {
        return this.resolver.getMethodReturnTypeBinding(this.modelElement);
    }

    @Override
    public boolean isVarargs() {
        return false;
    }

    @Override
    public String getKey() {
        return this.modelElement.getHandleIdentifier();
    }

    @Override
    public int getKind() {
        return 4;
    }

    @Override
    public int getModifiers() {
        try {
            return this.modelElement.getFlags() & 0xF5;
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    @Override
    public IModelElement getPHPElement() {
        return this.modelElement;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }
}

