/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class ConstantDeclaration
extends Declaration
implements IPHPDocAwareDeclaration {
    private final ConstantReference constant;
    private final Expression initializer;
    private PHPDocBlock phpDoc;

    public ConstantDeclaration(ConstantReference constant, Expression initializer, int start, int end, PHPDocBlock phpDoc) {
        super(start, end);
        assert (constant != null);
        assert (initializer != null);
        this.constant = constant;
        this.initializer = initializer;
        this.phpDoc = phpDoc;
        this.setName(constant.getName());
    }

    @Override
    public PHPDocBlock getPHPDoc() {
        return this.phpDoc;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            this.constant.traverse(visitor);
            this.initializer.traverse(visitor);
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 11;
    }

    public Expression getConstantValue() {
        return this.initializer;
    }

    public ConstantReference getConstantName() {
        return this.constant;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

