/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.corext.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.visitor.PHPASTVisitor;

public class DocumentUtils {
    public static List<UseStatement> flatten(List<UseStatement> statements) {
        Vector<UseStatement> total = new Vector<UseStatement>();
        for (UseStatement statement : statements) {
            for (UsePart part : statement.getParts()) {
                Vector<UsePart> parts = new Vector<UsePart>();
                parts.add(part);
                total.add(new UseStatement(statement.start(), statement.end(), parts));
            }
        }
        return total;
    }

    public static boolean containsUseStatement(UsePart part, String contents, List<Position> excludePositions) {
        String className = part.getAlias() != null ? part.getAlias().toString() : (part.getNamespace() != null ? part.getNamespace().toString() : "");
        Pattern p = Pattern.compile("(?i)\\b(" + Pattern.quote(className) + ")\\b");
        Matcher m = p.matcher(contents);
        int restartPos = 0;
        block0: while (m.find()) {
            if (excludePositions.isEmpty()) {
                return true;
            }
            int i = restartPos;
            while (i < excludePositions.size()) {
                Position position = excludePositions.get(i);
                if (position.getOffset() + position.getLength() <= m.start()) {
                    if (i == excludePositions.size() - 1) {
                        return true;
                    }
                    ++restartPos;
                } else {
                    if (position.getOffset() >= m.end()) {
                        return true;
                    }
                    assert (position.getOffset() <= m.start() && m.end() <= position.getOffset() + position.getLength());
                    continue block0;
                }
                ++i;
            }
        }
        return false;
    }

    public static List<Position> getExcludeSortedAndFilteredPositions(ASTNode[] nodes) {
        ArrayList<Position> excludePositions = new ArrayList<Position>();
        ASTNode[] aSTNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode n3 = aSTNodeArray[n2];
            if (!(n3 instanceof PHPDocBlock)) {
                excludePositions.add(new Position(n3.sourceStart(), n3.sourceEnd() - n3.sourceStart()));
            }
            ++n2;
        }
        return excludePositions;
    }

    public static String stripUseStatements(UseStatement[] statements, IDocument old_doc, List<Position> excludePositions) {
        return DocumentUtils.stripUseStatements(statements, old_doc, 0, old_doc.getLength(), excludePositions);
    }

    public static String stripUseStatements(UseStatement[] statements, IDocument old_doc, int start, int end, List<Position> excludePositions) {
        int offset = 0;
        int lowestStatementStart = Integer.MAX_VALUE;
        Document doc = new Document(old_doc.get());
        UseStatement[] useStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            UseStatement statement = useStatementArray[n2];
            if (statement.sourceStart() >= start && statement.sourceEnd() <= end) {
                int length = statement.sourceEnd() - statement.sourceStart();
                lowestStatementStart = Math.min(lowestStatementStart, statement.sourceStart());
                try {
                    doc.replace(statement.sourceStart() - offset, length, "");
                }
                catch (BadLocationException badLocationException) {}
                offset += length;
            }
            ++n2;
        }
        if (offset > 0) {
            int i = excludePositions.size() - 1;
            while (i >= 0) {
                Position position = excludePositions.get(i);
                if (position.getOffset() < lowestStatementStart) break;
                position.setOffset(position.getOffset() - offset);
                --i;
            }
        }
        try {
            return doc.get(start, end - offset - start);
        }
        catch (BadLocationException badLocationException) {
            return doc.get();
        }
    }

    public static String createStringFromUseStatement(List<UseStatement> statements, String indent) {
        StringBuilder total = new StringBuilder();
        for (UseStatement statement : statements) {
            total.append(DocumentUtils.createStringFromUseStatement(statement, indent));
        }
        return total.toString().trim();
    }

    public static String createStringFromUseStatement(UseStatement statement) {
        return DocumentUtils.createStringFromUseStatement(statement, "");
    }

    public static String createStringFromUseStatement(UseStatement statement, String indent) {
        String use = String.valueOf(indent) + "use ";
        boolean first = true;
        for (UsePart part : statement.getParts()) {
            if (!first) {
                use = String.valueOf(use) + ", ";
            }
            use = String.valueOf(use) + part.getNamespace().getFullyQualifiedName();
            if (part.getAlias() != null) {
                use = String.valueOf(use) + " as " + part.getAlias().getName();
            }
            first = false;
        }
        return String.valueOf(use) + ";\n";
    }

    public static List<UseStatement> filterAndSort(UseStatement[] statements, IDocument doc, ModuleDeclaration moduleDeclaration) {
        Vector<UseStatement> total = new Vector<UseStatement>();
        NamespaceFinder visitor = new NamespaceFinder();
        try {
            moduleDeclaration.traverse((ASTVisitor)visitor);
        }
        catch (Exception exception) {}
        UseStatement[] useStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            UseStatement statement = useStatementArray[n2];
            List<Object> excludePositions = moduleDeclaration instanceof PHPModuleDeclaration ? DocumentUtils.getExcludeSortedAndFilteredPositions(((PHPModuleDeclaration)moduleDeclaration).getCommentList().toArray(new ASTNode[0])) : new ArrayList();
            NamespaceDeclaration currentNamespace = visitor.getNamespaceDeclarationFor(statement);
            String contents = currentNamespace != null && currentNamespace.isBracketed() ? DocumentUtils.stripUseStatements(statements, doc, currentNamespace.sourceStart(), currentNamespace.sourceEnd(), excludePositions) : DocumentUtils.stripUseStatements(statements, doc, excludePositions);
            Vector<UsePart> parts = new Vector<UsePart>();
            for (UsePart part : statement.getParts()) {
                if (!DocumentUtils.containsUseStatement(part, contents, excludePositions)) continue;
                parts.add(part);
            }
            if (parts.size() > 0) {
                total.add(new UseStatement(statement.start(), statement.end(), parts));
            }
            ++n2;
        }
        Collections.sort(total, new Comparator<UseStatement>(){

            @Override
            public int compare(UseStatement a, UseStatement b) {
                String partA = DocumentUtils.createStringFromUseStatement(a).trim().toLowerCase();
                String partB = DocumentUtils.createStringFromUseStatement(b).trim().toLowerCase();
                String[] partsA = partA.substring(4, partA.length() - 1).split("\\\\");
                String[] partsB = partB.substring(4, partB.length() - 1).split("\\\\");
                int checkLength = Math.min(partsA.length, partsB.length);
                int i = 0;
                while (i < checkLength) {
                    int comp = partsA[i].compareTo(partsB[i]);
                    if (comp != 0) {
                        return comp;
                    }
                    ++i;
                }
                return partsA.length == partsB.length ? 1 : 0;
            }
        });
        return total;
    }

    public static void sortUseStatements(ModuleDeclaration moduleDeclaration, IDocument doc) {
        UseStatement[] statements = ASTUtils.getUseStatements(moduleDeclaration, doc.getLength());
        int start = 0;
        Vector<ReplaceAction> queue = new Vector<ReplaceAction>();
        while (start < statements.length) {
            int last_item = statements.length - 1;
            int i = start;
            while (i < statements.length - 1) {
                block10: {
                    try {
                        if (doc.getLineOfOffset(statements[i + 1].sourceStart()) > doc.getLineOfOffset(statements[i].sourceStart()) + 1) {
                            last_item = i;
                        }
                        break block10;
                    }
                    catch (BadLocationException badLocationException) {
                        last_item = i;
                    }
                    break;
                }
                ++i;
            }
            String indent = "";
            try {
                int lineOffset = doc.getLineOffset(doc.getLineOfOffset(statements[start].sourceStart()));
                indent = doc.get(lineOffset, statements[start].sourceStart() - lineOffset);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            queue.add(new ReplaceAction(DocumentUtils.filterAndSort(Arrays.copyOfRange(statements, start, last_item + 1), doc, moduleDeclaration), statements[start].sourceStart(), statements[last_item].sourceEnd(), indent));
            start = last_item + 1;
        }
        int offset = 0;
        for (ReplaceAction item : queue) {
            List<UseStatement> sorted = item.statements;
            int length = item.end - item.start;
            String newNamespaces = DocumentUtils.createStringFromUseStatement(sorted, item.indent);
            try {
                doc.replace(item.start - offset, length, newNamespaces);
            }
            catch (BadLocationException badLocationException) {}
            offset += length - newNamespaces.length();
        }
    }

    private static class NamespaceFinder
    extends PHPASTVisitor {
        Vector<NamespaceDeclaration> declarations = new Vector();

        private NamespaceFinder() {
        }

        @Override
        public boolean visit(NamespaceDeclaration n) throws Exception {
            this.declarations.add(n);
            return super.visit(n);
        }

        public NamespaceDeclaration getNamespaceDeclarationFor(UseStatement statement) {
            for (NamespaceDeclaration n : this.declarations) {
                if (n.sourceStart() > statement.sourceStart() || n.sourceEnd() < statement.sourceEnd()) continue;
                return n;
            }
            return null;
        }
    }

    private static class ReplaceAction {
        public List<UseStatement> statements;
        public int start;
        public int end;
        public String indent;

        public ReplaceAction(List<UseStatement> statements, int start, int end, String indent) {
            this.statements = statements;
            this.start = start;
            this.end = end;
            this.indent = indent;
        }
    }
}

