/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.internal.core.typeinference.GeneratorClassType;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;
import org.eclipse.php.internal.core.typeinference.goals.AbstractMethodReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.IteratorTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocMethodReturnTypeGoal;

public class IteratorTypeGoalEvaluator
extends GoalEvaluator {
    private IEvaluatedType result;

    public IteratorTypeGoalEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        IteratorTypeGoal typedGoal = (IteratorTypeGoal)this.goal;
        return new IGoal[]{new ExpressionTypeGoal(this.goal.getContext(), typedGoal.getExpression())};
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        IModelAccessCache cache = null;
        if (this.goal.getContext() instanceof IModelCacheContext) {
            cache = ((IModelCacheContext)this.goal.getContext()).getCache();
        }
        String variableName = null;
        IteratorTypeGoal iteratorTypeGoal = (IteratorTypeGoal)this.goal;
        if (iteratorTypeGoal.getExpression() instanceof VariableReference) {
            variableName = ((VariableReference)iteratorTypeGoal.getExpression()).getName();
        }
        if (state != GoalState.RECURSIVE) {
            if (result instanceof GeneratorClassType) {
                MultiTypeType type = new MultiTypeType();
                type.getTypes().addAll(((GeneratorClassType)((Object)result)).getTypes());
                this.result = type;
                return IGoal.NO_GOALS;
            }
            if (result instanceof PHPClassType) {
                block12: {
                    if (subgoal instanceof ExpressionTypeGoal) {
                        ISourceModule sourceModule = ((ISourceModuleContext)subgoal.getContext()).getSourceModule();
                        PHPClassType classType = (PHPClassType)((Object)result);
                        LinkedList<AbstractMethodReturnTypeGoal> subGoals = new LinkedList<AbstractMethodReturnTypeGoal>();
                        try {
                            IType[] types;
                            IType[] iTypeArray = types = PHPModelUtils.getTypes(classType.getTypeName(), sourceModule, 0, cache, null);
                            int n = types.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MethodContext methodContext;
                                IType type = iTypeArray[n2];
                                IType[] superTypes = PHPModelUtils.getSuperClasses(type, cache == null ? null : cache.getSuperTypeHierarchy(type, null));
                                if (subgoal.getContext() instanceof MethodContext && this.isArrayType(methodContext = (MethodContext)subgoal.getContext(), variableName, type)) {
                                    MultiTypeType mType = new MultiTypeType();
                                    mType.addType((IEvaluatedType)result);
                                    this.result = mType;
                                    return IGoal.NO_GOALS;
                                }
                                if (this.isImplementedIterator(superTypes)) {
                                    subGoals.add(new MethodElementReturnTypeGoal(subgoal.getContext(), new IType[]{type}, "current", new String[0], type.getSourceRange().getOffset()));
                                    subGoals.add(new PHPDocMethodReturnTypeGoal(subgoal.getContext(), new IType[]{type}, "current", new String[0], type.getSourceRange().getOffset()));
                                }
                                ++n2;
                            }
                            if (subGoals.size() == 0) {
                                MultiTypeType mType = new MultiTypeType();
                                mType.addType((IEvaluatedType)result);
                                this.result = mType;
                                return IGoal.NO_GOALS;
                            }
                            return subGoals.toArray(new IGoal[subGoals.size()]);
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) break block12;
                            e.printStackTrace();
                        }
                    }
                }
                MultiTypeType type = new MultiTypeType();
                type.addType((IEvaluatedType)result);
                this.result = type;
                return IGoal.NO_GOALS;
            }
            this.result = (IEvaluatedType)result;
        }
        return IGoal.NO_GOALS;
    }

    private boolean isArrayType(MethodContext methodContext, String variableName, IType type) {
        PHPMethodDeclaration methodDeclaration = (PHPMethodDeclaration)methodContext.getMethodNode();
        PHPDocBlock[] docBlocks = new PHPDocBlock[]{};
        for (Object object : methodDeclaration.getArguments()) {
            FormalParameter formalParameter;
            if (!(object instanceof FormalParameter) || !(formalParameter = (FormalParameter)((Object)object)).getName().equals(variableName) || !formalParameter.isVariadic()) continue;
            return true;
        }
        try {
            IMethod method;
            IModelElement element = methodContext.getSourceModule().getElementAt(methodDeclaration.getNameStart());
            docBlocks = element instanceof IMethod ? ((method = (IMethod)element).getDeclaringType() != null ? PHPModelUtils.getTypeHierarchyMethodDoc(method.getDeclaringType(), methodContext.getCache() != null ? methodContext.getCache().getSuperTypeHierarchy(method.getDeclaringType(), null) : null, method.getElementName(), true, null) : new PHPDocBlock[]{methodDeclaration.getPHPDoc()}) : new PHPDocBlock[]{methodDeclaration.getPHPDoc()};
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (docBlocks.length > 0) {
            int i = 0;
            while (i < docBlocks.length) {
                if (docBlocks[i] != null) {
                    PHPDocTag[] tags = docBlocks[i].getTags(PHPDocTag.TagKind.PARAM);
                    int j = 0;
                    while (j < tags.length) {
                        PHPDocTag tag = tags[j];
                        if (tag.isValidParamTag() && tag.getVariableReference().getName().equals(variableName)) {
                            for (TypeReference reference : tag.getTypeReferences()) {
                                if (!PHPEvaluationUtils.isArrayType(reference.getName())) continue;
                                return true;
                            }
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isImplementedIterator(IType[] superClasses) {
        if (superClasses == null) {
            return false;
        }
        IType[] iTypeArray = superClasses;
        int n = superClasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType superClass = iTypeArray[n2];
            if (superClass.getFullyQualifiedName().equalsIgnoreCase("Iterator")) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

