/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.changes;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.changes.ProgramFileChange;
import org.eclipse.php.refactoring.core.rename.AbstractRenameRefactoringTest;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProgramFileChangeTest
extends AbstractRenameRefactoringTest {
    private IProject project1;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("project1");
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.file = folder.getFile("ProgramFilechange.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php class Item { public static function foo(){} } class ItemEx extends Item{public static function foo(){}} ItemEx::foo();?>".getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testGetProgram() throws Exception {
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        ProgramFileChange change = new ProgramFileChange("TestFile", this.file, program);
        Assert.assertEquals((Object)program, (Object)change.getProgram());
        Assert.assertEquals((Object)program, (Object)change.getAdapter(Program.class));
    }

    @Test
    public void testGetCurrentContent() throws Exception {
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        ProgramFileChange change = new ProgramFileChange("TestFile", this.file, program);
        try {
            String content = change.getCurrentContent((IRegion)new Region(0, 126), true, 2, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals((Object)"<?php class Item { public static function foo(){} } class ItemEx extends Item{public static function foo(){}} ItemEx::foo();?>", (Object)content);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

