/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.rename.AbstractRenameRefactoringTest;
import org.eclipse.php.refactoring.core.rename.RenameClassProcessor;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameProcessorTestCase0027134
extends AbstractRenameRefactoringTest {
    private IProject project1;

    @Before
    public void setUp() throws Exception {
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testRename1() throws Exception {
        System.setProperty("disableStartupRunner", "true");
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("project1", PHPVersion.PHP5_3);
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile file1 = folder.getFile("test0027134_1.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php class MyClass{} ?>".getBytes());
        if (!file1.exists()) {
            file1.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file1.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile file2 = folder.getFile("test0027134_2.php");
        source = new ByteArrayInputStream("<?php include 'test0027134_1.php'; class SecondClass extends MyClass{} ?>".getBytes());
        if (!file2.exists()) {
            file2.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file2.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        Program program = this.createProgram(file1);
        Assert.assertNotNull((Object)program);
        int start = 12;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        RenameClassProcessor processor = new RenameClassProcessor(file1, selectedNode);
        processor.setNewElementName("MyClass1");
        processor.setUpdateTextualMatches(true);
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        try {
            String content = FileUtils.getContents(file1);
            Assert.assertEquals((Object)"<?php class MyClass1{} ?>", (Object)content);
            content = FileUtils.getContents(file2);
            Assert.assertEquals((Object)"<?php include 'test0027134_1.php'; class SecondClass extends MyClass1{} ?>", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testRename2() throws Exception {
        System.setProperty("disableStartupRunner", "true");
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("project1", PHPVersion.PHP5_3);
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile file1 = folder.getFile("test100271341.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php class MyClass{} ?>".getBytes());
        if (!file1.exists()) {
            file1.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file1.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile file2 = folder.getFile("test00271342.php");
        source = new ByteArrayInputStream("<?php class SecondClass extends MyClass{} ?>".getBytes());
        if (!file2.exists()) {
            file2.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file2.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        Program program = this.createProgram(file2);
        Assert.assertNotNull((Object)program);
        int start = 33;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        RenameClassProcessor processor = new RenameClassProcessor(file2, selectedNode);
        processor.setNewElementName("MyClass2");
        processor.setUpdateTextualMatches(true);
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        try {
            String content = FileUtils.getContents(file1);
            Assert.assertEquals((Object)"<?php class MyClass2{} ?>", (Object)content);
            content = FileUtils.getContents(file2);
            Assert.assertEquals((Object)"<?php class SecondClass extends MyClass2{} ?>", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

