/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.php.internal.core.ast.nodes.Program;

public class ProgramFileChange
extends TextFileChange {
    private final Program program;

    public ProgramFileChange(String name, IFile file, Program program) {
        super(name, file);
        this.program = program;
    }

    public Program getProgram() {
        return this.program;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Program.class) {
            return this.program;
        }
        return super.getAdapter(adapter);
    }

    public String getCurrentContent(IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        Region fixed = new Region(0, region.getOffset() + region.getLength());
        return super.getCurrentContent((IRegion)fixed, expandRegionToFullLine, surroundingLines, pm);
    }

    public String getPreviewContent(TextEditBasedChangeGroup[] changeGroups, IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        Region fixed = new Region(0, region.getOffset() + region.getLength());
        return super.getPreviewContent(changeGroups, (IRegion)fixed, expandRegionToFullLine, surroundingLines, pm);
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        return super.acquireDocument(pm);
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        boolean isModified = this.isDocumentModified();
        super.releaseDocument(document, pm);
        ISourceModule sm = this.program.getSourceModule();
        if (isModified && !this.isDocumentAcquired()) {
            if (sm.isWorkingCopy()) {
                sm.reconcile(false, null, null);
            } else {
                sm.makeConsistent(pm);
            }
        }
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        super.commit(document, pm);
    }
}

