/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import java.util.ArrayList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.changes.PHPProjectMoveChange;

public class PHPProjectMoveProcessor
extends MoveProcessor {
    private String fResourceDestination;
    private IProject fProject;
    private boolean fUpdateReferences;

    public PHPProjectMoveProcessor(IProject project) {
        this.fProject = project;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new PHPProjectMoveChange(URIUtil.toURI((String)this.fResourceDestination), this.fProject.getName());
    }

    public Object[] getElements() {
        return new Object[]{this.fProject};
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return PhpRefactoringCoreMessages.getString("PHPMoveProcessor.0");
    }

    public boolean isApplicable() {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) {
        try {
            String[] affectedNatures = ResourceProcessors.computeAffectedNatures((IResource)this.fProject);
            MoveArguments arguments = new MoveArguments((Object)this.fResourceDestination, this.getUpdateReferences());
            ArrayList<IProject> list = new ArrayList<IProject>();
            list.add(this.fProject);
            return ParticipantManager.loadMoveParticipants((RefactoringStatus)status, (RefactoringProcessor)this, list, (MoveArguments)arguments, null, (String[])affectedNatures, (SharableParticipants)sharedParticipants);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new RefactoringParticipant[0];
        }
    }

    public RefactoringStatus setDestination(String destination) {
        this.fResourceDestination = destination;
        return new RefactoringStatus();
    }

    public String getDestination() {
        return this.fResourceDestination;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }
}

